/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.slice.api.tag;

import com.cognifide.slice.api.context.ContextFactory;
import com.cognifide.slice.api.context.ContextProvider;
import com.cognifide.slice.api.context.RequestContextProvider;
import com.cognifide.slice.api.injector.InjectorWithContext;
import com.cognifide.slice.api.injector.InjectorsRepository;
import com.cognifide.slice.api.provider.ModelProvider;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;

public final class SliceTagUtils {
    private SliceTagUtils() {
    }

    public static <T> T getFromCurrentPath(PageContext pageContext, Class<T> type) {
        return SliceTagUtils.getFromCurrentPath(pageContext, type, null);
    }

    public static <T> T getFromCurrentPath(PageContext pageContext, Class<T> type, String appName) {
        SlingHttpServletRequest request = SliceTagUtils.slingRequestFrom(pageContext);
        InjectorsRepository injectorsRepository = SliceTagUtils.injectorsRepositoryFrom(pageContext);
        RequestContextProvider requestContextProvider = SliceTagUtils.requestContextProviderFrom(pageContext);
        return SliceTagUtils.getFromCurrentPath(request, injectorsRepository, requestContextProvider, type, appName);
    }

    public static <T> T getFromCurrentPath(SlingHttpServletRequest request, InjectorsRepository injectorsRepository, RequestContextProvider requestContextProvider, Class<T> type) {
        return SliceTagUtils.getFromCurrentPath(request, injectorsRepository, requestContextProvider, type, null);
    }

    public static <T> T getFromCurrentPath(SlingHttpServletRequest request, InjectorsRepository injectorsRepository, RequestContextProvider requestContextProvider, Class<T> type, String appName) {
        String injectorName = SliceTagUtils.getInjectorName(request, appName, injectorsRepository);
        return SliceTagUtils.getFromCurrentPath(request, injectorsRepository, requestContextProvider.getContextProvider(injectorName), type, injectorName);
    }

    public static SlingHttpServletRequest slingRequestFrom(PageContext pageContext) {
        return (SlingHttpServletRequest)pageContext.getRequest();
    }

    public static ContextProvider contextProviderFrom(PageContext pageContext) {
        return SliceTagUtils.requestContextProviderFrom(pageContext).getContextProvider(ContextFactory.COMMON_CONTEXT_NAME);
    }

    public static RequestContextProvider requestContextProviderFrom(PageContext pageContext) {
        SlingScriptHelper slingScriptHelper = SliceTagUtils.getSlingScriptHelper(pageContext);
        return (RequestContextProvider)slingScriptHelper.getService(RequestContextProvider.class);
    }

    public static InjectorsRepository injectorsRepositoryFrom(PageContext pageContext) {
        SlingScriptHelper slingScriptHelper = SliceTagUtils.getSlingScriptHelper(pageContext);
        return (InjectorsRepository)slingScriptHelper.getService(InjectorsRepository.class);
    }

    private static SlingScriptHelper getSlingScriptHelper(PageContext pageContext) {
        ServletRequest request = pageContext.getRequest();
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        return bindings.getSling();
    }

    private static String getInjectorName(SlingHttpServletRequest request, String appName, InjectorsRepository injectorsRepository) {
        String injectorName = StringUtils.isNotBlank((String)appName) ? appName : SliceTagUtils.getFromRequest(request, injectorsRepository);
        if (StringUtils.isBlank((String)injectorName)) {
            throw new IllegalStateException("Guice injector name not available");
        }
        return injectorName;
    }

    private static String getFromRequest(SlingHttpServletRequest request, InjectorsRepository injectorsRepository) {
        if (request.getResource() != null) {
            String resourceType = request.getResource().getResourceType();
            return injectorsRepository.getInjectorNameForResource(resourceType);
        }
        return "";
    }

    @Deprecated
    public static <T> T getFromCurrentPath(SlingHttpServletRequest request, InjectorsRepository injectorsRepository, ContextProvider contextProvider, Class<T> type) {
        return SliceTagUtils.getFromCurrentPath(request, injectorsRepository, contextProvider, type, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static <T> T getFromCurrentPath(SlingHttpServletRequest request, InjectorsRepository injectorsRepository, ContextProvider contextProvider, Class<T> type, String appName) {
        String injectorName = SliceTagUtils.getInjectorName(request, appName, injectorsRepository);
        if (null == contextProvider) {
            throw new IllegalStateException("ContextProvider is not available");
        }
        InjectorWithContext injector = injectorsRepository.getInjector(injectorName);
        if (injector == null) {
            throw new IllegalStateException("Guice injector not found: " + injectorName);
        }
        injector.pushContextProvider(contextProvider);
        try {
            ModelProvider modelProvider = injector.getInstance(ModelProvider.class);
            Resource resource = request.getResource();
            T t = modelProvider.get(type, resource);
            return t;
        }
        finally {
            injector.popContextProvider();
        }
    }
}

