/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.slice.util;

import com.cognifide.slice.api.context.ConstantContextProvider;
import com.cognifide.slice.api.context.Context;
import com.cognifide.slice.api.context.ContextFactory;
import com.cognifide.slice.api.context.RequestContextProvider;
import com.cognifide.slice.api.injector.InjectorWithContext;
import com.cognifide.slice.api.injector.InjectorsRepository;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;

public final class InjectorUtil {
    private InjectorUtil() {
    }

    public static InjectorWithContext getInjector(String injectorName, SlingHttpServletRequest request) {
        InjectorWithContext injector = ((InjectorsRepository)request.adaptTo(InjectorsRepository.class)).getInjector(injectorName);
        RequestContextProvider requestContextProvider = (RequestContextProvider)request.adaptTo(RequestContextProvider.class);
        injector.pushContextProvider(requestContextProvider.getContextProvider(injectorName));
        return injector;
    }

    public static InjectorWithContext getInjector(String injectorName, ResourceResolver resolver) {
        InjectorWithContext injector = ((InjectorsRepository)resolver.adaptTo(InjectorsRepository.class)).getInjector(injectorName);
        ContextFactory factory = injector.getInstance(ContextFactory.class);
        Context context = factory.getResourceResolverContext(resolver);
        injector.pushContextProvider(new ConstantContextProvider(context));
        return injector;
    }
}

