/*
 * Copyright (c) 2015 Couchbase, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALING
 * IN THE SOFTWARE.
 */

package com.couchbase.client.core.message.kv.subdoc.multi;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.AbstractKeyValueResponse;
import com.couchbase.client.core.message.kv.subdoc.BinarySubdocMultiLookupRequest;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;

import java.util.List;

/**
 * The response for a {@link BinarySubdocMultiLookupRequest}.
 *
 * @author Simon Baslé
 * @since 1.2
 */
@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MultiLookupResponse extends AbstractKeyValueResponse {

    private final List<MultiResult<Lookup>> responses;

    public MultiLookupResponse(ResponseStatus status, short serverStatusCode, String bucket, List<MultiResult<Lookup>> responses,
                               BinarySubdocMultiLookupRequest request) {
        super(status, serverStatusCode, bucket, Unpooled.EMPTY_BUFFER, request);
        this.responses = responses;
    }

    @Override
    public BinarySubdocMultiLookupRequest request() {
        return (BinarySubdocMultiLookupRequest) super.request();
    }

    /**
     * @return a list of {@link MultiResult MultiResult&lt;Lookup&gt;}, giving the individual result of each {@link LookupCommand}.
     */
    public List<MultiResult<Lookup>> responses() {
        return responses;
    }
}
