/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.internal.HttpCompletionListener;
import com.couchbase.client.protocol.views.HttpOperation;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.internal.AbstractListenableFuture;
import net.spy.memcached.internal.CheckedOperationTimeoutException;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationStatus;

public class HttpFuture<T>
extends AbstractListenableFuture<T, HttpCompletionListener>
implements Future<T> {
    protected final AtomicReference<T> objRef = new AtomicReference<Object>(null);
    protected final CountDownLatch latch;
    protected final long timeout;
    protected OperationStatus status;
    protected HttpOperation op;

    public HttpFuture(CountDownLatch latch, long timeout, ExecutorService service) {
        super(service);
        this.latch = latch;
        this.timeout = timeout;
        this.status = null;
    }

    @Override
    public boolean cancel(boolean c) {
        this.op.cancel();
        this.notifyListeners();
        return true;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            this.status = new OperationStatus(false, "Timed out");
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long duration, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitForAndCheckOperation(duration, units);
        return this.objRef.get();
    }

    protected void waitForAndCheckOperation(long duration, TimeUnit units) throws InterruptedException, TimeoutException, ExecutionException {
        if (!this.latch.await(duration, units)) {
            if (this.op != null) {
                this.op.timeOut();
            }
            this.status = new OperationStatus(false, "Timed out");
            throw new TimeoutException("Timed out waiting for operation");
        }
        if (this.op != null && this.op.hasErrored()) {
            this.status = new OperationStatus(false, this.op.getException().getMessage());
            throw new ExecutionException((Throwable)this.op.getException());
        }
        if (this.op != null && this.op.isCancelled()) {
            this.status = new OperationStatus(false, "Operation Cancelled");
            throw new ExecutionException(new CancellationException("Cancelled"));
        }
        if (this.op != null && this.op.isTimedOut()) {
            this.status = new OperationStatus(false, "Timed out");
            throw new ExecutionException((Throwable)new CheckedOperationTimeoutException("Operation timed out.", (Operation)this.op));
        }
    }

    public OperationStatus getStatus() {
        if (this.status == null) {
            try {
                this.get();
            }
            catch (InterruptedException e) {
                this.status = new OperationStatus(false, "Interrupted");
                Thread.currentThread().isInterrupted();
            }
            catch (ExecutionException e) {
                this.getLogger().warn((Object)"Error getting status of operation", (Throwable)e);
            }
        }
        return this.status;
    }

    public void set(T oper, OperationStatus s) {
        this.objRef.set(oper);
        this.status = s;
        this.notifyListeners();
    }

    @Override
    public boolean isDone() {
        assert (this.op != null) : "No operation";
        return this.latch.getCount() == 0L || this.op.isCancelled() || this.op.hasErrored();
    }

    public void setOperation(HttpOperation to) {
        this.op = to;
    }

    @Override
    public boolean isCancelled() {
        assert (this.op != null) : "No operation";
        return this.op.isCancelled();
    }

    public HttpFuture<T> addListener(HttpCompletionListener listener) {
        super.addToListeners((GenericCompletionListener)listener);
        return this;
    }

    public HttpFuture<T> removeListener(HttpCompletionListener listener) {
        super.removeFromListeners((GenericCompletionListener)listener);
        return this;
    }
}

