/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.internal.ReplicaGetCompletionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.spy.memcached.internal.AbstractListenableFuture;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.internal.GetFuture;

public class ReplicaGetFuture<T>
extends AbstractListenableFuture<T, ReplicaGetCompletionListener>
implements Future<T> {
    private final long timeout;
    private GetFuture<T> completedFuture;
    private List<GetFuture<T>> monitoredFutures;
    private boolean cancelled = false;

    public ReplicaGetFuture(long timeout, ExecutorService service) {
        super(service);
        this.timeout = timeout;
        this.monitoredFutures = new ArrayList<GetFuture<T>>();
    }

    public void addFutureToMonitor(GetFuture<T> future) {
        this.monitoredFutures.add(future);
    }

    public void setCompletedFuture(GetFuture<T> future) {
        this.notifyListeners();
        this.completedFuture = future;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long userTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        long timeoutMs = TimeUnit.MILLISECONDS.convert(userTimeout, unit);
        while (System.currentTimeMillis() - start <= timeoutMs) {
            if (this.completedFuture == null || !this.completedFuture.isDone() || this.completedFuture.isCancelled()) continue;
            this.cancelOtherFutures(this.completedFuture);
            return (T)this.completedFuture.get();
        }
        throw new TimeoutException("No replica get future returned with success before timeout.");
    }

    public void cancelOtherFutures(GetFuture successFuture) {
        for (GetFuture<T> future : this.monitoredFutures) {
            if (future.equals((Object)successFuture)) continue;
            future.cancel(true);
        }
    }

    @Override
    public boolean cancel(boolean ign) {
        this.cancelled = true;
        boolean allCancelled = true;
        for (GetFuture<T> future : this.monitoredFutures) {
            if (future.cancel(ign)) continue;
            allCancelled = false;
        }
        this.notifyListeners();
        return allCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completedFuture != null && this.completedFuture.isDone();
    }

    public boolean allDone() {
        boolean allDone = true;
        for (GetFuture<T> future : this.monitoredFutures) {
            if (future.isDone()) continue;
            allDone = false;
        }
        return allDone;
    }

    public ReplicaGetFuture<T> addListener(ReplicaGetCompletionListener listener) {
        super.addToListeners((GenericCompletionListener)listener);
        return this;
    }

    public ReplicaGetFuture<T> removeListener(ReplicaGetCompletionListener listener) {
        super.removeFromListeners((GenericCompletionListener)listener);
        return this;
    }
}

