/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.SpatialViewDesign;
import com.couchbase.client.protocol.views.ViewDesign;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DesignDocument {
    private String name;
    private String language = "javascript";
    private List<ViewDesign> views;
    private List<SpatialViewDesign> spatialViews;

    public DesignDocument(String name) {
        this(name, new ArrayList<ViewDesign>(), new ArrayList<SpatialViewDesign>());
    }

    public DesignDocument(String name, List<ViewDesign> views, List<SpatialViewDesign> spatialViews) {
        if (views == null) {
            views = new ArrayList<ViewDesign>();
        }
        if (spatialViews == null) {
            spatialViews = new ArrayList<SpatialViewDesign>();
        }
        this.name = name;
        this.views = views;
        this.spatialViews = spatialViews;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getName() {
        return this.name;
    }

    public List<ViewDesign> getViews() {
        return this.views;
    }

    public DesignDocument setViews(List<ViewDesign> v) {
        this.views = v;
        return this;
    }

    public DesignDocument setView(ViewDesign view) {
        this.views.add(view);
        return this;
    }

    public List<SpatialViewDesign> getSpatialViews() {
        return this.spatialViews;
    }

    public DesignDocument setSpatialViews(List<SpatialViewDesign> sv) {
        this.spatialViews = sv;
        return this;
    }

    public DesignDocument setSpatialView(SpatialViewDesign spatialView) {
        this.spatialViews.add(spatialView);
        return this;
    }

    public DesignDocument setName(String n) {
        this.name = n;
        return this;
    }

    public String toJson() {
        if (this.views.isEmpty() && this.spatialViews.isEmpty()) {
            throw new RuntimeException("A design document needs a view");
        }
        if (this.name.isEmpty()) {
            throw new RuntimeException("A design document needs a name.");
        }
        JSONObject jsonDesign = new JSONObject();
        try {
            jsonDesign.accumulate("language", (Object)this.language);
            JSONObject jsonViews = new JSONObject();
            for (ViewDesign view : this.views) {
                JSONObject jsonView = new JSONObject();
                jsonView.accumulate("map", (Object)view.getMap());
                if (!view.getReduce().isEmpty()) {
                    jsonView.accumulate("reduce", (Object)view.getReduce());
                }
                jsonViews.accumulate(view.getName(), (Object)jsonView);
            }
            jsonDesign.accumulate("views", (Object)jsonViews);
            if (!this.spatialViews.isEmpty()) {
                JSONObject jsonSpatialViews = new JSONObject();
                for (SpatialViewDesign spatialView : this.spatialViews) {
                    jsonSpatialViews.accumulate(spatialView.getName(), (Object)spatialView.getMap());
                }
                jsonDesign.accumulate("spatial", (Object)jsonSpatialViews);
            }
        }
        catch (JSONException ex) {
            throw new RuntimeException("Failed to compose design document: " + (Object)((Object)ex));
        }
        return jsonDesign.toString();
    }
}

