/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.clustermanager.AuthType;
import com.couchbase.client.clustermanager.BucketType;
import com.couchbase.client.clustermanager.FlushResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.spy.memcached.compat.SpyObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClusterManager
extends SpyObject {
    private final DefaultHttpClientConnection conn;
    private final HttpContext context;
    private final HttpRequestExecutor httpexecutor;
    private final HttpProcessor httpproc;
    private final List<URI> addrs;
    private final String user;
    private final String pass;

    public ClusterManager(List<URI> uris, String username, String password) {
        this.addrs = uris;
        this.user = username;
        this.pass = password;
        this.httpproc = new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue()});
        this.httpexecutor = new HttpRequestExecutor();
        this.context = new BasicHttpContext(null);
        this.conn = new DefaultHttpClientConnection();
    }

    private boolean connect(URI uri) {
        HttpHost host = new HttpHost(uri.getHost(), uri.getPort());
        this.context.setAttribute("http.connection", (Object)this.conn);
        this.context.setAttribute("http.target_host", (Object)host);
        try {
            if (!this.conn.isOpen()) {
                Socket socket = new Socket(host.getHostName(), host.getPort());
                this.conn.bind(socket, (HttpParams)new SyncBasicHttpParams());
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void createDefaultBucket(BucketType type, int memorySizeMB, int replicas, boolean flushEnabled) {
        this.createBucket(type, "default", memorySizeMB, AuthType.NONE, replicas, 11212, "", flushEnabled);
    }

    public void createNamedBucket(BucketType type, String name, int memorySizeMB, int replicas, String authPassword, boolean flushEnabled) {
        this.createBucket(type, name, memorySizeMB, AuthType.SASL, replicas, 11212, authPassword, flushEnabled);
    }

    public void createPortBucket(BucketType type, String name, int memorySizeMB, int replicas, int port, boolean flush) {
        this.createBucket(type, name, memorySizeMB, AuthType.NONE, replicas, port, "", flush);
    }

    public void deleteBucket(String name) {
        String url = "/pools/default/buckets/" + name;
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("DELETE", url);
        this.checkError(200, this.sendRequest((HttpRequest)request));
    }

    public List<String> listBuckets() {
        String url = "/pools/default/buckets/";
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("GET", url);
        HttpResult result = this.sendRequest((HttpRequest)request);
        this.checkError(200, result);
        String json = result.getBody();
        LinkedList<String> names = new LinkedList<String>();
        if (json != null && !json.equals("")) {
            try {
                JSONArray base = new JSONArray(json);
                for (int i = 0; i < base.length(); ++i) {
                    JSONObject bucket = (JSONObject)base.get(i);
                    if (!bucket.has("name")) continue;
                    names.add(bucket.getString("name"));
                }
            }
            catch (JSONException e) {
                this.getLogger().error((Object)"Unable to interpret list buckets response.");
                throw new RuntimeException(e);
            }
        }
        return names;
    }

    public FlushResponse flushBucket(String name) {
        String url = "/pools/default/buckets/" + name + "/controller/doFlush";
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", url);
        HttpResult result = this.sendRequest((HttpRequest)request);
        if (result.getErrorCode() == 200) {
            return FlushResponse.OK;
        }
        if (result.getErrorCode() == 400) {
            return FlushResponse.NOT_ENABLED;
        }
        throw new RuntimeException("Http Error: " + result.getErrorCode() + " Reason: " + result.getErrorPhrase() + " Details: " + result.getReason());
    }

    private void createBucket(BucketType type, String name, int memorySizeMB, AuthType authType, int replicas, int port, String authpassword, boolean flushEnabled) {
        List<String> buckets = this.listBuckets();
        if (buckets.contains(name)) {
            throw new RuntimeException("Bucket with given name already exists");
        }
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/pools/default/buckets");
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(name);
        sb.append("&ramQuotaMB=").append(memorySizeMB);
        sb.append("&authType=").append(authType.getAuthType());
        sb.append("&replicaNumber=").append(replicas);
        sb.append("&bucketType=").append(type.getBucketType());
        sb.append("&proxyPort=").append(port);
        if (authType == AuthType.SASL) {
            sb.append("&saslPassword=").append(authpassword);
        }
        if (flushEnabled) {
            sb.append("&flushEnabled=1");
        }
        try {
            request.setEntity((HttpEntity)new StringEntity(sb.toString()));
            System.out.println(request.toString());
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error((Object)"Error creating request. Bad arguments");
            throw new RuntimeException(e);
        }
        this.checkError(202, this.sendRequest((HttpRequest)request));
    }

    public void updateBucket(String name, int memorySizeMB, AuthType authType, int replicas, int port, String authpassword, boolean flushEnabled) {
        try {
            BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", "/pools/default/buckets/" + name);
            StringBuilder sb = new StringBuilder();
            sb.append("&ramQuotaMB=").append(memorySizeMB);
            sb.append("&authType=").append(authType.getAuthType());
            sb.append("&replicaNumber=").append(replicas);
            sb.append("&proxyPort=").append(port);
            if (authType == AuthType.SASL) {
                sb.append("&saslPassword=").append(authpassword);
            }
            if (flushEnabled) {
                sb.append("&flushEnabled=1");
            }
            request.setEntity((HttpEntity)new StringEntity(sb.toString()));
            this.checkError(200, this.sendRequest((HttpRequest)request));
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error((Object)"Error creating request. Bad arguments");
            throw new RuntimeException(e);
        }
    }

    private HttpResult sendRequest(HttpRequest request) {
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Couchbase Java Client/1.1");
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)true);
        request.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.user + ":" + this.pass).getBytes()));
        request.addHeader("Accept", "*/*");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        for (int i = 0; i < this.addrs.size(); ++i) {
            try {
                if (!this.connect(this.addrs.get(i))) continue;
                this.httpexecutor.preProcess(request, this.httpproc, this.context);
                HttpResponse response = this.httpexecutor.execute(request, (HttpClientConnection)this.conn, this.context);
                this.httpexecutor.postProcess(response, this.httpproc, this.context);
                int code = response.getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)response.getEntity());
                String reason = this.parseError(body);
                String phrase = response.getStatusLine().getReasonPhrase();
                return new HttpResult(body, code, phrase, reason);
            }
            catch (HttpException e) {
                this.getLogger().debug((Object)("Error processing http request: " + e.getMessage()));
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                this.getLogger().debug((Object)("Unable to connect to: " + this.addrs.get(i) + ". Trying another server"));
            }
        }
        throw new RuntimeException("Unable to connect to cluster");
    }

    private String parseError(String json) {
        if (json != null && !json.equals("")) {
            try {
                JSONObject base = new JSONObject(json);
                if (base.has("errors")) {
                    JSONObject errors = (JSONObject)base.get("errors");
                    return errors.toString();
                }
            }
            catch (JSONException e) {
                return "Client error parsing error response";
            }
        }
        return "No reason given";
    }

    private void checkError(int expectedCode, HttpResult result) {
        if (result.getErrorCode() != expectedCode) {
            throw new RuntimeException("Http Error: " + result.getErrorCode() + " Reason: " + result.getErrorPhrase() + " Details: " + result.getReason());
        }
    }

    public boolean shutdown() {
        try {
            this.conn.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private final class HttpResult {
        private final String body;
        private final int errorCode;
        private final String errorPhrase;
        private final String errorReason;

        public HttpResult(String entity, int code, String phrase, String reason) {
            this.body = entity;
            this.errorCode = code;
            this.errorPhrase = phrase;
            this.errorReason = reason;
        }

        public String getBody() {
            return this.body;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorPhrase() {
            return this.errorPhrase;
        }

        public String getReason() {
            return this.errorReason;
        }
    }
}

