/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.ClusterManager;
import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseMemcachedConnection;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.ViewConnection;
import com.couchbase.client.ViewNode;
import com.couchbase.client.http.AsyncConnectionManager;
import com.couchbase.client.vbucket.ConfigurationException;
import com.couchbase.client.vbucket.ConfigurationProvider;
import com.couchbase.client.vbucket.ConfigurationProviderHTTP;
import com.couchbase.client.vbucket.CouchbaseNodeOrder;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigType;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.DefaultHashAlgorithm;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaNodeLocator;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;

public class CouchbaseConnectionFactory
extends BinaryConnectionFactory {
    public static final FailureMode DEFAULT_FAILURE_MODE = FailureMode.Redistribute;
    public static final HashAlgorithm DEFAULT_HASH = DefaultHashAlgorithm.NATIVE_HASH;
    public static final int DEFAULT_OP_QUEUE_LEN = 16384;
    public static final long DEFAULT_MIN_RECONNECT_INTERVAL = 1100L;
    public static final int DEFAULT_VIEW_TIMEOUT = 75000;
    public static final long DEFAULT_OBS_POLL_INTERVAL = 10L;
    public static final int DEFAULT_OBS_POLL_MAX = 500;
    public static final CouchbaseNodeOrder DEFAULT_STREAMING_NODE_ORDER = CouchbaseNodeOrder.RANDOM;
    protected volatile ConfigurationProvider configurationProvider;
    private volatile String bucket;
    private volatile String pass;
    private volatile List<URI> storedBaseList;
    private static final Logger LOGGER = Logger.getLogger(CouchbaseConnectionFactory.class.getName());
    private volatile boolean needsReconnect;
    private final AtomicBoolean doingResubscribe = new AtomicBoolean(false);
    private volatile long thresholdLastCheck = System.nanoTime();
    private final AtomicInteger configThresholdCount = new AtomicInteger(0);
    private final int maxConfigCheck = 10;
    private volatile long configProviderLastUpdateTimestamp;
    private long minReconnectInterval = 1100L;
    private final ExecutorService resubExec = Executors.newSingleThreadExecutor();
    private final CouchbaseNodeOrder nodeOrder = DEFAULT_STREAMING_NODE_ORDER;
    private ClusterManager clusterManager;

    public CouchbaseConnectionFactory() {
        String[] nodeList;
        String nodes = CouchbaseProperties.getProperty("nodes");
        String bucket = CouchbaseProperties.getProperty("bucket");
        String password = CouchbaseProperties.getProperty("password");
        if (nodes == null) {
            throw new IllegalArgumentException("System property cbclient.nodes not set or empty");
        }
        if (bucket == null) {
            throw new IllegalArgumentException("System property cbclient.bucket not set or empty");
        }
        if (password == null) {
            throw new IllegalArgumentException("System property cbclient.password not set or empty");
        }
        ArrayList<URI> baseList = new ArrayList<URI>();
        for (String node : nodeList = nodes.split(";")) {
            try {
                baseList.add(new URI(node));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not parse node list into  URI format.");
            }
        }
        this.initialize(baseList, bucket, password);
    }

    public CouchbaseConnectionFactory(List<URI> baseList, String bucketName, String password) throws IOException {
        this.initialize(baseList, bucketName, password);
    }

    private void initialize(List<URI> baseList, String bucket, String password) {
        this.potentiallyRandomizeNodeList(baseList);
        this.storedBaseList = new ArrayList<URI>();
        for (URI bu : baseList) {
            if (!bu.isAbsolute()) {
                throw new IllegalArgumentException("The base URI must be absolute");
            }
            this.storedBaseList.add(bu);
        }
        if (bucket == null || bucket.isEmpty()) {
            throw new IllegalArgumentException("The bucket name must not be null or empty.");
        }
        if (password == null) {
            throw new IllegalArgumentException("The bucket password must not be  null.");
        }
        this.bucket = bucket;
        this.pass = password;
        this.configurationProvider = new ConfigurationProviderHTTP(baseList, bucket, password);
    }

    public ViewNode createViewNode(InetSocketAddress addr, AsyncConnectionManager connMgr) {
        return new ViewNode(addr, connMgr, this.opQueueLen, this.getOpQueueMaxBlockTime(), this.getOperationTimeout(), this.bucket, this.pass);
    }

    public MemcachedConnection createConnection(List<InetSocketAddress> addrs) throws IOException {
        Config config = this.getVBucketConfig();
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new CouchbaseMemcachedConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new CouchbaseConnection(this.getReadBufSize(), this, addrs, this.getInitialObservers(), this.getFailureMode(), this.getOperationFactory());
        }
        throw new IOException("No ConnectionFactory for bucket type " + (Object)((Object)config.getConfigType()));
    }

    public ViewConnection createViewConnection(List<InetSocketAddress> addrs) throws IOException {
        return new ViewConnection(this, addrs, this.getInitialObservers());
    }

    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        Config config = this.getVBucketConfig();
        if (config == null) {
            throw new IllegalStateException("Couldn't get config");
        }
        if (config.getConfigType() == ConfigType.MEMCACHE) {
            return new KetamaNodeLocator(nodes, (HashAlgorithm)DefaultHashAlgorithm.KETAMA_HASH);
        }
        if (config.getConfigType() == ConfigType.COUCHBASE) {
            return new VBucketNodeLocator(nodes, this.getVBucketConfig());
        }
        throw new IllegalStateException("Unhandled locator type: " + (Object)((Object)config.getConfigType()));
    }

    public boolean shouldOptimize() {
        return false;
    }

    public AuthDescriptor getAuthDescriptor() {
        if (!this.configurationProvider.getAnonymousAuthBucket().equals(this.bucket) && this.bucket != null) {
            return new AuthDescriptor(new String[0], (CallbackHandler)new PlainCallbackHandler(this.bucket, this.pass));
        }
        return null;
    }

    public String getBucketName() {
        return this.bucket;
    }

    public int getViewTimeout() {
        return 75000;
    }

    public CouchbaseNodeOrder getStreamingNodeOrder() {
        return this.nodeOrder;
    }

    public Config getVBucketConfig() {
        Bucket config = this.configurationProvider.getBucketConfiguration(this.bucket);
        if (config == null) {
            throw new ConfigurationException("Could not fetch valid configuration from provided nodes. Stopping.");
        }
        if (config.isNotUpdating()) {
            LOGGER.warning("Noticed bucket configuration to be disconnected, will attempt to reconnect");
            this.setConfigurationProvider(new ConfigurationProviderHTTP(this.storedBaseList, this.bucket, this.pass));
        }
        return this.configurationProvider.getBucketConfiguration(this.bucket).getConfig();
    }

    public synchronized ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected void requestConfigReconnect(String bucketName, Reconfigurable rec) {
        this.configurationProvider.markForResubscribe(bucketName, rec);
        this.needsReconnect = true;
    }

    synchronized void setConfigurationProvider(ConfigurationProvider configProvider) {
        this.configProviderLastUpdateTimestamp = System.currentTimeMillis();
        this.configurationProvider = configProvider;
    }

    void setMinReconnectInterval(long reconnIntervalMsecs) {
        this.minReconnectInterval = reconnIntervalMsecs;
    }

    void checkConfigUpdate() {
        if (this.needsReconnect || this.pastReconnThreshold()) {
            long now = System.currentTimeMillis();
            long intervalWaited = now - this.configProviderLastUpdateTimestamp;
            if (intervalWaited < this.getMinReconnectInterval()) {
                LOGGER.log(Level.FINE, "Ignoring config update check. Only {0}ms out of a threshold of {1}ms since last update.", new Object[]{intervalWaited, this.getMinReconnectInterval()});
                return;
            }
            if (this.doingResubscribe.compareAndSet(false, true)) {
                this.resubConfigUpdate();
            } else {
                LOGGER.log(Level.CONFIG, "Duplicate resubscribe for config updates suppressed.");
            }
        } else {
            LOGGER.log(Level.FINE, "No reconnect required, though check requested. Current config check is {0} out of a threshold of {1}.", new Object[]{this.configThresholdCount, 10});
        }
    }

    private synchronized void resubConfigUpdate() {
        LOGGER.log(Level.INFO, "Attempting to resubscribe for cluster config updates.");
        this.resubExec.execute(new Resubscriber());
    }

    protected boolean pastReconnThreshold() {
        long currentTime = System.nanoTime();
        if (currentTime - this.thresholdLastCheck >= TimeUnit.SECONDS.toNanos(10L)) {
            this.configThresholdCount.set(0);
        }
        this.thresholdLastCheck = currentTime;
        return this.configThresholdCount.incrementAndGet() >= 10;
    }

    long getMinReconnectInterval() {
        return this.minReconnectInterval;
    }

    long getObsPollInterval() {
        return 10L;
    }

    int getObsPollMax() {
        return 500;
    }

    int getMaxConfigCheck() {
        return 10;
    }

    public ClusterManager getClusterManager() {
        if (this.clusterManager == null) {
            this.clusterManager = new ClusterManager(this.storedBaseList, this.bucket, this.pass);
        }
        return this.clusterManager;
    }

    public void updateStoredBaseList(Config config) {
        List<String> bucketServers = config.getRestEndpoints();
        if (bucketServers.size() > 0) {
            ArrayList<URI> newList = new ArrayList<URI>();
            for (String bucketServer : bucketServers) {
                try {
                    newList.add(new URI(bucketServer));
                }
                catch (URISyntaxException ex) {
                    this.getLogger().warn((Object)"Could not add node to updated bucket list because of a parsing exception.");
                    this.getLogger().debug((Object)("Could not parse list because: " + ex));
                }
            }
            if (this.nodeListsAreDifferent(this.storedBaseList, newList)) {
                this.getLogger().info((Object)("Replacing current streaming node list " + this.storedBaseList + " with " + newList));
                this.potentiallyRandomizeNodeList(newList);
                this.storedBaseList = newList;
                this.getConfigurationProvider().updateBaseListFromConfig(newList);
            }
        }
    }

    List<URI> getStoredBaseList() {
        return this.storedBaseList;
    }

    private void potentiallyRandomizeNodeList(List<URI> list) {
        if (this.getStreamingNodeOrder().equals((Object)CouchbaseNodeOrder.ORDERED)) {
            return;
        }
        Collections.shuffle(list);
    }

    private boolean nodeListsAreDifferent(List<URI> left, List<URI> right) {
        if (left.size() != right.size()) {
            return true;
        }
        for (URI uri : left) {
            if (right.contains(uri)) continue;
            return true;
        }
        return false;
    }

    private class Resubscriber
    implements Runnable {
        private Resubscriber() {
        }

        @Override
        public void run() {
            String threadNameBase = "Couchbase/Resubscriber (Status: ";
            Thread.currentThread().setName(threadNameBase + "running)");
            LOGGER.log(Level.CONFIG, "Resubscribing for {0} using base list {1}", new Object[]{CouchbaseConnectionFactory.this.bucket, CouchbaseConnectionFactory.this.storedBaseList});
            long reconnectAttempt = 0L;
            long backoffTime = 1000L;
            long maxWaitTime = 10000L;
            do {
                try {
                    long waitTime = reconnectAttempt++ * backoffTime;
                    if (reconnectAttempt >= 10L) {
                        waitTime = maxWaitTime;
                    }
                    LOGGER.log(Level.INFO, "Reconnect attempt {0}, waiting {1}ms", new Object[]{reconnectAttempt, waitTime});
                    Thread.sleep(waitTime);
                    ConfigurationProvider oldConfigProvider = CouchbaseConnectionFactory.this.getConfigurationProvider();
                    Reconfigurable oldRec = oldConfigProvider.getReconfigurable();
                    ConfigurationProviderHTTP newConfigProvider = new ConfigurationProviderHTTP(CouchbaseConnectionFactory.this.storedBaseList, CouchbaseConnectionFactory.this.bucket, CouchbaseConnectionFactory.this.pass);
                    newConfigProvider.subscribe(CouchbaseConnectionFactory.this.bucket, oldRec);
                    CouchbaseConnectionFactory.this.setConfigurationProvider(newConfigProvider);
                    oldConfigProvider.shutdown();
                    if (CouchbaseConnectionFactory.this.doingResubscribe.compareAndSet(true, false)) continue;
                    LOGGER.log(Level.WARNING, "Could not reset from doing a resubscribe.");
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Resubscribe attempt failed: ", ex);
                }
            } while (CouchbaseConnectionFactory.this.doingResubscribe.get());
            Thread.currentThread().setName(threadNameBase + "complete)");
        }
    }
}

