/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.protocol.views;

import com.couchbase.client.protocol.views.ComplexKey;
import com.couchbase.client.protocol.views.OnError;
import com.couchbase.client.protocol.views.Stale;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.util.StringUtils;

public class Query {
    private static final String DESCENDING = "descending";
    private static final String ENDKEY = "endkey";
    private static final String ENDKEYDOCID = "endkey_docid";
    private static final String GROUP = "group";
    private static final String GROUPLEVEL = "group_level";
    private static final String INCLUSIVEEND = "inclusive_end";
    private static final String KEY = "key";
    private static final String KEYS = "keys";
    private static final String LIMIT = "limit";
    private static final String REDUCE = "reduce";
    private static final String SKIP = "skip";
    private static final String STALE = "stale";
    private static final String STARTKEY = "startkey";
    private static final String STARTKEYDOCID = "startkey_docid";
    private static final String ONERROR = "on_error";
    private static final String BBOX = "bbox";
    private static final String DEBUG = "debug";
    private boolean includedocs = false;
    private final Map<String, Object> args = new HashMap<String, Object>();

    public boolean willReduce() {
        return this.args.containsKey(REDUCE) ? (Boolean)this.args.get(REDUCE) : false;
    }

    public boolean willIncludeDocs() {
        return this.includedocs;
    }

    public Query setDescending(boolean descending) {
        this.args.put(DESCENDING, descending);
        return this;
    }

    public Query setEndkeyDocID(String endkeydocid) {
        this.args.put(ENDKEYDOCID, endkeydocid);
        return this;
    }

    public Query setGroup(boolean group) {
        this.args.put(GROUP, group);
        return this;
    }

    public Query setGroupLevel(int grouplevel) {
        this.args.put(GROUPLEVEL, grouplevel);
        return this;
    }

    public Query setIncludeDocs(boolean include) {
        this.includedocs = include;
        return this;
    }

    public Query setInclusiveEnd(boolean inclusiveend) {
        this.args.put(INCLUSIVEEND, inclusiveend);
        return this;
    }

    public Query setKey(ComplexKey key) {
        this.args.put(KEY, key.toJson());
        return this;
    }

    public Query setKey(String key) {
        this.args.put(KEY, key);
        return this;
    }

    public Query setKeys(ComplexKey keys) {
        this.args.put(KEYS, keys.toJson());
        return this;
    }

    public Query setKeys(String keys) {
        this.args.put(KEYS, keys);
        return this;
    }

    public Query setLimit(int limit) {
        this.args.put(LIMIT, limit);
        return this;
    }

    public int getLimit() {
        if (this.args.containsKey(LIMIT)) {
            return (Integer)this.args.get(LIMIT);
        }
        return -1;
    }

    public Query setRange(String startkey, String endkey) {
        this.args.put(ENDKEY, endkey);
        this.args.put(STARTKEY, startkey);
        return this;
    }

    public Query setRange(ComplexKey startkey, ComplexKey endkey) {
        this.args.put(ENDKEY, endkey.toJson());
        this.args.put(STARTKEY, startkey.toJson());
        return this;
    }

    public Query setRangeStart(String startkey) {
        this.args.put(STARTKEY, startkey);
        return this;
    }

    public Query setRangeStart(ComplexKey startkey) {
        this.args.put(STARTKEY, startkey.toJson());
        return this;
    }

    public Query setReduce(Boolean reduce) {
        this.args.put(REDUCE, reduce);
        return this;
    }

    public Query setRangeEnd(String endkey) {
        this.args.put(ENDKEY, endkey);
        return this;
    }

    public Query setRangeEnd(ComplexKey endkey) {
        this.args.put(ENDKEY, endkey.toJson());
        return this;
    }

    public Query setSkip(int docstoskip) {
        this.args.put(SKIP, docstoskip);
        return this;
    }

    public Query setStale(Stale stale) {
        this.args.put(STALE, (Object)stale);
        return this;
    }

    public Query setStartkeyDocID(String startkeydocid) {
        this.args.put(STARTKEYDOCID, startkeydocid);
        return this;
    }

    public Query setOnError(OnError opt) {
        this.args.put(ONERROR, (Object)opt);
        return this;
    }

    public Query setBbox(double lowerLeftLong, double lowerLeftLat, double upperRightLong, double upperRightLat) {
        String combined = lowerLeftLong + "," + lowerLeftLat + "," + upperRightLong + "," + upperRightLat;
        this.args.put(BBOX, combined);
        return this;
    }

    public Query setDebug(boolean debug) {
        this.args.put(DEBUG, debug);
        return this;
    }

    public Query copy() {
        Query query = new Query();
        if (this.args.containsKey(DESCENDING)) {
            query.setDescending((Boolean)this.args.get(DESCENDING));
        }
        if (this.args.containsKey(ENDKEY)) {
            query.setRangeEnd((String)this.args.get(ENDKEY));
        }
        if (this.args.containsKey(ENDKEYDOCID)) {
            query.setEndkeyDocID((String)this.args.get(ENDKEYDOCID));
        }
        if (this.args.containsKey(GROUP)) {
            query.setGroup((Boolean)this.args.get(GROUP));
        }
        if (this.args.containsKey(GROUPLEVEL)) {
            query.setGroupLevel((Integer)this.args.get(GROUPLEVEL));
        }
        if (this.args.containsKey(INCLUSIVEEND)) {
            query.setInclusiveEnd((Boolean)this.args.get(INCLUSIVEEND));
        }
        if (this.args.containsKey(KEY)) {
            query.setKey((String)this.args.get(KEY));
        }
        if (this.args.containsKey(KEYS)) {
            query.setKeys((String)this.args.get(KEYS));
        }
        if (this.args.containsKey(LIMIT)) {
            query.setLimit((Integer)this.args.get(LIMIT));
        }
        if (this.args.containsKey(REDUCE)) {
            query.setReduce((boolean)((Boolean)this.args.get(REDUCE)));
        }
        if (this.args.containsKey(SKIP)) {
            query.setSkip((Integer)this.args.get(SKIP));
        }
        if (this.args.containsKey(STALE)) {
            query.setStale((Stale)((Object)this.args.get(STALE)));
        }
        if (this.args.containsKey(STARTKEY)) {
            query.setRangeStart((String)this.args.get(STARTKEY));
        }
        if (this.args.containsKey(STARTKEYDOCID)) {
            query.setStartkeyDocID((String)this.args.get(STARTKEYDOCID));
        }
        if (this.args.containsKey(ONERROR)) {
            query.setOnError((OnError)((Object)this.args.get(ONERROR)));
        }
        if (this.args.containsKey(BBOX)) {
            String[] bbox = ((String)this.args.get(BBOX)).split(",");
            query.setBbox(Double.parseDouble(bbox[0]), Double.parseDouble(bbox[1]), Double.parseDouble(bbox[2]), Double.parseDouble(bbox[3]));
        }
        if (this.args.containsKey(DEBUG)) {
            query.setDebug((Boolean)this.args.get(DEBUG));
        }
        query.setIncludeDocs(this.willIncludeDocs());
        return query;
    }

    public String toString() {
        boolean first = true;
        StringBuffer result = new StringBuffer();
        for (Map.Entry<String, Object> arg : this.args.entrySet()) {
            String argument;
            if (first) {
                result.append("?");
                first = false;
            } else {
                result.append("&");
            }
            try {
                argument = arg.getKey() + "=" + this.prepareValue(arg.getKey(), arg.getValue());
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not prepare view argument: " + ex);
            }
            result.append(argument);
        }
        return result.toString();
    }

    private String prepareValue(String key, Object value) throws UnsupportedEncodingException {
        String encoded;
        if (key.equals(STARTKEYDOCID) || key.equals(BBOX)) {
            encoded = (String)value;
        } else if (value instanceof Stale) {
            encoded = value.toString();
        } else if (value instanceof OnError) {
            encoded = value.toString();
        } else if (StringUtils.isJsonObject((String)value.toString())) {
            encoded = value.toString();
        } else if (value.toString().startsWith("\"")) {
            encoded = value.toString();
        } else {
            ParsePosition pp = new ParsePosition(0);
            NumberFormat numberFormat = NumberFormat.getInstance();
            Number result = numberFormat.parse(value.toString(), pp);
            encoded = pp.getIndex() == value.toString().length() ? result.toString() : "\"" + value.toString() + "\"";
        }
        return URLEncoder.encode(encoded, "UTF-8");
    }

    public Map<String, Object> getArgs() {
        return this.args;
    }
}

