/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.ConnectionException;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigFactory;
import com.couchbase.client.vbucket.config.ConfigurationParser;
import com.couchbase.client.vbucket.config.DefaultConfigFactory;
import com.couchbase.client.vbucket.config.Node;
import com.couchbase.client.vbucket.config.Pool;
import com.couchbase.client.vbucket.config.Port;
import com.couchbase.client.vbucket.config.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.spy.memcached.compat.SpyObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ConfigurationParserJSON
extends SpyObject
implements ConfigurationParser {
    private final ConfigFactory configFactory = new DefaultConfigFactory();

    @Override
    public Map<String, Pool> parsePools(String poolsJson) throws ParseException {
        JSONArray allPools;
        HashMap<String, Pool> parsedBase = new HashMap<String, Pool>();
        try {
            allPools = new JSONObject(poolsJson).getJSONArray("pools");
        }
        catch (JSONException e) {
            this.getLogger().info((Object)("Received the following unparsable response: " + e.getMessage()));
            throw new ConnectionException("Connection URI is either incorrect or invalid as it cannot be parsed.");
        }
        for (int i = 0; i < allPools.length(); ++i) {
            try {
                JSONObject currentPool = allPools.getJSONObject(i);
                String name = currentPool.getString("name");
                if (name == null || name.isEmpty()) {
                    throw new ParseException("Pool's name is missing.", 0);
                }
                URI uri = new URI(currentPool.getString("uri"));
                URI streamingUri = new URI(currentPool.getString("streamingUri"));
                Pool pool = new Pool(name, uri, streamingUri);
                parsedBase.put(name, pool);
                continue;
            }
            catch (JSONException e) {
                this.getLogger().error((Object)"One of the pool configurations can not be parsed.", (Throwable)e);
                continue;
            }
            catch (URISyntaxException e) {
                this.getLogger().error((Object)"Server provided an incorrect uri.", (Throwable)e);
            }
        }
        return parsedBase;
    }

    @Override
    public void parsePool(Pool pool, String poolsJson) throws ParseException {
        try {
            JSONObject buckets = new JSONObject(poolsJson).getJSONObject("buckets");
            URI bucketsUri = new URI(buckets.getString("uri"));
            pool.setBucketsUri(bucketsUri);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public Map<String, Bucket> parseBuckets(String bucketsJson) throws ParseException {
        try {
            HashMap<String, Bucket> bucketsMap = new HashMap<String, Bucket>();
            JSONArray allBuckets = new JSONArray(bucketsJson);
            for (int i = 0; i < allBuckets.length(); ++i) {
                JSONObject currentBucket = allBuckets.getJSONObject(i);
                Bucket bucket = this.parseBucketFromJSON(currentBucket, null);
                bucketsMap.put(bucket.getName(), bucket);
            }
            return bucketsMap;
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public Bucket parseBucket(String bucketJson) throws ParseException {
        try {
            return this.parseBucketFromJSON(new JSONObject(bucketJson), null);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    @Override
    public Bucket updateBucket(String bucketJson, Bucket currentBucket) throws ParseException {
        try {
            return this.parseBucketFromJSON(new JSONObject(bucketJson), currentBucket);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private Bucket parseBucketFromJSON(JSONObject bucketJson, Bucket current) throws ParseException {
        try {
            String bucketName = bucketJson.getString("name");
            URI streamingUri = new URI(bucketJson.getString("streamingUri"));
            Config currentConfig = null;
            if (current != null) {
                currentConfig = current.getConfig();
            }
            Config config = this.configFactory.create(bucketJson, currentConfig);
            ArrayList<Node> nodes = new ArrayList<Node>();
            JSONArray allNodes = bucketJson.getJSONArray("nodes");
            for (int i = 0; i < allNodes.length(); ++i) {
                JSONObject currentNode = allNodes.getJSONObject(i);
                Status status = this.parseNodeStatus(currentNode.getString("status"));
                String hostname = currentNode.getString("hostname");
                Map<Port, String> ports = this.extractPorts(currentNode.getJSONObject("ports"));
                nodes.add(new Node(status, hostname, ports));
            }
            return new Bucket(bucketName, config, streamingUri, nodes);
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (URISyntaxException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private Status parseNodeStatus(String status) {
        if (status == null || status.isEmpty()) {
            return null;
        }
        try {
            return Status.valueOf(status);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error((Object)("Unknown status value: " + status));
            return null;
        }
    }

    private Map<Port, String> extractPorts(JSONObject portsJson) throws JSONException {
        HashMap<Port, String> ports = new HashMap<Port, String>();
        for (Port port : Port.values()) {
            String portValue = portsJson.getString(port.toString());
            if (portValue == null || portValue.isEmpty()) continue;
            ports.put(port, portValue);
        }
        return ports;
    }
}

