/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket;

import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigDifference;
import com.couchbase.client.vbucket.config.VBucket;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;

public class VBucketNodeLocator
extends SpyObject
implements NodeLocator {
    private final AtomicReference<TotalConfig> fullConfig = new AtomicReference();

    public VBucketNodeLocator(List<MemcachedNode> nodes, Config jsonConfig) {
        this.fullConfig.set(new TotalConfig(jsonConfig, this.fillNodesEntries(jsonConfig, nodes)));
    }

    public MemcachedNode getPrimary(String k) {
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        Map<String, MemcachedNode> nodesMap = totConfig.getNodesMap();
        int vbucket = config.getVbucketByKey(k);
        int serverNumber = config.getMaster(vbucket);
        if (serverNumber == -1) {
            this.getLogger().warn((Object)("The key " + k + " pointed to vbucket " + vbucket + ", for which no server is responsible in the cluster map (-1). This " + "can be an indication that either no replica is defined for a " + "failed server or more nodes have been failed over than replicas " + "defined."));
            return null;
        }
        String server = config.getServer(serverNumber);
        MemcachedNode pNode = nodesMap.get(server);
        if (pNode == null) {
            this.getLogger().error("The node locator does not have a primary for key %s.  Wanted vbucket %s which should be on server %s.", new Object[]{k, vbucket, server});
            this.getLogger().error("List of nodes has %s entries:", new Object[]{nodesMap.size()});
            Set<String> keySet = nodesMap.keySet();
            for (String anode : keySet) {
                this.getLogger().error("MemcachedNode for %s is %s", new Object[]{anode, nodesMap.get(anode)});
            }
            Collection<MemcachedNode> nodes = nodesMap.values();
            for (MemcachedNode node : nodes) {
                this.getLogger().error((Object)node);
            }
        }
        assert (pNode != null);
        return pNode;
    }

    public MemcachedNode getReplica(String key, int index) {
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        Map<String, MemcachedNode> nodesMap = totConfig.getNodesMap();
        int vbucket = config.getVbucketByKey(key);
        int serverNumber = config.getReplica(vbucket, index);
        if (serverNumber == -1) {
            this.getLogger().warn((Object)("The key " + key + " pointed to vbucket " + vbucket + ", for which no server is responsible in the cluster map." + "This can be an indication that either no replica is defined for a " + "failed server or more nodes have been failed over than replicas " + "defined."));
            return null;
        }
        String server = config.getServer(serverNumber);
        MemcachedNode pNode = nodesMap.get(server);
        return pNode;
    }

    public MemcachedNode getServerByIndex(int k) {
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        Map<String, MemcachedNode> nodesMap = totConfig.getNodesMap();
        String server = config.getServer(k);
        return nodesMap.get(server);
    }

    public Iterator<MemcachedNode> getSequence(String k) {
        return new NullIterator();
    }

    public Collection<MemcachedNode> getAll() {
        Map<String, MemcachedNode> nodesMap = this.fullConfig.get().getNodesMap();
        return nodesMap.values();
    }

    public NodeLocator getReadonlyCopy() {
        return this;
    }

    public void updateLocator(List<MemcachedNode> nodes) {
        throw new UnsupportedOperationException("Must be updated with a config");
    }

    public void updateLocator(Collection<MemcachedNode> nodes, Config newconf) {
        Config current = this.fullConfig.get().getConfig();
        ConfigDifference compareTo = current.compareTo(newconf);
        if (compareTo.isSequenceChanged() || compareTo.getVbucketsChanges() > 0 || current.getCouchServers().size() != newconf.getCouchServers().size()) {
            this.getLogger().debug((Object)"Updating configuration, received updated configuration with significant changes.");
            this.fullConfig.set(new TotalConfig(newconf, this.fillNodesEntries(newconf, nodes)));
        } else {
            this.getLogger().debug((Object)"Received updated configuration with insignificant changes.");
        }
    }

    public int getVBucketIndex(String key) {
        Config config = this.fullConfig.get().getConfig();
        return config.getVbucketByKey(key);
    }

    private Map<String, MemcachedNode> fillNodesEntries(Config newConfig, Collection<MemcachedNode> nodes) {
        HashMap<String, MemcachedNode> vbnodesMap = new HashMap<String, MemcachedNode>();
        this.getLogger().debug((Object)"Updating nodesMap in VBucketNodeLocator.");
        for (String string : newConfig.getServers()) {
            vbnodesMap.put(string, null);
        }
        for (MemcachedNode memcachedNode : nodes) {
            InetSocketAddress addr = (InetSocketAddress)memcachedNode.getSocketAddress();
            String address = addr.getAddress().getHostName() + ":" + addr.getPort();
            String hostname = addr.getAddress().getHostAddress() + ":" + addr.getPort();
            if (vbnodesMap.containsKey(address)) {
                vbnodesMap.put(address, memcachedNode);
                this.getLogger().debug("Adding node with address %s.", new Object[]{address});
                this.getLogger().debug("Node added is %s.", new Object[]{memcachedNode});
                continue;
            }
            if (!vbnodesMap.containsKey(hostname)) continue;
            vbnodesMap.put(hostname, memcachedNode);
            this.getLogger().debug("Adding node with hostname %s.", new Object[]{hostname});
            this.getLogger().debug("Node added is %s.", new Object[]{memcachedNode});
        }
        for (Map.Entry entry : vbnodesMap.entrySet()) {
            if (entry.getValue() != null) continue;
            this.getLogger().error("Critical reconfiguration error: Server list from Configuration and Nodes are out of synch. causing %s to be removed", new Object[]{entry.getKey()});
            vbnodesMap.remove(entry.getKey());
        }
        return Collections.unmodifiableMap(vbnodesMap);
    }

    public MemcachedNode getAlternative(String k, Collection<MemcachedNode> notMyVbucketNodes) {
        HashMap<String, MemcachedNode> nodesMap = new HashMap<String, MemcachedNode>(this.fullConfig.get().getNodesMap());
        Collection nodes = nodesMap.values();
        nodes.removeAll(notMyVbucketNodes);
        if (nodes.isEmpty()) {
            return null;
        }
        return (MemcachedNode)nodes.iterator().next();
    }

    public List<Integer> getReplicaIndexes(String key) {
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        int vbucket = config.getVbucketByKey(key);
        VBucket bucket = config.getVbuckets().get(vbucket);
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (int i = 0; i < 3; ++i) {
            if (bucket.getReplica(i) == -1) continue;
            indexes.add(i);
        }
        return indexes;
    }

    public boolean hasActiveMaster(String key) {
        TotalConfig totConfig = this.fullConfig.get();
        Config config = totConfig.getConfig();
        int vbucket = config.getVbucketByKey(key);
        VBucket bucket = config.getVbuckets().get(vbucket);
        return bucket.getMaster() != -1;
    }

    private static class NullIterator<E>
    implements Iterator<MemcachedNode> {
        private NullIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public MemcachedNode next() {
            throw new NoSuchElementException("VBucketNodeLocators have no alternate nodes.");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("VBucketNodeLocators have no alternate nodes; cannot remove.");
        }
    }

    private static class TotalConfig {
        private final Config config;
        private final Map<String, MemcachedNode> nodesMap;

        public TotalConfig(Config newConfig, Map<String, MemcachedNode> newMap) {
            this.config = newConfig;
            this.nodesMap = Collections.unmodifiableMap(newMap);
        }

        protected Config getConfig() {
            return this.config;
        }

        protected Map<String, MemcachedNode> getNodesMap() {
            return this.nodesMap;
        }
    }
}

