/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.internal.AdaptiveThrottler;
import com.couchbase.client.internal.ThrottleManager;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.VBucketNodeLocator;
import com.couchbase.client.vbucket.config.Bucket;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.ops.KeyedOperation;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.ReplicaGetOperation;
import net.spy.memcached.ops.VBucketAware;

public class CouchbaseConnection
extends MemcachedConnection
implements Reconfigurable {
    protected volatile boolean reconfiguring = false;
    private final CouchbaseConnectionFactory cf;
    private final ThrottleManager throttleManager;
    private final boolean enableThrottling;

    public CouchbaseConnection(int bufSize, CouchbaseConnectionFactory f, List<InetSocketAddress> a, Collection<ConnectionObserver> obs, FailureMode fm, OperationFactory opfactory) throws IOException {
        super(bufSize, (ConnectionFactory)f, a, obs, fm, opfactory);
        this.cf = f;
        this.enableThrottling = Boolean.parseBoolean(CouchbaseProperties.getProperty("enable_throttle", false));
        this.throttleManager = this.enableThrottling ? new ThrottleManager<AdaptiveThrottler>(a, AdaptiveThrottler.class, this, opfactory) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconfigure(Bucket bucket) {
        if (this.reconfiguring) {
            this.getLogger().debug((Object)"Suppressing attempt to reconfigure again while reconfiguring.");
            return;
        }
        this.reconfiguring = true;
        try {
            List<String> servers = bucket.getConfig().getServers();
            HashSet<InetSocketAddress> newServerAddresses = new HashSet<InetSocketAddress>();
            ArrayList<InetSocketAddress> newServers = new ArrayList<InetSocketAddress>();
            for (String server : servers) {
                int finalColon = server.lastIndexOf(58);
                if (finalColon < 1) {
                    throw new IllegalArgumentException("Invalid server ``" + server + "'' in vbucket's server list");
                }
                String hostPart = server.substring(0, finalColon);
                String portNum = server.substring(finalColon + 1);
                InetSocketAddress address = new InetSocketAddress(hostPart, Integer.parseInt(portNum));
                newServerAddresses.add(address);
                newServers.add(address);
            }
            ArrayList<MemcachedNode> oddNodes = new ArrayList<MemcachedNode>();
            ArrayList<MemcachedNode> stayNodes = new ArrayList<MemcachedNode>();
            ArrayList<InetSocketAddress> stayServers = new ArrayList<InetSocketAddress>();
            for (MemcachedNode current : this.locator.getAll()) {
                if (newServerAddresses.contains(current.getSocketAddress())) {
                    stayNodes.add(current);
                    stayServers.add((InetSocketAddress)current.getSocketAddress());
                    continue;
                }
                oddNodes.add(current);
            }
            newServers.removeAll(stayServers);
            List newNodes = this.createConnections(newServers);
            ArrayList<MemcachedNode> mergedNodes = new ArrayList<MemcachedNode>();
            mergedNodes.addAll(stayNodes);
            mergedNodes.addAll(newNodes);
            for (MemcachedNode keepingNode : mergedNodes) {
                this.getLogger().debug((Object)("Node " + keepingNode.getSocketAddress() + " will stay in cluster config after reconfiguration."));
            }
            if (this.locator instanceof VBucketNodeLocator) {
                ((VBucketNodeLocator)this.locator).updateLocator(mergedNodes, bucket.getConfig());
            } else {
                this.locator.updateLocator(mergedNodes);
            }
            if (this.enableThrottling) {
                for (MemcachedNode node : newNodes) {
                    this.throttleManager.setThrottler((InetSocketAddress)node.getSocketAddress());
                }
                for (MemcachedNode node : oddNodes) {
                    this.throttleManager.removeThrottler((InetSocketAddress)node.getSocketAddress());
                }
            }
            for (MemcachedNode shutDownNode : oddNodes) {
                this.getLogger().info((Object)("Scheduling Node " + shutDownNode.getSocketAddress() + " for shutdown."));
            }
            this.nodesToShutdown.addAll(oddNodes);
        }
        catch (IOException e) {
            this.getLogger().error((Object)"Connection reconfiguration failed", (Throwable)e);
        }
        finally {
            this.reconfiguring = false;
        }
    }

    public void addOperation(String key, Operation o) {
        MemcachedNode placeIn = null;
        MemcachedNode primary = o instanceof ReplicaGetOperation && this.locator instanceof VBucketNodeLocator ? ((VBucketNodeLocator)this.locator).getReplica(key, ((ReplicaGetOperation)o).getReplicaIndex()) : this.locator.getPrimary(key);
        if (primary == null) {
            o.cancel();
            this.cf.checkConfigUpdate();
            return;
        }
        if (primary.isActive() || this.failureMode == FailureMode.Retry) {
            placeIn = primary;
        } else if (this.failureMode == FailureMode.Cancel) {
            o.cancel();
        } else {
            Iterator i = this.locator.getSequence(key);
            while (placeIn == null && i.hasNext()) {
                MemcachedNode n = (MemcachedNode)i.next();
                if (!n.isActive()) continue;
                placeIn = n;
            }
            if (placeIn == null) {
                placeIn = primary;
                this.getLogger().warn("Node expected to receive data is inactive. This could be due to a failure within the cluster. Will check for updated configuration. Key without a configured node is: %s.", new Object[]{key});
                this.cf.checkConfigUpdate();
            }
        }
        assert (o.isCancelled() || placeIn != null) : "No node found for key " + key;
        if (placeIn != null) {
            if (this.locator instanceof VBucketNodeLocator) {
                VBucketNodeLocator vbucketLocator = (VBucketNodeLocator)this.locator;
                short vbucketIndex = (short)vbucketLocator.getVBucketIndex(key);
                if (o instanceof VBucketAware) {
                    MemcachedNode alternative;
                    VBucketAware vbucketAwareOp = (VBucketAware)o;
                    vbucketAwareOp.setVBucket(key, vbucketIndex);
                    if (!vbucketAwareOp.getNotMyVbucketNodes().isEmpty() && (alternative = vbucketLocator.getAlternative(key, vbucketAwareOp.getNotMyVbucketNodes())) != null) {
                        placeIn = alternative;
                    }
                }
            }
            if (this.enableThrottling) {
                this.throttleManager.getThrottler((InetSocketAddress)placeIn.getSocketAddress()).throttle();
            }
            this.addOperation(placeIn, o);
        } else assert (o.isCancelled()) : "No node found for " + key + " (and not immediately cancelled)";
    }

    public void addOperations(Map<MemcachedNode, Operation> ops) {
        for (Map.Entry<MemcachedNode, Operation> me : ops.entrySet()) {
            MemcachedNode node = me.getKey();
            if (!node.isActive()) {
                this.cf.checkConfigUpdate();
            }
            Operation o = me.getValue();
            if (this.locator instanceof VBucketNodeLocator && o instanceof KeyedOperation && o instanceof VBucketAware) {
                Collection keys = ((KeyedOperation)o).getKeys();
                VBucketNodeLocator vbucketLocator = (VBucketNodeLocator)this.locator;
                for (String key : keys) {
                    short vbucketIndex = (short)vbucketLocator.getVBucketIndex(key);
                    VBucketAware vbucketAwareOp = (VBucketAware)o;
                    vbucketAwareOp.setVBucket(key, vbucketIndex);
                }
            }
            o.setHandlingNode(node);
            o.initialize();
            node.addOp(o);
            this.addedQueue.offer(node);
        }
        Selector s = this.selector.wakeup();
        assert (s == this.selector) : "Wakeup returned the wrong selector.";
    }

    public void run() {
        while (this.running) {
            if (this.reconfiguring) continue;
            try {
                this.handleIO();
            }
            catch (IOException e) {
                this.logRunException(e);
            }
            catch (CancelledKeyException e) {
                this.logRunException(e);
            }
            catch (ClosedSelectorException e) {
                this.logRunException(e);
            }
            catch (IllegalStateException e) {
                this.logRunException(e);
            }
            catch (ConcurrentModificationException e) {
                this.logRunException(e);
            }
        }
        this.getLogger().info((Object)"Shut down Couchbase client");
    }

    protected void handleRetryInformation(byte[] retryMessage) {
        String message = new String(retryMessage).trim();
        if (message.startsWith("{")) {
            this.cf.getConfigurationProvider().setConfig(this.replaceConfigWildcards(message));
        }
    }

    public String replaceConfigWildcards(String original) {
        if (original.contains("$HOST")) {
            ArrayList nodes = new ArrayList(this.getLocator().getAll());
            if (nodes.size() > 0) {
                InetSocketAddress addr = (InetSocketAddress)((MemcachedNode)nodes.get(0)).getSocketAddress();
                return original.replaceAll("\\$HOST", addr.getHostName());
            }
            throw new IllegalStateException("Locator has no nodes attached, this is not allowed.");
        }
        return original;
    }

    private void logRunException(Exception e) {
        if (this.shutDown) {
            this.getLogger().debug((Object)"Exception occurred during shutdown", (Throwable)e);
        } else {
            this.getLogger().warn((Object)"Problem handling Couchbase IO", (Throwable)e);
        }
    }
}

