/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.vbucket.CouchbaseNodeOrder;
import com.couchbase.client.vbucket.config.Config;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.FailureMode;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.metrics.MetricCollector;
import net.spy.memcached.metrics.MetricType;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.transcoders.Transcoder;

public class CouchbaseConnectionFactoryBuilder
extends ConnectionFactoryBuilder {
    private Config vBucketConfig;
    private long reconnThresholdTimeMsecs = 1100L;
    private long obsPollInterval = 10L;
    private int obsPollMax = 500;
    private long obsTimeout = 5000L;
    private int viewTimeout = 75000;
    private int viewWorkers = 1;
    private int viewConns = 10;
    private CouchbaseNodeOrder nodeOrder = CouchbaseConnectionFactory.DEFAULT_STREAMING_NODE_ORDER;
    private static final Logger LOGGER = Logger.getLogger(CouchbaseConnectionFactoryBuilder.class.getName());
    protected MetricType metricType = null;
    protected MetricCollector collector = null;
    protected ExecutorService executorService = null;

    public Config getVBucketConfig() {
        return this.vBucketConfig;
    }

    public void setVBucketConfig(Config config) {
        this.vBucketConfig = config;
    }

    public void setReconnectThresholdTime(long time, TimeUnit unit) {
        this.reconnThresholdTimeMsecs = TimeUnit.MILLISECONDS.convert(time, unit);
    }

    public CouchbaseConnectionFactoryBuilder setObsPollInterval(long interval) {
        this.obsPollInterval = interval;
        return this;
    }

    public CouchbaseConnectionFactoryBuilder setObsTimeout(long timeout) {
        this.obsTimeout = timeout;
        return this;
    }

    @Deprecated
    public CouchbaseConnectionFactoryBuilder setObsPollMax(int maxPoll) {
        this.obsPollMax = maxPoll;
        return this;
    }

    public CouchbaseConnectionFactoryBuilder setViewTimeout(int timeout) {
        if (timeout < 500) {
            timeout = 500;
            LOGGER.log(Level.WARNING, "ViewTimeout is too short. Overriding viewTimeout with threshold of 500ms.");
        } else if (timeout < 2500) {
            LOGGER.log(Level.WARNING, "ViewTimeout is very short, should be more than 2500ms.");
        }
        this.viewTimeout = timeout;
        return this;
    }

    public CouchbaseConnectionFactoryBuilder setViewWorkerSize(int workers) {
        if (workers < 1) {
            throw new IllegalArgumentException("The View worker size needs to be greater than zero.");
        }
        this.viewWorkers = workers;
        return this;
    }

    public CouchbaseConnectionFactoryBuilder setViewConnsPerNode(int conns) {
        if (conns < 1) {
            throw new IllegalArgumentException("The View connections per node need to be greater than zero");
        }
        this.viewConns = conns;
        return this;
    }

    public CouchbaseConnectionFactoryBuilder setStreamingNodeOrder(CouchbaseNodeOrder order) {
        this.nodeOrder = order;
        return this;
    }

    public ConnectionFactoryBuilder setEnableMetrics(MetricType type) {
        this.metricType = type;
        return this;
    }

    public ConnectionFactoryBuilder setMetricCollector(MetricCollector collector) {
        this.collector = collector;
        return this;
    }

    public ConnectionFactoryBuilder setListenerExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public CouchbaseConnectionFactory buildCouchbaseConnection(List<URI> baseList, String bucketName, String pwd) throws IOException {
        return this.buildCouchbaseConnection(baseList, bucketName, bucketName, pwd);
    }

    public CouchbaseConnectionFactory buildCouchbaseConnection(List<URI> baseList, String bucketName, String usr, String pwd) throws IOException {
        return new CouchbaseConnectionFactory(baseList, bucketName, pwd){

            public BlockingQueue<Operation> createOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : CouchbaseConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            public BlockingQueue<Operation> createReadOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : CouchbaseConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            public BlockingQueue<Operation> createWriteOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : CouchbaseConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            public Transcoder<Object> getDefaultTranscoder() {
                return CouchbaseConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : CouchbaseConnectionFactoryBuilder.this.transcoder;
            }

            public FailureMode getFailureMode() {
                return CouchbaseConnectionFactoryBuilder.this.failureMode == null ? DEFAULT_FAILURE_MODE : CouchbaseConnectionFactoryBuilder.this.failureMode;
            }

            public HashAlgorithm getHashAlg() {
                return CouchbaseConnectionFactoryBuilder.this.hashAlg == null ? DEFAULT_HASH : CouchbaseConnectionFactoryBuilder.this.hashAlg;
            }

            public Collection<ConnectionObserver> getInitialObservers() {
                return CouchbaseConnectionFactoryBuilder.this.initialObservers;
            }

            public OperationFactory getOperationFactory() {
                return CouchbaseConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : CouchbaseConnectionFactoryBuilder.this.opFact;
            }

            public long getOperationTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : CouchbaseConnectionFactoryBuilder.this.opTimeout;
            }

            public int getReadBufSize() {
                return CouchbaseConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : CouchbaseConnectionFactoryBuilder.this.readBufSize;
            }

            public boolean isDaemon() {
                return CouchbaseConnectionFactoryBuilder.this.isDaemon;
            }

            @Override
            public boolean shouldOptimize() {
                return false;
            }

            public boolean useNagleAlgorithm() {
                return CouchbaseConnectionFactoryBuilder.this.useNagle;
            }

            public long getMaxReconnectDelay() {
                return CouchbaseConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            public long getOpQueueMaxBlockTime() {
                return CouchbaseConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? CouchbaseConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            public int getTimeoutExceptionThreshold() {
                return CouchbaseConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            @Override
            public long getMinReconnectInterval() {
                return CouchbaseConnectionFactoryBuilder.this.reconnThresholdTimeMsecs;
            }

            @Override
            public long getObsPollInterval() {
                return CouchbaseConnectionFactoryBuilder.this.obsPollInterval;
            }

            @Override
            public long getObsTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.obsTimeout;
            }

            @Override
            public int getViewTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.viewTimeout;
            }

            @Override
            public int getViewWorkerSize() {
                return CouchbaseConnectionFactoryBuilder.this.viewWorkers;
            }

            @Override
            public int getViewConnsPerNode() {
                return CouchbaseConnectionFactoryBuilder.this.viewConns;
            }

            public MetricType enableMetrics() {
                return CouchbaseConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : CouchbaseConnectionFactoryBuilder.this.metricType;
            }

            public MetricCollector getMetricCollector() {
                return CouchbaseConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : CouchbaseConnectionFactoryBuilder.this.collector;
            }

            public ExecutorService getListenerExecutorService() {
                return CouchbaseConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : CouchbaseConnectionFactoryBuilder.this.executorService;
            }

            public boolean isDefaultExecutorService() {
                return CouchbaseConnectionFactoryBuilder.this.executorService == null;
            }
        };
    }

    public CouchbaseConnectionFactory buildCouchbaseConnection() throws IOException {
        return new CouchbaseConnectionFactory(){

            public BlockingQueue<Operation> createOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.opQueueFactory == null ? super.createOperationQueue() : CouchbaseConnectionFactoryBuilder.this.opQueueFactory.create();
            }

            public BlockingQueue<Operation> createReadOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.readQueueFactory == null ? super.createReadOperationQueue() : CouchbaseConnectionFactoryBuilder.this.readQueueFactory.create();
            }

            public BlockingQueue<Operation> createWriteOperationQueue() {
                return CouchbaseConnectionFactoryBuilder.this.writeQueueFactory == null ? super.createReadOperationQueue() : CouchbaseConnectionFactoryBuilder.this.writeQueueFactory.create();
            }

            public Transcoder<Object> getDefaultTranscoder() {
                return CouchbaseConnectionFactoryBuilder.this.transcoder == null ? super.getDefaultTranscoder() : CouchbaseConnectionFactoryBuilder.this.transcoder;
            }

            public FailureMode getFailureMode() {
                return CouchbaseConnectionFactoryBuilder.this.failureMode == null ? DEFAULT_FAILURE_MODE : CouchbaseConnectionFactoryBuilder.this.failureMode;
            }

            public HashAlgorithm getHashAlg() {
                return CouchbaseConnectionFactoryBuilder.this.hashAlg == null ? DEFAULT_HASH : CouchbaseConnectionFactoryBuilder.this.hashAlg;
            }

            public Collection<ConnectionObserver> getInitialObservers() {
                return CouchbaseConnectionFactoryBuilder.this.initialObservers;
            }

            public OperationFactory getOperationFactory() {
                return CouchbaseConnectionFactoryBuilder.this.opFact == null ? super.getOperationFactory() : CouchbaseConnectionFactoryBuilder.this.opFact;
            }

            public long getOperationTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.opTimeout == -1L ? super.getOperationTimeout() : CouchbaseConnectionFactoryBuilder.this.opTimeout;
            }

            public int getReadBufSize() {
                return CouchbaseConnectionFactoryBuilder.this.readBufSize == -1 ? super.getReadBufSize() : CouchbaseConnectionFactoryBuilder.this.readBufSize;
            }

            public boolean isDaemon() {
                return CouchbaseConnectionFactoryBuilder.this.isDaemon;
            }

            @Override
            public boolean shouldOptimize() {
                return false;
            }

            public boolean useNagleAlgorithm() {
                return CouchbaseConnectionFactoryBuilder.this.useNagle;
            }

            public long getMaxReconnectDelay() {
                return CouchbaseConnectionFactoryBuilder.this.maxReconnectDelay;
            }

            public long getOpQueueMaxBlockTime() {
                return CouchbaseConnectionFactoryBuilder.this.opQueueMaxBlockTime > -1L ? CouchbaseConnectionFactoryBuilder.this.opQueueMaxBlockTime : super.getOpQueueMaxBlockTime();
            }

            public int getTimeoutExceptionThreshold() {
                return CouchbaseConnectionFactoryBuilder.this.timeoutExceptionThreshold;
            }

            @Override
            public long getMinReconnectInterval() {
                return CouchbaseConnectionFactoryBuilder.this.reconnThresholdTimeMsecs;
            }

            @Override
            public long getObsPollInterval() {
                return CouchbaseConnectionFactoryBuilder.this.obsPollInterval;
            }

            @Override
            public long getObsTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.obsTimeout;
            }

            @Override
            public int getViewTimeout() {
                return CouchbaseConnectionFactoryBuilder.this.viewTimeout;
            }

            @Override
            public int getViewWorkerSize() {
                return CouchbaseConnectionFactoryBuilder.this.viewWorkers;
            }

            @Override
            public int getViewConnsPerNode() {
                return CouchbaseConnectionFactoryBuilder.this.viewConns;
            }

            public MetricType enableMetrics() {
                return CouchbaseConnectionFactoryBuilder.this.metricType == null ? super.enableMetrics() : CouchbaseConnectionFactoryBuilder.this.metricType;
            }

            public MetricCollector getMetricCollector() {
                return CouchbaseConnectionFactoryBuilder.this.collector == null ? super.getMetricCollector() : CouchbaseConnectionFactoryBuilder.this.collector;
            }

            public ExecutorService getListenerExecutorService() {
                return CouchbaseConnectionFactoryBuilder.this.executorService == null ? super.getListenerExecutorService() : CouchbaseConnectionFactoryBuilder.this.executorService;
            }

            public boolean isDefaultExecutorService() {
                return CouchbaseConnectionFactoryBuilder.this.executorService == null;
            }
        };
    }

    public long getObsPollInterval() {
        return this.obsPollInterval;
    }

    public int getObsPollMax() {
        return this.obsPollMax;
    }

    public long getObsTimeout() {
        return this.obsTimeout;
    }

    public int getViewTimeout() {
        return this.viewTimeout;
    }

    public int getViewWorkerSize() {
        return this.viewWorkers;
    }

    public int getViewConnsPerNode() {
        return this.viewConns;
    }
}

