/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.internal.ReplicaGetCompletionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.internal.AbstractListenableFuture;

public class ReplicaGetFuture<T>
extends AbstractListenableFuture<T, ReplicaGetCompletionListener>
implements Future<T> {
    private final long timeout;
    private AtomicReference<Future<T>> completedFuture;
    private final List<Future<T>> monitoredFutures;
    private volatile boolean cancelled = false;

    public ReplicaGetFuture(long timeout, ExecutorService service) {
        super(service);
        this.timeout = timeout;
        this.monitoredFutures = Collections.synchronizedList(new ArrayList());
        this.completedFuture = new AtomicReference();
    }

    public void addFutureToMonitor(Future<T> future) {
        this.monitoredFutures.add(future);
    }

    public boolean setCompletedFuture(Future<T> future) {
        boolean firstComplete = this.completedFuture.compareAndSet(null, future);
        if (firstComplete) {
            this.cancelOtherFutures(this.completedFuture.get());
        }
        return firstComplete;
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Timed out waiting for operation", e);
        }
    }

    @Override
    public T get(long userTimeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long start = System.currentTimeMillis();
        long timeoutMs = TimeUnit.MILLISECONDS.convert(userTimeout, unit);
        while (System.currentTimeMillis() - start <= timeoutMs) {
            if (!this.isDone() || this.completedFuture.get().isCancelled()) continue;
            return this.completedFuture.get().get();
        }
        throw new TimeoutException("No replica get future returned with success before timeout.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelOtherFutures(Future successFuture) {
        List<Future<T>> list = this.monitoredFutures;
        synchronized (list) {
            for (Future<T> future : this.monitoredFutures) {
                if (future.equals(successFuture)) continue;
                future.cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean ign) {
        this.cancelled = true;
        boolean allCancelled = true;
        List<Future<T>> list = this.monitoredFutures;
        synchronized (list) {
            for (Future<T> future : this.monitoredFutures) {
                if (future.cancel(ign)) continue;
                allCancelled = false;
            }
        }
        this.notifyListeners();
        return allCancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.completedFuture.get() != null && this.completedFuture.get().isDone();
    }

    public ReplicaGetFuture<T> addListener(ReplicaGetCompletionListener listener) {
        this.addToListeners(listener);
        return this;
    }

    public ReplicaGetFuture<T> removeListener(ReplicaGetCompletionListener listener) {
        this.removeFromListeners(listener);
        return this;
    }

    public void signalComplete() {
        this.notifyListeners();
    }
}

