/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.config;

import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigFactory;
import com.couchbase.client.vbucket.config.ConfigParsingException;
import com.couchbase.client.vbucket.config.CouchbaseConfig;
import com.couchbase.client.vbucket.config.MemcacheConfig;
import com.couchbase.client.vbucket.config.VBucket;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.HashAlgorithmRegistry;
import net.spy.memcached.compat.SpyObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class DefaultConfigFactory
extends SpyObject
implements ConfigFactory {
    @Override
    public Config create(File source) {
        if (source == null || source.getName().isEmpty()) {
            throw new IllegalArgumentException("Filename is empty.");
        }
        StringBuilder builder = new StringBuilder();
        try {
            String str;
            FileInputStream fis = new FileInputStream(source);
            BufferedReader reader = new BufferedReader(new InputStreamReader(fis));
            while ((str = reader.readLine()) != null) {
                builder.append(str);
            }
        }
        catch (IOException e) {
            throw new ConfigParsingException("Exception reading input file: " + source, e);
        }
        return this.create(builder.toString());
    }

    @Override
    public Config create(String source) {
        try {
            return this.parseJSON(new JSONObject(source), null);
        }
        catch (JSONException e) {
            throw new ConfigParsingException("Exception parsing JSON source: " + source, e);
        }
    }

    @Override
    public Config create(JSONObject source) {
        try {
            return this.parseJSON(source, null);
        }
        catch (JSONException e) {
            throw new ConfigParsingException("Exception parsing JSON data: " + source, e);
        }
    }

    @Override
    public Config create(JSONObject source, Config oldConfig) {
        try {
            return this.parseJSON(source, oldConfig);
        }
        catch (JSONException e) {
            throw new ConfigParsingException("Exception parsing JSON data: " + source, e);
        }
    }

    private Config parseJSON(JSONObject source, Config oldConfig) throws JSONException {
        return source.has("vBucketServerMap") ? this.parseCouchbaseBucketJSON(source, oldConfig) : this.parseMemcacheBucketJSON(source);
    }

    private Config parseMemcacheBucketJSON(JSONObject source) throws JSONException {
        JSONArray nodes = source.getJSONArray("nodes");
        int amountOfNodes = nodes.length();
        if (amountOfNodes <= 0) {
            throw new ConfigParsingException("Empty nodes list.");
        }
        List<String> populatedRestEndpoints = this.populateRestEndpoints(nodes);
        MemcacheConfig config = new MemcacheConfig(amountOfNodes, populatedRestEndpoints);
        this.populateServersForMemcacheBucket(config, nodes);
        return config;
    }

    private void populateServersForMemcacheBucket(MemcacheConfig config, JSONArray nodes) throws JSONException {
        ArrayList<String> serverNames = new ArrayList<String>(nodes.length());
        for (int i = 0; i < nodes.length(); ++i) {
            JSONObject node = nodes.getJSONObject(i);
            String[] webHostPort = node.getString("hostname").split(":");
            JSONObject portsList = node.getJSONObject("ports");
            int port = portsList.getInt("direct");
            serverNames.add(webHostPort[0] + ":" + port);
        }
        config.setServers(serverNames);
    }

    private Config parseCouchbaseBucketJSON(JSONObject source, Config oldConfig) throws JSONException {
        JSONObject vBucketServerMap = source.getJSONObject("vBucketServerMap");
        String algorithm = vBucketServerMap.getString("hashAlgorithm");
        HashAlgorithm hashAlgorithm = HashAlgorithmRegistry.lookupHashAlgorithm((String)algorithm);
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("Unhandled hash algorithm type: " + algorithm);
        }
        int replicasCount = vBucketServerMap.getInt("numReplicas");
        if (replicasCount > 3) {
            throw new ConfigParsingException("Expected number <= 3 for replicas.");
        }
        JSONArray servers = vBucketServerMap.getJSONArray("serverList");
        int serversCount = servers.length();
        if (serversCount <= 0) {
            throw new ConfigParsingException("Empty servers list.");
        }
        JSONArray viewServers = source.getJSONArray("nodes");
        int viewServersCount = viewServers.length();
        if (viewServersCount <= 0) {
            throw new ConfigParsingException("Empty view servers list.");
        }
        JSONArray vBuckets = vBucketServerMap.getJSONArray("vBucketMap");
        int vBucketsCount = vBuckets.length();
        if (vBucketsCount == 0 || (vBucketsCount & vBucketsCount - 1) != 0) {
            throw new ConfigParsingException("Number of vBuckets must be a power of two, > 0 and <= 65536 (got " + vBucketsCount + ")");
        }
        List<String> populatedServers = this.populateServersForCouchbaseBucket(servers);
        List<VBucket> populatedVBuckets = this.populateVBuckets(vBuckets, oldConfig);
        List<URL> populatedViewServers = this.populateViewServers(viewServers);
        List<String> populatedRestEndpoints = this.populateRestEndpoints(viewServers);
        return new CouchbaseConfig(hashAlgorithm, serversCount, replicasCount, vBucketsCount, populatedServers, populatedVBuckets, populatedViewServers, populatedRestEndpoints);
    }

    private List<String> populateRestEndpoints(JSONArray nodes) throws JSONException {
        int nodeSize = nodes.length();
        ArrayList<String> endpoints = new ArrayList<String>(nodeSize);
        for (int i = 0; i < nodeSize; ++i) {
            JSONObject node = nodes.getJSONObject(i);
            if (!node.has("hostname")) continue;
            endpoints.add("http://" + node.getString("hostname") + "/pools");
        }
        return endpoints;
    }

    private List<URL> populateViewServers(JSONArray nodes) throws JSONException {
        int nodeSize = nodes.length();
        ArrayList<URL> nodeUrls = new ArrayList<URL>(nodeSize);
        for (int i = 0; i < nodeSize; ++i) {
            JSONObject node = nodes.getJSONObject(i);
            if (!node.has("couchApiBase")) continue;
            try {
                nodeUrls.add(new URL(node.getString("couchApiBase")));
                continue;
            }
            catch (MalformedURLException e) {
                throw new JSONException("Got bad couchApiBase URL from config");
            }
        }
        return nodeUrls;
    }

    private List<String> populateServersForCouchbaseBucket(JSONArray nodes) throws JSONException {
        int nodeSize = nodes.length();
        ArrayList<String> serverNames = new ArrayList<String>(nodeSize);
        for (int i = 0; i < nodeSize; ++i) {
            serverNames.add(nodes.getString(i));
        }
        return serverNames;
    }

    private List<VBucket> populateVBuckets(JSONArray source, Config oldConfig) throws JSONException {
        int numVBuckets = source.length();
        ArrayList<VBucket> vBuckets = new ArrayList<VBucket>(numVBuckets);
        List<VBucket> oldvBuckets = null;
        if (oldConfig != null) {
            oldvBuckets = oldConfig.getVbuckets();
        }
        for (int i = 0; i < numVBuckets; ++i) {
            VBucket vbucket;
            VBucket old;
            JSONArray rows = source.getJSONArray(i);
            short master = (short)rows.getInt(0);
            int replicaSize = rows.length() - 1;
            short[] replicas = new short[replicaSize];
            for (int j = 1; j < rows.length(); ++j) {
                replicas[j - 1] = (short)rows.getInt(j);
            }
            if (oldvBuckets != null && (old = oldvBuckets.get(i)).getMaster() == master) {
                boolean identicalReplicas = true;
                for (int r = 0; r < replicaSize; ++r) {
                    if (replicas[r] == old.getReplica(r)) continue;
                    identicalReplicas = false;
                    break;
                }
                if (identicalReplicas) {
                    vBuckets.add(old);
                    continue;
                }
            }
            switch (replicaSize) {
                case 0: {
                    vbucket = new VBucket(master);
                    break;
                }
                case 1: {
                    vbucket = new VBucket(master, replicas[0]);
                    break;
                }
                case 2: {
                    vbucket = new VBucket(master, replicas[0], replicas[1]);
                    break;
                }
                case 3: {
                    vbucket = new VBucket(master, replicas[0], replicas[1], replicas[2]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Not more than 3 replicas supported");
                }
            }
            vBuckets.add(vbucket);
        }
        return vBuckets;
    }
}

