/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.provider;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.vbucket.ConfigurationException;
import com.couchbase.client.vbucket.ConfigurationProviderHTTP;
import com.couchbase.client.vbucket.CouchbaseNodeOrder;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigurationParser;
import com.couchbase.client.vbucket.config.ConfigurationParserJSON;
import com.couchbase.client.vbucket.provider.ConfigurationProvider;
import com.couchbase.client.vbucket.provider.CouchbaseConfigConnection;
import com.couchbase.client.vbucket.provider.GetConfigOperationImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthThreadMonitor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;

public class BucketConfigurationProvider
extends SpyObject
implements ConfigurationProvider,
Reconfigurable {
    private static final int DEFAULT_BINARY_PORT = 11210;
    private static final String ANONYMOUS_BUCKET = "default";
    private final AtomicReference<Bucket> config = new AtomicReference();
    private final List<URI> seedNodes;
    private final List<Reconfigurable> observers;
    private final String bucket;
    private final String password;
    private final CouchbaseConnectionFactory connectionFactory;
    private final ConfigurationParser configurationParser = new ConfigurationParserJSON();
    private final AtomicReference<ConfigurationProviderHTTP> httpProvider;
    private final AtomicBoolean refreshingHttp;
    private final AtomicReference<CouchbaseConnection> binaryConnection;
    private volatile boolean isBinary;

    public BucketConfigurationProvider(List<URI> seedNodes, String bucket, String password, CouchbaseConnectionFactory connectionFactory) {
        this.httpProvider = new AtomicReference<ConfigurationProviderHTTP>(new ConfigurationProviderHTTP(seedNodes, bucket, password));
        this.refreshingHttp = new AtomicBoolean(false);
        this.observers = Collections.synchronizedList(new ArrayList());
        this.binaryConnection = new AtomicReference();
        this.seedNodes = Collections.synchronizedList(new ArrayList<URI>(seedNodes));
        this.bucket = bucket;
        this.password = password;
        this.connectionFactory = connectionFactory;
        this.potentiallyRandomizeNodeList(seedNodes);
    }

    @Override
    public Bucket bootstrap() {
        this.isBinary = false;
        if (!this.bootstrapBinary() && !this.bootstrapHttp()) {
            throw new ConfigurationException("Could not fetch a valid Bucket configuration.");
        }
        if (this.isBinary) {
            this.getLogger().info((Object)"Could bootstrap through carrier publication.");
        } else {
            this.getLogger().info((Object)"Binary config not available, bootstrapped through HTTP.");
        }
        this.monitorBucket();
        return this.config.get();
    }

    boolean bootstrapBinary() {
        this.isBinary = true;
        ArrayList<InetSocketAddress> nodes = new ArrayList<InetSocketAddress>(this.seedNodes.size());
        for (URI seedNode : this.seedNodes) {
            nodes.add(new InetSocketAddress(seedNode.getHost(), 11210));
        }
        try {
            for (InetSocketAddress node : nodes) {
                if (!this.tryBinaryBootstrapForNode(node)) continue;
                return true;
            }
            this.getLogger().debug((Object)"Not a single node returned a carrier publication config.");
            this.isBinary = false;
            return false;
        }
        catch (Exception ex) {
            this.getLogger().info((Object)"Could not fetch config from carrier publication seed nodes.", (Throwable)ex);
            this.isBinary = false;
            return false;
        }
    }

    private boolean tryBinaryBootstrapForNode(InetSocketAddress node) throws Exception {
        List<String> configs;
        CouchbaseConfigConnection connection;
        ConfigurationConnectionFactory fact = new ConfigurationConnectionFactory(this.seedNodes, this.bucket, this.password);
        CouchbaseConnectionFactory cf = this.connectionFactory;
        try {
            connection = new CouchbaseConfigConnection(cf.getReadBufSize(), fact, Collections.singletonList(node), cf.getInitialObservers(), cf.getFailureMode(), cf.getOperationFactory());
        }
        catch (Exception ex) {
            this.getLogger().debug((Object)("(Carrier Publication) Could not load config from " + node.getHostName() + ", trying next node."), (Throwable)ex);
            return false;
        }
        if (!this.bucket.equals(ANONYMOUS_BUCKET)) {
            AuthThreadMonitor monitor = new AuthThreadMonitor();
            ArrayList connectedNodes = new ArrayList(connection.getLocator().getAll());
            for (MemcachedNode connectedNode : connectedNodes) {
                monitor.authConnection((MemcachedConnection)connection, cf.getOperationFactory(), cf.getAuthDescriptor(), connectedNode);
            }
        }
        if ((configs = this.getConfigsFromBinaryConnection(connection)).isEmpty()) {
            this.getLogger().debug((Object)("(Carrier Publication) Could not load config from " + node.getHostName() + ", trying next node."));
            connection.shutdown();
            return false;
        }
        String appliedConfig = connection.replaceConfigWildcards(configs.get(0));
        Bucket config = this.configurationParser.parseBucket(appliedConfig);
        this.setConfig(config);
        this.binaryConnection.set(connection);
        return true;
    }

    private List<String> getConfigsFromBinaryConnection(CouchbaseConnection connection) throws Exception {
        final List<String> configs = Collections.synchronizedList(new ArrayList());
        CountDownLatch blatch = connection.broadcastOperation(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                return new GetConfigOperationImpl(new OperationCallback(){

                    public void receivedStatus(OperationStatus status) {
                        if (status.isSuccess()) {
                            configs.add(status.getMessage());
                        }
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
            }
        });
        blatch.await(this.connectionFactory.getOperationTimeout(), TimeUnit.MILLISECONDS);
        return configs;
    }

    boolean bootstrapHttp() {
        try {
            Bucket config = this.httpProvider.get().getBucketConfiguration(this.bucket);
            this.setConfig(config);
            this.isBinary = false;
            return true;
        }
        catch (Exception ex) {
            this.getLogger().info((Object)"Could not fetch config from http seed nodes.", (Throwable)ex);
            return false;
        }
    }

    private void monitorBucket() {
        if (!this.isBinary) {
            this.httpProvider.get().subscribe(this.bucket, this);
        }
    }

    @Override
    public void reconfigure(Bucket bucket) {
        this.setConfig(bucket);
    }

    @Override
    public Bucket getConfig() {
        if (this.config.get() == null) {
            this.bootstrap();
        }
        return this.config.get();
    }

    @Override
    public void setConfig(Bucket config) {
        this.getLogger().debug((Object)("Applying new bucket config for bucket \"" + this.bucket + "\" (carrier publication: " + this.isBinary + "): " + config));
        this.config.set(config);
        this.updateSeedNodes();
        if (config.isNotUpdating()) {
            this.signalOutdated();
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSeedNodes() {
        Config config = this.config.get().getConfig();
        List<String> clusterNodes = config.getRestEndpoints();
        if (!clusterNodes.isEmpty()) {
            ArrayList<URI> newNodes = new ArrayList<URI>();
            for (String clusterNode : clusterNodes) {
                try {
                    newNodes.add(new URI(clusterNode));
                }
                catch (URISyntaxException ex) {
                    this.getLogger().warn((Object)"Could not add node to updated bucket list because of a parsing exception.");
                    this.getLogger().debug((Object)("Could not parse list because: " + ex));
                }
            }
            if (BucketConfigurationProvider.seedNodesAreDifferent(this.seedNodes, newNodes)) {
                this.potentiallyRandomizeNodeList(newNodes);
                List<URI> list = this.seedNodes;
                synchronized (list) {
                    this.seedNodes.clear();
                    this.seedNodes.addAll(newNodes);
                }
                this.httpProvider.get().updateBaseListFromConfig(this.seedNodes);
            }
        }
    }

    private void potentiallyRandomizeNodeList(List<URI> list) {
        if (this.connectionFactory.getStreamingNodeOrder() == CouchbaseNodeOrder.ORDERED) {
            return;
        }
        Collections.shuffle(list);
    }

    private static boolean seedNodesAreDifferent(List<URI> left, List<URI> right) {
        if (left.size() != right.size()) {
            return true;
        }
        for (URI uri : left) {
            if (right.contains(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void signalOutdated() {
        if (this.isBinary) {
            if (this.binaryConnection.get() == null) {
                this.bootstrap();
            } else {
                try {
                    List<String> configs = this.getConfigsFromBinaryConnection(this.binaryConnection.get());
                    if (configs.isEmpty()) {
                        this.bootstrap();
                        return;
                    }
                    String appliedConfig = this.binaryConnection.get().replaceConfigWildcards(configs.get(0));
                    Bucket config = this.configurationParser.parseBucket(appliedConfig);
                    this.setConfig(config);
                }
                catch (Exception ex) {
                    this.getLogger().info((Object)"Could not load config from existing connection, rerunning bootstrap.", (Throwable)ex);
                    this.bootstrap();
                }
            }
        } else if (this.refreshingHttp.compareAndSet(false, true)) {
            Thread refresherThread = new Thread(new HttpProviderRefresher(this));
            refresherThread.setName("HttpConfigurationProvider Reloader");
            refresherThread.start();
        } else {
            this.getLogger().debug((Object)"Suppressing duplicate refreshing attempt.");
        }
    }

    @Override
    public void shutdown() {
        if (this.httpProvider.get() != null) {
            this.httpProvider.get().shutdown();
        }
        if (this.binaryConnection.get() != null) {
            try {
                this.binaryConnection.get().shutdown();
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"Could not shutdown carrier publication config connection.");
            }
        }
    }

    @Override
    public String getAnonymousAuthBucket() {
        return ANONYMOUS_BUCKET;
    }

    @Override
    public void setConfig(String config) {
        try {
            this.setConfig(this.configurationParser.parseBucket(config));
        }
        catch (Exception ex) {
            this.getLogger().warn((Object)"Got new config to update, but could not decode it. Staying with old one.", (Throwable)ex);
        }
    }

    @Override
    public void subscribe(Reconfigurable rec) {
        this.observers.add(rec);
    }

    @Override
    public void unsubscribe(Reconfigurable rec) {
        this.observers.remove(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers() {
        List<Reconfigurable> list = this.observers;
        synchronized (list) {
            for (Reconfigurable rec : this.observers) {
                this.getLogger().debug((Object)("Notifying Observer of new configuration: " + rec.getClass().getSimpleName()));
                rec.reconfigure(this.getConfig());
            }
        }
    }

    static class ConfigurationConnectionFactory
    extends CouchbaseConnectionFactory {
        ConfigurationConnectionFactory(List<URI> baseList, String bucketName, String password) throws IOException {
            super(baseList, bucketName, password);
        }

        @Override
        public NodeLocator createLocator(List<MemcachedNode> nodes) {
            return new ArrayModNodeLocator(nodes, this.getHashAlg());
        }
    }

    class HttpProviderRefresher
    implements Runnable {
        private final BucketConfigurationProvider provider;

        public HttpProviderRefresher(BucketConfigurationProvider provider) {
            this.provider = provider;
        }

        @Override
        public void run() {
            try {
                long reconnectAttempt = 0L;
                long backoffTime = 1000L;
                long maxWaitTime = 10000L;
                while (true) {
                    try {
                        long waitTime = reconnectAttempt++ * backoffTime;
                        if (reconnectAttempt >= 10L) {
                            waitTime = maxWaitTime;
                        }
                        BucketConfigurationProvider.this.getLogger().info((Object)("Reconnect attempt " + reconnectAttempt + ", waiting " + waitTime + "ms"));
                        Thread.sleep(waitTime);
                        ConfigurationProviderHTTP oldProvider = (ConfigurationProviderHTTP)BucketConfigurationProvider.this.httpProvider.get();
                        ConfigurationProviderHTTP newProvider = new ConfigurationProviderHTTP(BucketConfigurationProvider.this.seedNodes, BucketConfigurationProvider.this.bucket, BucketConfigurationProvider.this.password);
                        newProvider.subscribe(BucketConfigurationProvider.this.bucket, this.provider);
                        BucketConfigurationProvider.this.httpProvider.set(newProvider);
                        oldProvider.shutdown();
                        return;
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    break;
                }
            }
            finally {
                BucketConfigurationProvider.this.refreshingHttp.set(false);
            }
        }
    }
}

