/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.internal;

import com.couchbase.client.internal.HttpCompletionListener;
import com.couchbase.client.internal.HttpFuture;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.SpatialView;
import com.couchbase.client.protocol.views.SpatialViewRowWithDocs;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewResponseWithDocs;
import com.couchbase.client.protocol.views.ViewRow;
import com.couchbase.client.protocol.views.ViewRowWithDocs;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.internal.BulkFuture;
import net.spy.memcached.internal.GenericCompletionListener;
import net.spy.memcached.ops.OperationStatus;

public class ViewFuture
extends HttpFuture<ViewResponse> {
    private final AtomicReference<BulkFuture<Map<String, Object>>> multigetRef = new AtomicReference<Object>(null);
    private final AbstractView view;

    public ViewFuture(CountDownLatch latch, long timeout, AbstractView view, ExecutorService service) {
        super(latch, timeout, service);
        this.view = view;
    }

    @Override
    public ViewResponse get(long duration, TimeUnit units) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitForAndCheckOperation(duration, units);
        if (this.multigetRef.get() == null) {
            return null;
        }
        Map docMap = (Map)this.multigetRef.get().get();
        ViewResponseWithDocs viewResp = (ViewResponseWithDocs)this.objRef.get();
        LinkedList<ViewRow> rows = new LinkedList<ViewRow>();
        for (ViewRow r : viewResp) {
            if (this.view instanceof SpatialView) {
                rows.add(new SpatialViewRowWithDocs(r.getId(), r.getBbox(), r.getGeometry(), r.getValue(), docMap.get(r.getId())));
                continue;
            }
            rows.add(new ViewRowWithDocs(r.getId(), r.getKey(), r.getValue(), docMap.get(r.getId())));
        }
        return new ViewResponseWithDocs(rows, viewResp.getErrors(), viewResp.getTotalRows());
    }

    public void set(ViewResponse viewResponse, BulkFuture<Map<String, Object>> oper, OperationStatus s) {
        this.objRef.set(viewResponse);
        this.multigetRef.set(oper);
        this.status = s;
    }

    public ViewFuture addListener(HttpCompletionListener listener) {
        super.addToListeners((GenericCompletionListener)listener);
        return this;
    }

    public ViewFuture removeListener(HttpCompletionListener listener) {
        super.removeFromListeners((GenericCompletionListener)listener);
        return this;
    }
}

