/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client;

import com.couchbase.client.clustermanager.AuthType;
import com.couchbase.client.clustermanager.BucketType;
import com.couchbase.client.clustermanager.FlushResponse;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.compat.SpyObject;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.DefaultHttpClientIODispatch;
import org.apache.http.impl.nio.pool.BasicNIOConnPool;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.nio.NHttpClientEventHandler;
import org.apache.http.nio.protocol.BasicAsyncRequestProducer;
import org.apache.http.nio.protocol.BasicAsyncResponseConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncRequester;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.pool.ConnPool;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.util.EntityUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ClusterManager
extends SpyObject {
    public static final int DEFAULT_CONN_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(2L);
    public static final int DEFAULT_SOCKET_TIMEOUT = (int)TimeUnit.MINUTES.toMillis(2L);
    public static final boolean DEFAULT_TCP_NODELAY = true;
    public static final int DEFAULT_IO_THREADS = 1;
    public static final int DEFAULT_CONNS_PER_NODE = 5;
    private static final String BUCKETS = "/pools/default/buckets/";
    private final List<HttpHost> clusterNodes;
    private final ConnectingIOReactor ioReactor;
    private final BasicNIOConnPool pool;
    private final HttpAsyncRequester requester;
    private final String username;
    private final String password;
    private volatile Thread reactorThread;
    private volatile boolean running;

    public ClusterManager(List<URI> nodes, String username, String password) {
        this(nodes, username, password, DEFAULT_CONN_TIMEOUT, DEFAULT_SOCKET_TIMEOUT, true, 1, 5);
    }

    public ClusterManager(List<URI> nodes, String username, String password, int connectionTimeout, int socketTimeout, boolean tcpNoDelay, int ioThreadCount, int connectionsPerNode) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("List of nodes is null or empty");
        }
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username is null or empty");
        }
        if (password == null) {
            throw new IllegalArgumentException("Password is null");
        }
        this.username = username;
        this.password = password;
        this.clusterNodes = Collections.synchronizedList(new ArrayList());
        for (URI node : nodes) {
            this.clusterNodes.add(new HttpHost(node.getHost(), node.getPort()));
        }
        HttpProcessor httpProc = HttpProcessorBuilder.create().add((HttpRequestInterceptor)new RequestContent()).add((HttpRequestInterceptor)new RequestTargetHost()).add((HttpRequestInterceptor)new RequestConnControl()).add((HttpRequestInterceptor)new RequestUserAgent("JCBC/1.2")).add((HttpRequestInterceptor)new RequestExpectContinue(true)).build();
        this.requester = new HttpAsyncRequester(httpProc);
        try {
            this.ioReactor = new DefaultConnectingIOReactor(IOReactorConfig.custom().setConnectTimeout(connectionTimeout).setSoTimeout(socketTimeout).setTcpNoDelay(tcpNoDelay).setIoThreadCount(ioThreadCount).build());
        }
        catch (IOReactorException ex) {
            throw new IllegalStateException("Could not create IO reactor");
        }
        this.pool = new BasicNIOConnPool(this.ioReactor, ConnectionConfig.DEFAULT);
        this.pool.setDefaultMaxPerRoute(connectionsPerNode);
        this.initializeReactorThread();
    }

    public void createDefaultBucket(BucketType type, int memorySizeMB, int replicas, boolean flushEnabled) {
        this.createBucket(type, "default", memorySizeMB, AuthType.NONE, replicas, 11212, "", flushEnabled);
    }

    public void createNamedBucket(BucketType type, String name, int memorySizeMB, int replicas, String authPassword, boolean flushEnabled) {
        this.createBucket(type, name, memorySizeMB, AuthType.SASL, replicas, 11212, authPassword, flushEnabled);
    }

    public void createPortBucket(BucketType type, String name, int memorySizeMB, int replicas, int port, boolean flush) {
        this.createBucket(type, name, memorySizeMB, AuthType.NONE, replicas, port, "", flush);
    }

    public void deleteBucket(String name) {
        BasicHttpRequest request = new BasicHttpRequest("DELETE", BUCKETS + name);
        ClusterManager.checkForErrorCode(200, this.sendRequest((HttpRequest)request));
    }

    public List<String> listBuckets() {
        BasicHttpRequest request = new BasicHttpRequest("GET", BUCKETS);
        HttpResult result = this.sendRequest((HttpRequest)request);
        ClusterManager.checkForErrorCode(200, result);
        String json = result.getBody();
        ArrayList<String> names = new ArrayList<String>();
        if (json != null && !json.isEmpty()) {
            try {
                JSONArray base = new JSONArray(json);
                for (int i = 0; i < base.length(); ++i) {
                    JSONObject bucket = base.getJSONObject(i);
                    if (!bucket.has("name")) continue;
                    names.add(bucket.getString("name"));
                }
            }
            catch (JSONException e) {
                this.getLogger().error((Object)"Unable to interpret list buckets response.");
                throw new RuntimeException(e);
            }
        }
        return names;
    }

    public FlushResponse flushBucket(String name) {
        String url = BUCKETS + name + "/controller/doFlush";
        BasicHttpRequest request = new BasicHttpRequest("POST", url);
        HttpResult result = this.sendRequest((HttpRequest)request);
        if (result.getErrorCode() == 200) {
            return FlushResponse.OK;
        }
        if (result.getErrorCode() == 400) {
            return FlushResponse.NOT_ENABLED;
        }
        throw new RuntimeException("Http Error: " + result.getErrorCode() + " Reason: " + result.getErrorPhrase() + " Details: " + result.getReason());
    }

    public void updateBucket(String name, int memorySizeMB, AuthType authType, int replicas, int port, String authpassword, boolean flushEnabled) {
        List<String> buckets = this.listBuckets();
        if (!buckets.contains(name)) {
            throw new RuntimeException("Bucket with given name already does not exist");
        }
        HttpRequest request = this.prepareRequest(BUCKETS + name, null, name, memorySizeMB, authType, replicas, port, authpassword, flushEnabled);
        ClusterManager.checkForErrorCode(200, this.sendRequest(request));
    }

    private void createBucket(BucketType type, String name, int memorySizeMB, AuthType authType, int replicas, int port, String authpassword, boolean flushEnabled) {
        List<String> buckets = this.listBuckets();
        if (buckets.contains(name)) {
            throw new RuntimeException("Bucket with given name already exists");
        }
        HttpRequest request = this.prepareRequest(BUCKETS, type, name, memorySizeMB, authType, replicas, port, authpassword, flushEnabled);
        ClusterManager.checkForErrorCode(202, this.sendRequest(request));
    }

    private HttpRequest prepareRequest(String path, BucketType type, String name, int memorySizeMB, AuthType authType, int replicas, int port, String authpassword, boolean flushEnabled) {
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("POST", path);
        StringBuilder sb = new StringBuilder();
        sb.append("name=").append(name).append("&ramQuotaMB=").append(memorySizeMB).append("&authType=").append(authType.getAuthType()).append("&replicaNumber=").append(replicas).append("&proxyPort=").append(port);
        if (type != null) {
            sb.append("&bucketType=").append(type.getBucketType());
        }
        if (authType == AuthType.SASL) {
            sb.append("&saslPassword=").append(authpassword);
        }
        if (flushEnabled) {
            sb.append("&flushEnabled=1");
        }
        try {
            request.setEntity((HttpEntity)new StringEntity(sb.toString()));
            return request;
        }
        catch (UnsupportedEncodingException e) {
            this.getLogger().error((Object)"Error creating request. Bad arguments");
            throw new RuntimeException(e);
        }
    }

    private HttpResult sendRequest(HttpRequest request) {
        if (!this.running) {
            throw new IllegalStateException("Not connected to one of the nodes.");
        }
        HttpCoreContext coreContext = HttpCoreContext.create();
        request.addHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.username + ':' + this.password).getBytes()));
        request.addHeader("Accept", "*/*");
        request.addHeader("Content-Type", "application/x-www-form-urlencoded");
        for (HttpHost node : this.clusterNodes) {
            try {
                final CountDownLatch latch = new CountDownLatch(1);
                final AtomicBoolean success = new AtomicBoolean(false);
                final AtomicReference response = new AtomicReference();
                this.requester.execute((HttpAsyncRequestProducer)new BasicAsyncRequestProducer(node, request), (HttpAsyncResponseConsumer)new BasicAsyncResponseConsumer(), (ConnPool)this.pool, (HttpContext)coreContext, (FutureCallback)new FutureCallback<HttpResponse>(){

                    public void completed(HttpResponse result) {
                        success.set(true);
                        response.set(result);
                        latch.countDown();
                    }

                    public void failed(Exception ex) {
                        ClusterManager.this.getLogger().warn((Object)"Cluster Response failed with: ", (Throwable)ex);
                        latch.countDown();
                    }

                    public void cancelled() {
                        ClusterManager.this.getLogger().warn((Object)"Cluster Response was cancelled.");
                        latch.countDown();
                    }
                });
                latch.await();
                if (!success.get()) {
                    this.getLogger().info((Object)"Could not finish request execution");
                    continue;
                }
                int code = ((HttpResponse)response.get()).getStatusLine().getStatusCode();
                String body = EntityUtils.toString((HttpEntity)((HttpResponse)response.get()).getEntity());
                String reason = ClusterManager.parseError(body);
                String phrase = ((HttpResponse)response.get()).getStatusLine().getReasonPhrase();
                return new HttpResult(body, code, phrase, reason);
            }
            catch (InterruptedException ex) {
                this.getLogger().debug((Object)"Got interrupted while waiting for the response.");
            }
            catch (IOException e) {
                this.getLogger().debug((Object)("Unable to connect to: " + node + ". Trying another server"));
            }
        }
        throw new RuntimeException("Unable to connect to cluster");
    }

    private static String parseError(String json) {
        if (json != null && !json.isEmpty()) {
            try {
                JSONObject base = new JSONObject(json);
                if (base.has("errors")) {
                    return base.getJSONObject("errors").toString();
                }
            }
            catch (JSONException e) {
                return "Client error parsing error response";
            }
        }
        return "No reason given";
    }

    private static void checkForErrorCode(int expectedCode, HttpResult result) {
        if (result.getErrorCode() != expectedCode) {
            throw new RuntimeException("Http Error: " + result.getErrorCode() + " Reason: " + result.getErrorPhrase() + " Details: " + result.getReason());
        }
    }

    public boolean shutdown() {
        if (!this.running) {
            this.getLogger().info((Object)"Suppressing duplicate attempt to shut down");
            return false;
        }
        this.running = false;
        try {
            this.ioReactor.shutdown();
        }
        catch (IOException e) {
            this.getLogger().info((Object)"Got exception while shutting down", (Throwable)e);
        }
        try {
            this.reactorThread.join(0L);
        }
        catch (InterruptedException ex) {
            this.getLogger().error((Object)("Interrupt " + ex + " received while waiting for " + "view thread to shut down."));
        }
        return true;
    }

    private void initializeReactorThread() {
        DefaultHttpClientIODispatch ioEventDispatch = new DefaultHttpClientIODispatch((NHttpClientEventHandler)new HttpAsyncRequestExecutor(), ConnectionConfig.DEFAULT);
        this.reactorThread = new Thread(new Runnable((IOEventDispatch)ioEventDispatch){
            final /* synthetic */ IOEventDispatch val$ioEventDispatch;
            {
                this.val$ioEventDispatch = iOEventDispatch;
            }

            @Override
            public void run() {
                try {
                    ClusterManager.this.ioReactor.execute(this.val$ioEventDispatch);
                }
                catch (InterruptedIOException ex) {
                    ClusterManager.this.getLogger().error((Object)"I/O reactor Interrupted", (Throwable)ex);
                }
                catch (IOException e) {
                    ClusterManager.this.getLogger().error((Object)("I/O error: " + e.getMessage()), (Throwable)e);
                }
                ClusterManager.this.getLogger().debug((Object)"I/O reactor terminated");
            }
        }, "Couchbase ClusterManager Thread");
        this.reactorThread.start();
        this.running = true;
    }

    public static final class HttpResult {
        private final String body;
        private final int errorCode;
        private final String errorPhrase;
        private final String errorReason;

        public HttpResult(String entity, int code, String phrase, String reason) {
            this.body = entity;
            this.errorCode = code;
            this.errorPhrase = phrase;
            this.errorReason = reason;
        }

        public String getBody() {
            return this.body;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public String getErrorPhrase() {
            return this.errorPhrase;
        }

        public String getReason() {
            return this.errorReason;
        }
    }
}

