/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.vbucket.provider;

import com.couchbase.client.CouchbaseConnection;
import com.couchbase.client.CouchbaseConnectionFactory;
import com.couchbase.client.CouchbaseProperties;
import com.couchbase.client.vbucket.ConfigurationException;
import com.couchbase.client.vbucket.ConfigurationProviderHTTP;
import com.couchbase.client.vbucket.CouchbaseNodeOrder;
import com.couchbase.client.vbucket.Reconfigurable;
import com.couchbase.client.vbucket.config.Bucket;
import com.couchbase.client.vbucket.config.Config;
import com.couchbase.client.vbucket.config.ConfigurationParser;
import com.couchbase.client.vbucket.config.ConfigurationParserJSON;
import com.couchbase.client.vbucket.provider.ConfigurationProvider;
import com.couchbase.client.vbucket.provider.CouchbaseConfigConnection;
import com.couchbase.client.vbucket.provider.GetConfigOperationImpl;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.ArrayModNodeLocator;
import net.spy.memcached.BroadcastOpFactory;
import net.spy.memcached.ConnectionObserver;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.auth.AuthThreadMonitor;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;

public class BucketConfigurationProvider
extends SpyObject
implements ConfigurationProvider,
Reconfigurable {
    private static final int DEFAULT_BINARY_PORT = 11210;
    private static final String ANONYMOUS_BUCKET = "default";
    private final AtomicReference<Bucket> config = new AtomicReference();
    private final List<URI> seedNodes;
    private final List<Reconfigurable> observers;
    private final String bucket;
    private final String password;
    private final CouchbaseConnectionFactory connectionFactory;
    private final ConfigurationParser configurationParser = new ConfigurationParserJSON();
    private final AtomicReference<ConfigurationProviderHTTP> httpProvider;
    private final AtomicBoolean refreshingHttp;
    private final AtomicBoolean pollingBinary;
    private final AtomicReference<CouchbaseConnection> binaryConnection;
    private final boolean disableCarrierBootstrap;
    private final boolean disableHttpBootstrap;
    private volatile boolean isBinary;
    private volatile long lastRevision;
    private volatile boolean shutdown;

    public BucketConfigurationProvider(List<URI> seedNodes, String bucket, String password, CouchbaseConnectionFactory connectionFactory) {
        this.httpProvider = new AtomicReference<ConfigurationProviderHTTP>(new ConfigurationProviderHTTP(seedNodes, bucket, password));
        this.refreshingHttp = new AtomicBoolean(false);
        this.pollingBinary = new AtomicBoolean(false);
        this.observers = Collections.synchronizedList(new ArrayList());
        this.binaryConnection = new AtomicReference();
        this.seedNodes = Collections.synchronizedList(new ArrayList<URI>(seedNodes));
        this.bucket = bucket;
        this.password = password;
        this.connectionFactory = connectionFactory;
        this.potentiallyRandomizeNodeList(seedNodes);
        this.disableCarrierBootstrap = Boolean.parseBoolean(CouchbaseProperties.getProperty("disableCarrierBootstrap", "false"));
        this.disableHttpBootstrap = Boolean.parseBoolean(CouchbaseProperties.getProperty("disableHttpBootstrap", "false"));
        this.shutdown = false;
    }

    @Override
    public Bucket bootstrap() {
        if (this.shutdown) {
            this.getLogger().debug((Object)"Omitting bootstrap since already shutdown.");
        }
        this.isBinary = false;
        if (!this.bootstrapBinary() && !this.bootstrapHttp()) {
            throw new ConfigurationException("Could not fetch a valid Bucket configuration.");
        }
        if (this.isBinary) {
            this.getLogger().info((Object)"Could bootstrap through carrier publication.");
        } else {
            this.getLogger().info((Object)"Carrier config not available, bootstrapped through HTTP.");
        }
        return this.config.get();
    }

    boolean bootstrapBinary() {
        if (this.disableCarrierBootstrap) {
            this.getLogger().info((Object)"Carrier bootstrap manually disabled, skipping.");
            return false;
        }
        this.isBinary = true;
        ArrayList<InetSocketAddress> nodes = new ArrayList<InetSocketAddress>(this.seedNodes.size());
        for (URI seedNode : this.seedNodes) {
            nodes.add(new InetSocketAddress(seedNode.getHost(), 11210));
        }
        try {
            for (InetSocketAddress node : nodes) {
                if (!this.tryBinaryBootstrapForNode(node)) continue;
                return true;
            }
            this.getLogger().debug((Object)"Not a single node returned a carrier publication config.");
            this.isBinary = false;
            return false;
        }
        catch (Exception ex) {
            this.getLogger().info((Object)"Could not fetch config from carrier publication seed nodes.", (Throwable)ex);
            this.isBinary = false;
            return false;
        }
    }

    private boolean tryBinaryBootstrapForNode(InetSocketAddress node) throws Exception {
        List<String> configs;
        if (this.binaryConnection.get() != null) {
            return true;
        }
        ConfigurationConnectionFactory fact = new ConfigurationConnectionFactory(this.seedNodes, this.bucket, this.password);
        CouchbaseConnectionFactory cf = this.connectionFactory;
        CouchbaseConfigConnection connection = null;
        ArrayList<ConnectionObserver> initialObservers = new ArrayList<ConnectionObserver>();
        final CountDownLatch latch = new CountDownLatch(1);
        initialObservers.add(new ConnectionObserver(){

            public void connectionEstablished(SocketAddress socketAddress, int i) {
                latch.countDown();
            }

            public void connectionLost(SocketAddress socketAddress) {
            }
        });
        try {
            connection = new CouchbaseConfigConnection(cf.getReadBufSize(), fact, Collections.singletonList(node), initialObservers, cf.getFailureMode(), cf.getOperationFactory());
            boolean result = latch.await(5L, TimeUnit.SECONDS);
            if (!result) {
                throw new IOException("Connection could not be established to carrier port in the given time interval.");
            }
        }
        catch (Exception ex) {
            if (connection != null) {
                connection.shutdown();
            }
            this.getLogger().debug((Object)("(Carrier Publication) Could not load config from " + node.getHostName() + ", trying next node."), (Throwable)ex);
            return false;
        }
        if (!this.bucket.equals(ANONYMOUS_BUCKET)) {
            AuthThreadMonitor monitor = new AuthThreadMonitor();
            ArrayList connectedNodes = new ArrayList(connection.getLocator().getAll());
            for (MemcachedNode connectedNode : connectedNodes) {
                if (!connectedNode.getSocketAddress().equals(node)) continue;
                monitor.authConnection((MemcachedConnection)connection, cf.getOperationFactory(), cf.getAuthDescriptor(), connectedNode);
            }
        }
        if ((configs = this.getConfigsFromBinaryConnection(connection)).isEmpty()) {
            this.getLogger().debug((Object)("(Carrier Publication) Could not load config from " + node.getHostName() + ", trying next node."));
            connection.shutdown();
            return false;
        }
        String appliedConfig = connection.replaceConfigWildcards(configs.get(0));
        try {
            Bucket config = this.configurationParser.parseBucket(appliedConfig);
            this.setConfig(config);
        }
        catch (Exception ex) {
            this.getLogger().warn((Object)"Could not parse config, retrying bootstrap.", (Throwable)ex);
            connection.shutdown();
            return false;
        }
        connection.addObserver(new ConnectionObserver(){

            public void connectionEstablished(SocketAddress sa, int reconnectCount) {
                BucketConfigurationProvider.this.getLogger().debug((Object)("Carrier Config Connection established to " + sa));
            }

            public void connectionLost(SocketAddress sa) {
                BucketConfigurationProvider.this.getLogger().debug((Object)("Carrier Config Connection lost from " + sa));
                CouchbaseConnection conn = BucketConfigurationProvider.this.binaryConnection.getAndSet(null);
                try {
                    conn.shutdown();
                }
                catch (IOException e) {
                    BucketConfigurationProvider.this.getLogger().debug((Object)"Could not shut down Carrier Config Connection", (Throwable)e);
                }
                BucketConfigurationProvider.this.signalOutdated();
            }
        });
        CouchbaseConnection old = this.binaryConnection.get();
        if (old != null) {
            old.shutdown();
        }
        this.binaryConnection.set(connection);
        return true;
    }

    private List<String> getConfigsFromBinaryConnection(CouchbaseConnection connection) throws Exception {
        final List<String> configs = Collections.synchronizedList(new ArrayList());
        CountDownLatch blatch = connection.broadcastOperation(new BroadcastOpFactory(){

            public Operation newOp(MemcachedNode n, final CountDownLatch latch) {
                return new GetConfigOperationImpl(new OperationCallback(){

                    public void receivedStatus(OperationStatus status) {
                        if (status.isSuccess()) {
                            configs.add(status.getMessage());
                        }
                    }

                    public void complete() {
                        latch.countDown();
                    }
                });
            }
        });
        blatch.await(this.connectionFactory.getOperationTimeout(), TimeUnit.MILLISECONDS);
        return configs;
    }

    boolean bootstrapHttp() {
        if (this.disableHttpBootstrap) {
            this.getLogger().info((Object)"Http bootstrap manually disabled, skipping.");
            return false;
        }
        try {
            Bucket config = this.httpProvider.get().getBucketConfiguration(this.bucket);
            this.setConfig(config);
            this.monitorBucket();
            this.isBinary = false;
            return true;
        }
        catch (Exception ex) {
            this.getLogger().info((Object)"Could not fetch config from http seed nodes.", (Throwable)ex);
            return false;
        }
    }

    private void monitorBucket() {
        if (!this.shutdown && !this.isBinary) {
            this.httpProvider.get().subscribe(this.bucket, this);
        }
    }

    @Override
    public void reconfigure(Bucket bucket) {
        this.setConfig(bucket);
    }

    @Override
    public Bucket getConfig() {
        if (this.config.get() == null) {
            this.bootstrap();
        }
        return this.config.get();
    }

    @Override
    public void setConfig(Bucket config) {
        if (config.isNotUpdating()) {
            this.signalOutdated();
            return;
        }
        long configRevision = config.getRevision();
        if (configRevision > 0L) {
            if (configRevision > this.lastRevision) {
                this.lastRevision = configRevision;
            } else {
                return;
            }
        }
        this.getLogger().debug((Object)("Applying new bucket config for bucket \"" + this.bucket + "\" (carrier publication: " + this.isBinary + "): " + config));
        this.config.set(config);
        this.httpProvider.get().updateBucket(config.getName(), config);
        this.updateSeedNodes();
        this.notifyObservers();
        this.manageTaintedConfig(config.getConfig());
    }

    private void manageTaintedConfig(Config config) {
        if (!this.isBinary) {
            return;
        }
        if (config.isTainted() && this.pollingBinary.compareAndSet(false, true)) {
            this.getLogger().debug((Object)"Found tainted configuration, starting carrier poller.");
            Thread thread = new Thread(new BinaryConfigPoller());
            thread.setName("couchbase - carrier config poller");
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSeedNodes() {
        Config config = this.config.get().getConfig();
        List<String> clusterNodes = config.getRestEndpoints();
        if (!clusterNodes.isEmpty()) {
            ArrayList<URI> newNodes = new ArrayList<URI>();
            for (String clusterNode : clusterNodes) {
                try {
                    newNodes.add(new URI(clusterNode));
                }
                catch (URISyntaxException ex) {
                    this.getLogger().warn((Object)"Could not add node to updated bucket list because of a parsing exception.");
                    this.getLogger().debug((Object)("Could not parse list because: " + ex));
                }
            }
            if (BucketConfigurationProvider.seedNodesAreDifferent(this.seedNodes, newNodes)) {
                this.potentiallyRandomizeNodeList(newNodes);
                List<URI> list = this.seedNodes;
                synchronized (list) {
                    this.seedNodes.clear();
                    this.seedNodes.addAll(newNodes);
                }
                this.httpProvider.get().updateBaseListFromConfig(this.seedNodes);
            }
        }
    }

    private void potentiallyRandomizeNodeList(List<URI> list) {
        if (this.connectionFactory.getStreamingNodeOrder() == CouchbaseNodeOrder.ORDERED) {
            return;
        }
        Collections.shuffle(list);
    }

    private static boolean seedNodesAreDifferent(List<URI> left, List<URI> right) {
        if (left.size() != right.size()) {
            return true;
        }
        for (URI uri : left) {
            if (right.contains(uri)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void signalOutdated() {
        if (this.shutdown) {
            this.getLogger().debug((Object)"Omitting signalOutdated since already shutdown.");
            return;
        }
        if (this.isBinary) {
            if (this.binaryConnection.get() == null) {
                this.bootstrap();
            } else {
                try {
                    List<String> configs = this.getConfigsFromBinaryConnection(this.binaryConnection.get());
                    if (configs.isEmpty()) {
                        this.bootstrap();
                        return;
                    }
                    String appliedConfig = this.binaryConnection.get().replaceConfigWildcards(configs.get(0));
                    Bucket config = this.configurationParser.parseBucket(appliedConfig);
                    this.setConfig(config);
                }
                catch (Exception ex) {
                    this.getLogger().info((Object)"Could not load config from existing connection, rerunning bootstrap.", (Throwable)ex);
                    this.bootstrap();
                }
            }
        } else if (this.refreshingHttp.compareAndSet(false, true)) {
            Thread refresherThread = new Thread(new HttpProviderRefresher());
            refresherThread.setName("HttpConfigurationProvider Reloader");
            refresherThread.start();
        } else {
            this.getLogger().debug((Object)"Suppressing duplicate refreshing attempt.");
        }
    }

    @Override
    public void reloadConfig() {
        if (this.isBinary && !this.shutdown) {
            this.signalOutdated();
        }
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        if (this.httpProvider.get() != null) {
            this.httpProvider.get().shutdown();
        }
        if (this.binaryConnection.get() != null) {
            try {
                this.binaryConnection.get().shutdown();
            }
            catch (IOException e) {
                this.getLogger().warn((Object)"Could not shutdown carrier publication config connection.", (Throwable)e);
            }
        }
    }

    @Override
    public String getAnonymousAuthBucket() {
        return ANONYMOUS_BUCKET;
    }

    @Override
    public void setConfig(String config) {
        try {
            this.setConfig(this.configurationParser.parseBucket(config));
        }
        catch (Exception ex) {
            this.getLogger().warn((Object)"Got new config to update, but could not decode it. Staying with old one.", (Throwable)ex);
        }
    }

    @Override
    public void subscribe(Reconfigurable rec) {
        this.observers.add(rec);
    }

    @Override
    public void unsubscribe(Reconfigurable rec) {
        this.observers.remove(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObservers() {
        List<Reconfigurable> list = this.observers;
        synchronized (list) {
            for (Reconfigurable rec : this.observers) {
                this.getLogger().debug((Object)("Notifying Observer of new configuration: " + rec.getClass().getSimpleName()));
                rec.reconfigure(this.getConfig());
            }
        }
    }

    static class ConfigurationConnectionFactory
    extends CouchbaseConnectionFactory {
        ConfigurationConnectionFactory(List<URI> baseList, String bucketName, String password) throws IOException {
            super(baseList, bucketName, password);
        }

        @Override
        public NodeLocator createLocator(List<MemcachedNode> nodes) {
            return new ArrayModNodeLocator(nodes, this.getHashAlg());
        }
    }

    class BinaryConfigPoller
    implements Runnable {
        private static final int waitPeriod = 1000;
        private int attempt;

        BinaryConfigPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (BucketConfigurationProvider.this.isBinary && BucketConfigurationProvider.this.getConfig().getConfig().isTainted()) {
                    BucketConfigurationProvider.this.getLogger().debug((Object)("Polling for new carrier configuration and waiting 1000ms (Attempt " + ++this.attempt + ")."));
                    BucketConfigurationProvider.this.signalOutdated();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        BucketConfigurationProvider.this.getLogger().warn((Object)"Got interrupted while trying to poll for new carrier config.", (Throwable)e);
                        break;
                    }
                }
            }
            finally {
                BucketConfigurationProvider.this.getLogger().debug((Object)"Finished polling for new carrier configuration.");
                BucketConfigurationProvider.this.pollingBinary.set(false);
            }
        }
    }

    class HttpProviderRefresher
    implements Runnable {
        HttpProviderRefresher() {
        }

        @Override
        public void run() {
            try {
                long reconnectAttempt = 0L;
                long backoffTime = 1000L;
                long maxWaitTime = 10000L;
                while (true) {
                    try {
                        long waitTime = reconnectAttempt++ * backoffTime;
                        if (reconnectAttempt >= 10L) {
                            waitTime = maxWaitTime;
                        }
                        BucketConfigurationProvider.this.getLogger().info((Object)("Reconnect attempt " + reconnectAttempt + ", waiting " + waitTime + "ms"));
                        Thread.sleep(waitTime);
                        ConfigurationProviderHTTP oldProvider = (ConfigurationProviderHTTP)BucketConfigurationProvider.this.httpProvider.get();
                        ConfigurationProviderHTTP newProvider = new ConfigurationProviderHTTP(BucketConfigurationProvider.this.seedNodes, BucketConfigurationProvider.this.bucket, BucketConfigurationProvider.this.password);
                        BucketConfigurationProvider.this.httpProvider.set(newProvider);
                        BucketConfigurationProvider.this.monitorBucket();
                        oldProvider.shutdown();
                        return;
                    }
                    catch (Exception ex) {
                        BucketConfigurationProvider.this.getLogger().debug((Object)"Got exception while trying to reconnect the configuration provider.", (Throwable)ex);
                        continue;
                    }
                    break;
                }
            }
            finally {
                BucketConfigurationProvider.this.refreshingHttp.set(false);
            }
        }
    }
}

