/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.CouchbaseBucketConfigParser;
import com.couchbase.client.dcp.core.config.MemcachedBucketConfigParser;
import com.couchbase.client.dcp.core.config.MemcachedHashingStrategy;
import com.couchbase.client.dcp.core.config.NodeInfo;
import java.util.List;
import java.util.Set;
import reactor.util.annotation.Nullable;

public interface BucketConfig {
    public String uuid();

    public String name();

    public Set<BucketCapability> capabilities();

    default public boolean hasCapability(BucketCapability capability) {
        return this.capabilities().contains((Object)capability);
    }

    @Stability.Internal
    @Nullable
    public static BucketConfig parse(ObjectNode json, List<NodeInfo> nodes, MemcachedHashingStrategy memcachedHashingStrategy) {
        switch (json.path("nodeLocator").asText()) {
            case "vbucket": {
                return CouchbaseBucketConfigParser.parse(json, nodes);
            }
            case "ketama": {
                return MemcachedBucketConfigParser.parse(json, nodes, memcachedHashingStrategy);
            }
        }
        return null;
    }
}

