/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.AbstractBucketConfig;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PartitionMap;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class CouchbaseBucketConfig
extends AbstractBucketConfig {
    static final int PARTITION_NOT_EXISTENT = -2;
    private final boolean ephemeral;
    private final int replicas;
    private final PartitionMap partitions;
    private final Optional<PartitionMap> partitionsForward;
    private final Set<String> primaryPartitionHosts;

    public CouchbaseBucketConfig(String name, String uuid, Set<BucketCapability> capabilities, boolean ephemeral, int replicas, PartitionMap partitions, @Nullable PartitionMap partitionsForward) {
        super(name, uuid, capabilities);
        this.replicas = replicas;
        this.partitions = Objects.requireNonNull(partitions);
        this.partitionsForward = Optional.ofNullable(partitionsForward);
        this.ephemeral = ephemeral;
        this.primaryPartitionHosts = Collections.unmodifiableSet(partitions.values().stream().map(it -> it.active().map(NodeInfo::host).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public boolean ephemeral() {
        return this.ephemeral;
    }

    public int numberOfPartitions() {
        return this.partitions.size();
    }

    public int numberOfReplicas() {
        return this.replicas;
    }

    public PartitionMap partitions() {
        return this.partitions;
    }

    public Optional<PartitionMap> partitionsForward() {
        return this.partitionsForward;
    }

    private PartitionMap partitions(boolean forward) {
        return forward ? this.partitionsForward().orElseThrow(() -> new IllegalStateException("Config has no forward partition map.")) : this.partitions();
    }

    @Deprecated
    public boolean hasPrimaryPartitionsOnNode(String hostname) {
        return this.primaryPartitionHosts.contains(hostname);
    }

    @Deprecated
    public int nodeIndexForActive(int partition, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForActive().orElse(-2);
    }

    @Deprecated
    public int nodeIndexForReplica(int partition, int replica, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForReplica(replica).orElse(-2);
    }

    public String toString() {
        return "CouchbaseBucketConfig{name='" + this.name() + '\'' + ", uuid='" + this.uuid() + '\'' + ", ephemeral=" + this.ephemeral + ", capabilities=" + this.capabilities() + ", replicas=" + this.replicas + ", partitions=" + this.partitions + ", partitionsForward=" + this.partitionsForward + '}';
    }
}

