/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.core.config.AbstractBucketConfig;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.KetamaRing;
import com.couchbase.client.dcp.core.config.MemcachedBucketConfig;
import com.couchbase.client.dcp.core.config.MemcachedHashingStrategy;
import com.couchbase.client.dcp.core.config.NodeInfo;
import java.util.List;
import java.util.Set;

public class MemcachedBucketConfigParser {
    public static MemcachedBucketConfig parse(ObjectNode configNode, List<NodeInfo> nodes, MemcachedHashingStrategy hashingStrategy) {
        Set<BucketCapability> bucketCapabilities = AbstractBucketConfig.parseBucketCapabilities(configNode);
        List kvNodes = CbCollections.filter(nodes, it -> it.has(ServiceType.KV));
        KetamaRing<NodeInfo> ketamaRing = KetamaRing.create(kvNodes, hashingStrategy);
        return new MemcachedBucketConfig(configNode.path("name").asText(), configNode.path("uuid").asText(), bucketCapabilities, ketamaRing);
    }
}

