/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.core.config.NodeIdentifier;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import reactor.util.annotation.Nullable;

public class NodeInfo {
    public static final NodeInfo INACCESSIBLE = new NodeInfo("<inaccessible>", Collections.emptyMap(), null);
    private final String host;
    private final Map<ServiceType, Integer> ports;
    @Nullable
    private final HostAndPort ketamaAuthority;

    public NodeInfo(String host, Map<ServiceType, Integer> ports, @Nullable HostAndPort ketamaAuthority) {
        this.host = Objects.requireNonNull(host);
        this.ports = Collections.unmodifiableMap(CbCollections.newEnumMap(ServiceType.class, ports));
        this.ketamaAuthority = ketamaAuthority;
    }

    public boolean inaccessible() {
        return this == INACCESSIBLE;
    }

    public NodeIdentifier id() {
        return new NodeIdentifier(this.host, this.port(ServiceType.MANAGER).orElse(0));
    }

    public String host() {
        return this.host;
    }

    @Nullable
    public HostAndPort ketamaAuthority() {
        return this.ketamaAuthority;
    }

    public OptionalInt port(ServiceType serviceType) {
        Integer port = this.ports.get(serviceType);
        return port == null ? OptionalInt.empty() : OptionalInt.of(port);
    }

    public Map<ServiceType, Integer> ports() {
        return this.ports;
    }

    public boolean has(ServiceType serviceType) {
        return this.ports.containsKey(serviceType);
    }

    public boolean matches(SeedNode seedNode) {
        return this.host.equals(seedNode.address()) && (this.portEquals(ServiceType.KV, seedNode.kvPort().orElse(0)) || this.portEquals(ServiceType.MANAGER, seedNode.clusterManagerPort().orElse(0)));
    }

    private boolean portEquals(ServiceType serviceType, int port) {
        int actualPort = this.port(serviceType).orElse(0);
        return actualPort != 0 && actualPort == port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeInfo that = (NodeInfo)o;
        return this.host.equals(that.host) && this.ports.equals(that.ports);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ports);
    }

    public String toString() {
        return "NodeConfig{host='" + RedactableArgument.redactSystem(this.host) + '\'' + ", serviceToPort=" + RedactableArgument.redactSystem(this.ports) + ", ketamaAuthority=" + RedactableArgument.redactSystem(this.ketamaAuthority) + '}';
    }

    @Deprecated
    public String hostname() {
        return this.host();
    }

    @Deprecated
    public Map<ServiceType, Integer> services() {
        return this.ports();
    }

    @Deprecated
    public Map<ServiceType, Integer> sslServices() {
        return this.ports();
    }
}

