/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PartitionInfo;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class PartitionMap {
    static final PartitionMap ABSENT = new PartitionMap(Collections.emptyList());
    private final List<PartitionInfo> values;

    public PartitionMap(List<PartitionInfo> values) {
        this.values = CbCollections.copyToUnmodifiableList(values);
    }

    public PartitionInfo get(int partition) {
        try {
            return this.values.get(partition);
        }
        catch (IndexOutOfBoundsException e) {
            return PartitionInfo.ABSENT;
        }
    }

    public List<PartitionInfo> values() {
        return this.values;
    }

    public int size() {
        return this.values.size();
    }

    public void forEach(BiConsumer<Integer, PartitionInfo> action) {
        int i = 0;
        for (PartitionInfo entry : this.values) {
            action.accept(i++, entry);
        }
    }

    public Optional<NodeInfo> active(int partition) {
        return this.get(partition).active();
    }

    public List<NodeInfo> availableReplicas(int partition) {
        return this.get(partition).availableReplicas();
    }

    public String toString() {
        TreeMap map = new TreeMap();
        this.forEach(map::put);
        return ((Object)map).toString();
    }
}

