/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.service.ServiceType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public enum PortSelector {
    TLS(ServiceIndexes.access$000()),
    NON_TLS(ServiceIndexes.access$100());

    private final Map<String, ServiceType> serviceIndex;

    private PortSelector(Map<String, ServiceType> serviceIndex) {
        this.serviceIndex = Objects.requireNonNull(serviceIndex);
    }

    public Map<ServiceType, Integer> selectPorts(Map<String, Integer> serviceNameToPort) {
        EnumMap result = new EnumMap(ServiceType.class);
        serviceNameToPort.forEach((serviceName, port) -> this.getServiceForName((String)serviceName).ifPresent(it -> result.put((ServiceType)it, port)));
        return Collections.unmodifiableMap(result);
    }

    private Optional<ServiceType> getServiceForName(String serviceName) {
        return Optional.ofNullable(this.serviceIndex.get(serviceName));
    }

    private static class ServiceIndexes {
        private static final Map<String, ServiceType> tlsServiceIndex = new HashMap<String, ServiceType>();
        private static final Map<String, ServiceType> nonTlsServiceIndex = new HashMap<String, ServiceType>();

        private ServiceIndexes() {
        }

        private static void registerService(ServiceType service, String nonTlsServiceName, String tlsServiceName) {
            tlsServiceIndex.put(tlsServiceName, service);
            nonTlsServiceIndex.put(nonTlsServiceName, service);
        }

        static /* synthetic */ Map access$000() {
            return tlsServiceIndex;
        }

        static /* synthetic */ Map access$100() {
            return nonTlsServiceIndex;
        }

        static {
            ServiceIndexes.registerService(ServiceType.MANAGER, "mgmt", "mgmtSSL");
            ServiceIndexes.registerService(ServiceType.KV, "kv", "kvSSL");
            ServiceIndexes.registerService(ServiceType.VIEWS, "capi", "capiSSL");
            ServiceIndexes.registerService(ServiceType.QUERY, "n1ql", "n1qlSSL");
            ServiceIndexes.registerService(ServiceType.SEARCH, "fts", "ftsSSL");
            ServiceIndexes.registerService(ServiceType.ANALYTICS, "cbas", "cbasSSL");
            ServiceIndexes.registerService(ServiceType.EVENTING, "eventingAdminPort", "eventingSSL");
            ServiceIndexes.registerService(ServiceType.BACKUP, "backupAPI", "backupAPIHTTPS");
            HashSet<ServiceType> unregistered = new HashSet<ServiceType>(Arrays.asList(ServiceType.values()));
            unregistered.removeAll(tlsServiceIndex.values());
            if (!unregistered.isEmpty()) {
                throw new AssertionError((Object)("Missing registration for service type(s): " + unregistered));
            }
        }
    }
}

