/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.core.CouchbaseException;
import com.couchbase.client.dcp.core.config.MemcachedHashingStrategy;
import com.couchbase.client.dcp.core.config.NodeInfo;

public class StandardMemcachedHashingStrategy
implements MemcachedHashingStrategy {
    public static final StandardMemcachedHashingStrategy INSTANCE = new StandardMemcachedHashingStrategy();

    private StandardMemcachedHashingStrategy() {
    }

    @Override
    public String hash(NodeInfo node, int repetition) {
        HostAndPort authority = node.ketamaAuthority();
        if (authority == null) {
            throw new CouchbaseException("Oh no! Can't talk to this memcached bucket because the server did not advertise non-TLS KV ports for the default network. Non-TLS KV ports are required for building the ketama ring that determines where documents are located in the cluster, even when the connection is secured by TLS.");
        }
        return authority.host() + ":" + authority.port() + "-" + repetition;
    }
}

