/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.dcp.metrics.LogLevel;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionTimer {
    private final String name;
    private final Clock clock;
    private final Timer successTimer;
    private final MeterRegistry registry;
    private final List<Tag> baseTags;
    private final LogLevel successLogLevel;
    private final LogLevel failureLogLevel;
    private final Logger logger;

    public static Builder builder(MeterRegistry registry, String name) {
        return new Builder(registry, name);
    }

    private ActionTimer(MeterRegistry registry, String name, Iterable<Tag> tags, Clock clock, LogLevel successLogLevel, LogLevel failureLogLevel) {
        this.registry = Objects.requireNonNull(registry);
        this.name = Objects.requireNonNull(name);
        this.clock = Objects.requireNonNull(clock);
        this.successLogLevel = Objects.requireNonNull(successLogLevel);
        this.failureLogLevel = Objects.requireNonNull(failureLogLevel);
        this.logger = LoggerFactory.getLogger((String)(ActionTimer.class.getName() + "." + name));
        ArrayList tagList = new ArrayList();
        tags.forEach(tagList::add);
        this.baseTags = Collections.unmodifiableList(tagList);
        ArrayList<Tag> successTags = new ArrayList<Tag>(this.baseTags);
        successTags.add(Tag.of((String)"result", (String)"success"));
        successTags.add(Tag.of((String)"exception", (String)"none"));
        this.successTimer = registry.timer(name, successTags);
    }

    public void track(Future<?> f) {
        long start = this.clock.monotonicTime();
        f.addListener(future -> {
            long elapsed = this.clock.monotonicTime() - start;
            if (f.isSuccess()) {
                this.success(elapsed, TimeUnit.NANOSECONDS);
            } else {
                this.failure(elapsed, TimeUnit.NANOSECONDS, f.cause());
            }
        });
    }

    public void success(long elapsed, TimeUnit unit) {
        this.successLogLevel.log(this.logger, "success {}", (Object)this.baseTags);
        this.successTimer.record(elapsed, unit);
    }

    public void failure(long elapsed, TimeUnit unit, Throwable reason) {
        this.failureLogLevel.log(this.logger, "failure {}", (Object)this.baseTags, (Object)reason);
        String reasonName = reason == null ? "unknown" : reason.getClass().getSimpleName();
        this.failure(elapsed, unit, reasonName);
    }

    public void failure(long elapsed, TimeUnit unit, String exception) {
        Timer.builder((String)this.name).tags(this.baseTags).tag("result", "failure").tag("exception", exception).register(this.registry).record(elapsed, unit);
    }

    public static class Builder {
        private final String name;
        private Clock clock = Clock.SYSTEM;
        private final MeterRegistry registry;
        private List<Tag> baseTags = new ArrayList<Tag>();
        private LogLevel successLogLevel = LogLevel.INFO;
        private LogLevel failureLogLevel = LogLevel.WARN;

        private Builder(MeterRegistry registry, String name) {
            this.registry = Objects.requireNonNull(registry);
            this.name = Objects.requireNonNull(name);
        }

        public Builder tag(String key, String value) {
            return this.tag(Tag.of((String)key, (String)value));
        }

        public Builder tag(Tag tag) {
            this.baseTags.add(Objects.requireNonNull(tag));
            return this;
        }

        public Builder tags(Iterable<Tag> tag) {
            tag.forEach(this::tag);
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            return this.successLogLevel(logLevel).failureLogLevel(logLevel);
        }

        public Builder successLogLevel(LogLevel logLevel) {
            this.successLogLevel = Objects.requireNonNull(logLevel);
            return this;
        }

        public Builder failureLogLevel(LogLevel logLevel) {
            this.failureLogLevel = Objects.requireNonNull(logLevel);
            return this;
        }

        public Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        public ActionTimer build() {
            return new ActionTimer(this.registry, this.name, this.baseTags, this.clock, this.successLogLevel, this.failureLogLevel);
        }
    }
}

