/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.encryption;

import com.couchbase.client.encryption.CryptoProvider;
import com.couchbase.client.encryption.KeyStoreProvider;
import com.couchbase.client.encryption.errors.CryptoProviderKeySizeException;
import com.couchbase.client.encryption.errors.CryptoProviderMissingPublicKeyException;
import com.couchbase.client.encryption.errors.CryptoProviderMissingSigningKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class AESCryptoProviderBase
implements CryptoProvider {
    protected KeyStoreProvider keyStoreProvider;
    private final int IV_SIZE = 16;
    private String alias;

    public KeyStoreProvider getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(KeyStoreProvider provider) {
        this.keyStoreProvider = provider;
    }

    public byte[] encrypt(byte[] data) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        if (this.keyStoreProvider.publicKeyName() == null) {
            throw new CryptoProviderMissingPublicKeyException("Cryptographic providers require a non-null, empty public and key identifier (kid) be configured for the alias: " + this.alias);
        }
        SecretKeySpec key = new SecretKeySpec(this.keyStoreProvider.getKey(this.keyStoreProvider.publicKeyName()), "AES");
        this.checkKeySize(key);
        byte[] iv = new byte[16];
        SecureRandom random = new SecureRandom();
        random.nextBytes(iv);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)key, ivParameterSpec);
        byte[] encrypted = cipher.doFinal(data);
        byte[] encryptedWithIv = new byte[encrypted.length + 16];
        System.arraycopy(iv, 0, encryptedWithIv, 0, 16);
        System.arraycopy(encrypted, 0, encryptedWithIv, 16, encrypted.length);
        return encryptedWithIv;
    }

    public int getIVSize() {
        return 16;
    }

    public byte[] decrypt(byte[] encryptedwithIv) throws Exception {
        if (this.keyStoreProvider.publicKeyName() == null) {
            throw new CryptoProviderMissingPublicKeyException("Cryptographic providers require a non-null, empty public and key identifier (kid) be configured for the alias: " + this.alias);
        }
        SecretKeySpec key = new SecretKeySpec(this.keyStoreProvider.getKey(this.keyStoreProvider.publicKeyName()), "AES");
        this.checkKeySize(key);
        int ivSize = 16;
        byte[] iv = new byte[ivSize];
        System.arraycopy(encryptedwithIv, 0, iv, 0, ivSize);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
        int encryptedSize = encryptedwithIv.length - ivSize;
        byte[] encryptedBytes = new byte[encryptedSize];
        System.arraycopy(encryptedwithIv, ivSize, encryptedBytes, 0, encryptedSize);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(2, (Key)key, ivParameterSpec);
        return cipher.doFinal(encryptedBytes);
    }

    public byte[] getSignature(byte[] message) throws Exception {
        if (this.keyStoreProvider.signingKeyName() == null) {
            throw new CryptoProviderMissingSigningKeyException("The authentication failed while checking the signature of the message payload for the alias: " + this.alias);
        }
        Mac m = Mac.getInstance("HmacSHA256");
        SecretKeySpec key = new SecretKeySpec(this.keyStoreProvider.getKey(this.keyStoreProvider.signingKeyName()), "HMAC");
        m.init(key);
        return m.doFinal(message);
    }

    public boolean verifySignature(byte[] message, byte[] signature) throws Exception {
        return Arrays.equals(this.getSignature(message), signature);
    }

    public abstract String getProviderName();

    protected abstract int getKeySize();

    private void checkKeySize(SecretKeySpec key) throws Exception {
        int keySize = key.getEncoded().length;
        if (keySize != this.getKeySize()) {
            throw new CryptoProviderKeySizeException("Invalid key size " + keySize + " for " + this.getProviderAlgorithmName() + " Algorithm");
        }
    }

    public abstract boolean checkAlgorithmNameMatch(String var1);

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

