/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.CouchbaseOutOfMemoryException;
import com.couchbase.client.java.error.DocumentDoesNotExistException;
import com.couchbase.client.java.error.RequestTooBigException;
import com.couchbase.client.java.error.TemporaryFailureException;
import com.couchbase.client.java.error.subdoc.BadDeltaException;
import com.couchbase.client.java.error.subdoc.CannotInsertValueException;
import com.couchbase.client.java.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.java.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.java.error.subdoc.NumberTooBigException;
import com.couchbase.client.java.error.subdoc.PathExistsException;
import com.couchbase.client.java.error.subdoc.PathInvalidException;
import com.couchbase.client.java.error.subdoc.PathMismatchException;
import com.couchbase.client.java.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.error.subdoc.PathTooDeepException;
import com.couchbase.client.java.error.subdoc.ValueTooDeepException;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class SubdocHelper {
    public static CouchbaseException commonSubdocErrors(ResponseStatus status, String id, String path) {
        switch (status) {
            case NOT_EXISTS: {
                return new DocumentDoesNotExistException("Document not found for subdoc API: " + id);
            }
            case TEMPORARY_FAILURE: 
            case SERVER_BUSY: {
                return new TemporaryFailureException();
            }
            case OUT_OF_MEMORY: {
                return new CouchbaseOutOfMemoryException();
            }
            case EXISTS: {
                return new CASMismatchException("CAS provided in subdoc mutation didn't match the CAS of stored document " + id);
            }
            case TOO_BIG: {
                return new RequestTooBigException();
            }
            case SUBDOC_PATH_NOT_FOUND: {
                return new PathNotFoundException(id, path);
            }
            case SUBDOC_PATH_EXISTS: {
                return new PathExistsException(id, path);
            }
            case SUBDOC_DOC_NOT_JSON: {
                return new DocumentNotJsonException(id);
            }
            case SUBDOC_DOC_TOO_DEEP: {
                return new DocumentTooDeepException(id);
            }
            case SUBDOC_DELTA_RANGE: {
                return new BadDeltaException();
            }
            case SUBDOC_NUM_RANGE: {
                return new NumberTooBigException();
            }
            case SUBDOC_VALUE_TOO_DEEP: {
                return new ValueTooDeepException(id, path);
            }
            case SUBDOC_PATH_TOO_BIG: {
                return new PathTooDeepException(path);
            }
            case SUBDOC_PATH_INVALID: {
                return new PathInvalidException(id, path);
            }
            case SUBDOC_PATH_MISMATCH: {
                return new PathMismatchException(id, path);
            }
            case SUBDOC_VALUE_CANTINSERT: {
                return new CannotInsertValueException("Provided subdocument fragment is not valid JSON");
            }
        }
        return new CouchbaseException(status.toString());
    }

    public static boolean isSubdocLevelError(ResponseStatus responseStatus) {
        switch (responseStatus) {
            case SUBDOC_PATH_NOT_FOUND: 
            case SUBDOC_PATH_EXISTS: 
            case SUBDOC_DELTA_RANGE: 
            case SUBDOC_NUM_RANGE: 
            case SUBDOC_VALUE_TOO_DEEP: 
            case SUBDOC_PATH_TOO_BIG: 
            case SUBDOC_PATH_INVALID: 
            case SUBDOC_PATH_MISMATCH: 
            case SUBDOC_VALUE_CANTINSERT: {
                return true;
            }
            case SUBDOC_DOC_NOT_JSON: 
            case SUBDOC_DOC_TOO_DEEP: 
            case SUBDOC_INVALID_COMBO: 
            case SUBDOC_MULTI_PATH_FAILURE: {
                return false;
            }
        }
        return false;
    }
}

