/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures.collections;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.subdoc.multi.Lookup;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.error.CASMismatchException;
import com.couchbase.client.java.error.DocumentAlreadyExistsException;
import com.couchbase.client.java.error.subdoc.MultiMutationException;
import com.couchbase.client.java.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class CouchbaseMap<V>
extends AbstractMap<String, V> {
    private static final int MAX_OPTIMISTIC_LOCKING_ATTEMPTS = Integer.parseInt(System.getProperty("com.couchbase.datastructureCASRetryLimit", "10"));
    private final String id;
    private final Bucket bucket;

    public CouchbaseMap(String id, Bucket bucket) {
        this.id = id;
        this.bucket = bucket;
        try {
            bucket.insert(JsonDocument.create(id, JsonObject.empty()));
        }
        catch (DocumentAlreadyExistsException documentAlreadyExistsException) {
            // empty catch block
        }
    }

    public CouchbaseMap(String id, Bucket bucket, Map<String, ? extends V> data) {
        this.id = id;
        this.bucket = bucket;
        JsonObject content = JsonObject.create();
        if (data != null && !data.isEmpty()) {
            for (Map.Entry<String, V> entry : data.entrySet()) {
                if (entry.getKey() == null) {
                    throw new NullPointerException("Attempted to create a map with a null key");
                }
                content.put(entry.getKey(), entry.getValue());
            }
        }
        JsonDocument initial = JsonDocument.create(id, content);
        bucket.upsert(initial);
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new NullPointerException("Unsupported null key");
        }
        if (!JsonValue.checkType(value)) {
            throw new IllegalArgumentException("Unsupported value type.");
        }
        for (int i = 0; i < MAX_OPTIMISTIC_LOCKING_ATTEMPTS; ++i) {
            try {
                DocumentFragment<Lookup> current = this.bucket.lookupIn(this.id).get(key).execute();
                long returnCas = current.cas();
                Object result = null;
                if (current.exists(key)) {
                    result = current.content(key);
                }
                this.bucket.mutateIn(this.id).upsert(key, value, false).withCas(returnCas).execute();
                return (V)result;
            }
            catch (CASMismatchException cASMismatchException) {
                continue;
            }
        }
        throw new ConcurrentModificationException("Couldn't perform put in less than " + MAX_OPTIMISTIC_LOCKING_ATTEMPTS + " iterations");
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Unsupported null key");
        }
        try {
            return (V)this.bucket.lookupIn(this.id).get(String.valueOf(key)).execute().content(0);
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public V remove(Object key) {
        if (key == null) {
            throw new NullPointerException("Unsupported null key");
        }
        String idx = String.valueOf(key);
        for (int i = 0; i < MAX_OPTIMISTIC_LOCKING_ATTEMPTS; ++i) {
            try {
                DocumentFragment<Lookup> current = this.bucket.lookupIn(this.id).get(idx).execute();
                long returnCas = current.cas();
                Object result = current.content(idx);
                DocumentFragment<Mutation> updated = this.bucket.mutateIn(this.id).remove(idx).withCas(returnCas).execute();
                return (V)result;
            }
            catch (CASMismatchException current) {
                continue;
            }
            catch (MultiMutationException ex) {
                if (ex.firstFailureStatus() == ResponseStatus.SUBDOC_PATH_NOT_FOUND) {
                    return null;
                }
                throw ex;
            }
        }
        throw new ConcurrentModificationException("Couldn't perform remove in less than " + MAX_OPTIMISTIC_LOCKING_ATTEMPTS + " iterations");
    }

    @Override
    public void clear() {
        this.bucket.upsert(JsonDocument.create(this.id, JsonObject.empty()));
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return new CouchbaseEntrySet(((JsonObject)this.bucket.get(this.id).content()).toMap());
    }

    @Override
    public boolean containsKey(Object key) {
        return (Boolean)this.bucket.lookupIn(this.id).exists(String.valueOf(key)).execute().content(0);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public int size() {
        return super.size();
    }

    private class CouchbaseEntrySetIterator
    implements Iterator<Map.Entry<String, V>> {
        private final Iterator<Map.Entry<String, V>> delegateItr;
        private Map.Entry<String, V> lastNext = null;

        public CouchbaseEntrySetIterator(Iterator<Map.Entry<String, V>> iterator) {
            this.delegateItr = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegateItr.hasNext();
        }

        @Override
        public Map.Entry<String, V> next() {
            this.lastNext = this.delegateItr.next();
            return this.lastNext;
        }

        @Override
        public void remove() {
            if (this.lastNext == null) {
                throw new IllegalStateException("next() hasn't been called before remove()");
            }
            this.delegateItr.remove();
            CouchbaseMap.this.remove(this.lastNext.getKey());
        }
    }

    private class CouchbaseEntrySet
    implements Set<Map.Entry<String, V>> {
        private final Set<Map.Entry<String, V>> delegate;

        private CouchbaseEntrySet(Map<String, V> data) {
            this.delegate = data.entrySet();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<Map.Entry<String, V>> iterator() {
            return new CouchbaseEntrySetIterator(this.delegate.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(Map.Entry<String, V> stringVEntry) {
            return this.delegate.add(stringVEntry);
        }

        @Override
        public boolean remove(Object o) {
            if (this.delegate.remove(o)) {
                if (!(o instanceof Map.Entry)) {
                    throw new IllegalStateException("Expected entrySet remove() to remove an entry");
                }
                Map.Entry entry = (Map.Entry)o;
                CouchbaseMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<String, V>> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
            CouchbaseMap.this.clear();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }
    }
}

