/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.analytics;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.analytics.AnalyticsParams;
import com.couchbase.client.java.analytics.SimpleAnalyticsQuery;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;

@InterfaceStability.Uncommitted
@InterfaceAudience.Public
public class ParameterizedAnalyticsQuery
extends SimpleAnalyticsQuery {
    private final JsonArray positional;
    private final JsonObject named;

    ParameterizedAnalyticsQuery(String statement, JsonArray positional, JsonObject named, AnalyticsParams params) {
        super(statement, params);
        this.named = named;
        this.positional = positional;
    }

    @Override
    public JsonObject query() {
        JsonObject query = super.query();
        if (this.named != null && !this.named.isEmpty()) {
            for (String key : this.named.getNames()) {
                Object value = this.named.get(key);
                if (!key.startsWith("$")) {
                    key = "$" + key;
                }
                query.put(key, value);
            }
        }
        if (this.positional != null && !this.positional.isEmpty()) {
            query.put("args", this.positional);
        }
        return query;
    }
}

