/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiMutationResponse;
import com.couchbase.client.core.message.kv.subdoc.multi.MultiResult;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.core.message.kv.subdoc.multi.MutationCommand;
import com.couchbase.client.core.message.kv.subdoc.multi.MutationCommandBuilder;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiMutationDocOptionsBuilder;
import com.couchbase.client.core.message.kv.subdoc.multi.SubMultiMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.AbstractSubdocMutationRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SimpleSubdocResponse;
import com.couchbase.client.core.message.kv.subdoc.simple.SubArrayRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubCounterRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubDeleteRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubDictAddRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubDictUpsertRequest;
import com.couchbase.client.core.message.kv.subdoc.simple.SubReplaceRequest;
import com.couchbase.client.core.message.observe.Observe;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.core.tracing.ThresholdLogSpan;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.deps.io.netty.util.internal.StringUtil;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.error.DurabilityException;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.error.subdoc.BadDeltaException;
import com.couchbase.client.java.error.subdoc.CannotInsertValueException;
import com.couchbase.client.java.error.subdoc.MultiMutationException;
import com.couchbase.client.java.error.subdoc.PathExistsException;
import com.couchbase.client.java.error.subdoc.PathInvalidException;
import com.couchbase.client.java.error.subdoc.PathMismatchException;
import com.couchbase.client.java.error.subdoc.PathNotFoundException;
import com.couchbase.client.java.error.subdoc.SubDocumentException;
import com.couchbase.client.java.error.subdoc.XattrOrderingException;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.MultiValue;
import com.couchbase.client.java.subdoc.MutationSpec;
import com.couchbase.client.java.subdoc.SubdocHelper;
import com.couchbase.client.java.subdoc.SubdocOperationResult;
import com.couchbase.client.java.subdoc.SubdocOptionsBuilder;
import com.couchbase.client.java.transcoder.subdoc.FragmentTranscoder;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import io.opentracing.Scope;
import io.opentracing.Span;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.functions.Func3;

@InterfaceStability.Committed
@InterfaceAudience.Public
public class AsyncMutateInBuilder {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(AsyncMutateInBuilder.class);
    private final ClusterFacade core;
    private final CouchbaseEnvironment environment;
    private final String bucketName;
    private final FragmentTranscoder subdocumentTranscoder;
    protected final String docId;
    protected final List<MutationSpec> mutationSpecs;
    protected int expiry;
    protected long cas;
    protected PersistTo persistTo;
    protected ReplicateTo replicateTo;
    protected boolean upsertDocument;
    protected boolean insertDocument;
    private final Func2<MutationSpec, ByteBuf, SubDictUpsertRequest> DICT_UPSERT_FACTORY = new Func2<MutationSpec, ByteBuf, SubDictUpsertRequest>(){

        public SubDictUpsertRequest call(MutationSpec spec, ByteBuf buf) {
            SubDictUpsertRequest request = new SubDictUpsertRequest(AsyncMutateInBuilder.this.docId, spec.path(), buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
            request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> DICT_UPSERT_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            switch (status) {
                case SUCCESS: {
                    return null;
                }
                case SUBDOC_PATH_INVALID: {
                    throw new PathInvalidException("Path " + path + " ends in an array index in " + docId + ", expected dictionary");
                }
                case SUBDOC_PATH_MISMATCH: {
                    throw new PathMismatchException("Path " + path + " ends in a scalar value in " + docId + ", expected dictionary");
                }
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };
    private final Func2<MutationSpec, ByteBuf, SubDictAddRequest> DICT_ADD_FACTORY = new Func2<MutationSpec, ByteBuf, SubDictAddRequest>(){

        public SubDictAddRequest call(MutationSpec spec, ByteBuf buf) {
            SubDictAddRequest request = new SubDictAddRequest(AsyncMutateInBuilder.this.docId, spec.path(), buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
            request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> DICT_ADD_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            switch (status) {
                case SUCCESS: {
                    return null;
                }
                case SUBDOC_PATH_INVALID: {
                    throw new PathInvalidException("Path " + path + " ends in an array index in " + docId + ", expected dictionary");
                }
                case SUBDOC_PATH_MISMATCH: {
                    throw new PathMismatchException("Path " + path + " ends in a scalar value in " + docId + ", expected dictionary");
                }
                case SUBDOC_PATH_EXISTS: {
                    throw new PathExistsException(docId, path);
                }
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };
    private final Func2<MutationSpec, ByteBuf, SubReplaceRequest> REPLACE_FACTORY = new Func2<MutationSpec, ByteBuf, SubReplaceRequest>(){

        public SubReplaceRequest call(MutationSpec spec, ByteBuf buf) {
            SubReplaceRequest request = new SubReplaceRequest(AsyncMutateInBuilder.this.docId, spec.path(), buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
            request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> REPLACE_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            switch (status) {
                case SUCCESS: {
                    return null;
                }
                case SUBDOC_PATH_NOT_FOUND: {
                    throw new PathNotFoundException("Path to be replaced " + path + " not found in " + docId);
                }
                case SUBDOC_PATH_MISMATCH: {
                    throw new PathMismatchException("Path " + path + " ends in a scalar value in " + docId + ", expected dictionary");
                }
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };
    private final Func2<MutationSpec, ByteBuf, SubArrayRequest> ARRAY_EXTEND_FACTORY = new Func2<MutationSpec, ByteBuf, SubArrayRequest>(){

        public SubArrayRequest call(MutationSpec spec, ByteBuf buf) {
            SubArrayRequest.ArrayOperation op;
            switch (spec.type()) {
                case ARRAY_PUSH_FIRST: {
                    op = SubArrayRequest.ArrayOperation.PUSH_FIRST;
                    break;
                }
                default: {
                    op = SubArrayRequest.ArrayOperation.PUSH_LAST;
                }
            }
            SubArrayRequest request = new SubArrayRequest(AsyncMutateInBuilder.this.docId, spec.path(), op, buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
            request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> ARRAY_EXTEND_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            if (status.isSuccess()) {
                return null;
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };
    private final Func2<MutationSpec, ByteBuf, SubArrayRequest> ARRAY_INSERT_FACTORY = new Func2<MutationSpec, ByteBuf, SubArrayRequest>(){

        public SubArrayRequest call(MutationSpec spec, ByteBuf buf) {
            SubArrayRequest request = new SubArrayRequest(AsyncMutateInBuilder.this.docId, spec.path(), SubArrayRequest.ArrayOperation.INSERT, buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> ARRAY_INSERT_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            switch (status) {
                case SUCCESS: {
                    return null;
                }
                case SUBDOC_PATH_MISMATCH: {
                    throw new PathMismatchException("The last component of path " + path + " in " + docId + " was expected to be an array element");
                }
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };
    private final Func2<MutationSpec, ByteBuf, SubArrayRequest> ARRAY_ADDUNIQUE_FACTORY = new Func2<MutationSpec, ByteBuf, SubArrayRequest>(){

        public SubArrayRequest call(MutationSpec spec, ByteBuf buf) {
            SubArrayRequest request = new SubArrayRequest(AsyncMutateInBuilder.this.docId, spec.path(), SubArrayRequest.ArrayOperation.ADD_UNIQUE, buf, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
            request.createIntermediaryPath(spec.createPath());
            request.xattr(spec.xattr());
            request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
            request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
            return request;
        }
    };
    private static final Func3<ResponseStatus, String, String, Object> ARRAY_ADDUNIQUE_EVALUATOR = new Func3<ResponseStatus, String, String, Object>(){

        public Object call(ResponseStatus status, String docId, String path) {
            switch (status) {
                case SUCCESS: {
                    return null;
                }
                case SUBDOC_PATH_EXISTS: {
                    throw new PathExistsException("The unique value already exist in array " + path + " in document " + docId);
                }
                case SUBDOC_VALUE_CANTINSERT: {
                    throw new CannotInsertValueException("The unique value provided is not a JSON primitive");
                }
                case SUBDOC_PATH_MISMATCH: {
                    throw new PathMismatchException("The array at " + path + " contains non-primitive JSON elements in document " + docId);
                }
            }
            throw SubdocHelper.commonSubdocErrors(status, docId, path);
        }
    };

    @InterfaceAudience.Private
    public AsyncMutateInBuilder(ClusterFacade core, String bucketName, CouchbaseEnvironment environment, FragmentTranscoder transcoder, String docId) {
        if (docId == null || docId.isEmpty()) {
            throw new IllegalArgumentException("The document ID must not be null or empty.");
        }
        if (docId.getBytes().length > 250) {
            throw new IllegalArgumentException("The document ID must not be larger than 250 bytes");
        }
        this.core = core;
        this.bucketName = bucketName;
        this.environment = environment;
        this.subdocumentTranscoder = transcoder;
        this.docId = docId;
        this.mutationSpecs = new ArrayList<MutationSpec>();
        this.expiry = 0;
        this.cas = 0L;
        this.persistTo = PersistTo.NONE;
        this.replicateTo = ReplicateTo.NONE;
    }

    public Observable<DocumentFragment<Mutation>> execute() {
        return this.execute(0L, null);
    }

    public Observable<DocumentFragment<Mutation>> execute(long timeout, TimeUnit timeUnit) {
        if (this.mutationSpecs.isEmpty()) {
            throw new IllegalArgumentException("Execution of a subdoc mutation requires at least one operation");
        }
        if (this.mutationSpecs.size() == 1) {
            return this.doSingleMutate(this.mutationSpecs.get(0), timeout, timeUnit);
        }
        return this.doMultiMutate(timeout, timeUnit);
    }

    public Observable<DocumentFragment<Mutation>> execute(PersistTo persistTo, ReplicateTo replicateTo) {
        return this.execute(persistTo, replicateTo, 0L, null);
    }

    public Observable<DocumentFragment<Mutation>> execute(final PersistTo persistTo, final ReplicateTo replicateTo, final long timeout, final TimeUnit timeUnit) {
        Observable<DocumentFragment<Mutation>> mutationResult = this.execute(timeout, timeUnit);
        if (persistTo == PersistTo.NONE && replicateTo == ReplicateTo.NONE) {
            return mutationResult;
        }
        return mutationResult.flatMap((Func1)new Func1<DocumentFragment<Mutation>, Observable<DocumentFragment<Mutation>>>(){

            public Observable<DocumentFragment<Mutation>> call(final DocumentFragment<Mutation> fragment) {
                Observable result = Observe.call((ClusterFacade)AsyncMutateInBuilder.this.core, (String)AsyncMutateInBuilder.this.bucketName, (String)AsyncMutateInBuilder.this.docId, (long)fragment.cas(), (boolean)false, (MutationToken)fragment.mutationToken(), (Observe.PersistTo)persistTo.value(), (Observe.ReplicateTo)replicateTo.value(), (Delay)AsyncMutateInBuilder.this.environment.observeIntervalDelay(), (RetryStrategy)AsyncMutateInBuilder.this.environment.retryStrategy()).map((Func1)new Func1<Boolean, DocumentFragment<Mutation>>(){

                    public DocumentFragment<Mutation> call(Boolean aBoolean) {
                        return fragment;
                    }
                }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<DocumentFragment<Mutation>>>(){

                    public Observable<DocumentFragment<Mutation>> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
                if (timeout > 0L) {
                    result = result.timeout(timeout, timeUnit, AsyncMutateInBuilder.this.environment.scheduler());
                }
                return result;
            }
        });
    }

    public Observable<DocumentFragment<Mutation>> execute(PersistTo persistTo) {
        return this.execute(persistTo, ReplicateTo.NONE, 0L, null);
    }

    public Observable<DocumentFragment<Mutation>> execute(PersistTo persistTo, long timeout, TimeUnit timeUnit) {
        return this.execute(persistTo, ReplicateTo.NONE, timeout, timeUnit);
    }

    public Observable<DocumentFragment<Mutation>> execute(ReplicateTo replicateTo) {
        return this.execute(PersistTo.NONE, replicateTo, 0L, null);
    }

    public Observable<DocumentFragment<Mutation>> execute(ReplicateTo replicateTo, long timeout, TimeUnit timeUnit) {
        return this.execute(PersistTo.NONE, replicateTo, timeout, timeUnit);
    }

    public AsyncMutateInBuilder withExpiry(int expiry) {
        this.expiry = expiry;
        return this;
    }

    public AsyncMutateInBuilder withCas(long cas) {
        this.cas = cas;
        return this;
    }

    public AsyncMutateInBuilder withDurability(PersistTo persistTo) {
        this.persistTo = persistTo;
        return this;
    }

    public AsyncMutateInBuilder withDurability(ReplicateTo replicateTo) {
        this.replicateTo = replicateTo;
        return this;
    }

    public AsyncMutateInBuilder withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
        this.persistTo = persistTo;
        this.replicateTo = replicateTo;
        return this;
    }

    @Deprecated
    public AsyncMutateInBuilder createDocument(boolean createDocument) {
        return this.upsertDocument(createDocument);
    }

    public AsyncMutateInBuilder upsertDocument(boolean upsertDocument) {
        if (this.insertDocument && upsertDocument) {
            throw new IllegalArgumentException("Cannot set both upsertDocument and insertDocument to true");
        }
        this.upsertDocument = upsertDocument;
        return this;
    }

    @InterfaceStability.Committed
    public AsyncMutateInBuilder insertDocument(boolean insertDocument) {
        if (this.upsertDocument && insertDocument) {
            throw new IllegalArgumentException("Cannot set both upsertDocument and insertDocument to true");
        }
        this.insertDocument = insertDocument;
        return this;
    }

    public <T> AsyncMutateInBuilder replace(String path, T fragment) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for replace");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.REPLACE, path, fragment));
        return this;
    }

    public <T> AsyncMutateInBuilder replace(String path, T fragment, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for replace");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.REPLACE, path, fragment, optionsBuilder));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder insert(String path, T fragment, boolean createPath) {
        return this.insert(path, fragment, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder insert(String path, T fragment) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for insert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DICT_ADD, path, fragment));
        return this;
    }

    public <T> AsyncMutateInBuilder insert(String path, T fragment, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for insert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DICT_ADD, path, fragment, optionsBuilder));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder upsert(String path, T fragment, boolean createPath) {
        return this.upsert(path, fragment, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder upsert(String path, T fragment) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for upsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DICT_UPSERT, path, fragment));
        return this;
    }

    @InterfaceStability.Committed
    public AsyncMutateInBuilder upsert(JsonObject content) {
        this.mutationSpecs.add(new MutationSpec(Mutation.UPSERTDOC, "", content));
        return this;
    }

    public <T> AsyncMutateInBuilder upsert(String path, T fragment, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for upsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DICT_UPSERT, path, fragment, optionsBuilder));
        return this;
    }

    public <T> AsyncMutateInBuilder remove(String path) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for remove");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DELETE, path, null));
        return this;
    }

    public <T> AsyncMutateInBuilder remove(String path, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for remove");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.DELETE, path, null, optionsBuilder));
        return this;
    }

    @Deprecated
    public AsyncMutateInBuilder counter(String path, long delta, boolean createPath) {
        return this.counter(path, delta, new SubdocOptionsBuilder().createPath(createPath));
    }

    public AsyncMutateInBuilder counter(String path, long delta) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for counter");
        }
        if (delta == 0L) {
            throw new BadDeltaException("Delta must not be 0");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.COUNTER, path, delta));
        return this;
    }

    public AsyncMutateInBuilder counter(String path, long delta, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for counter");
        }
        if (delta == 0L) {
            throw new BadDeltaException("Delta must not be 0");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.COUNTER, path, (Object)delta, optionsBuilder));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder arrayPrepend(String path, T value, boolean createPath) {
        return this.arrayPrepend(path, value, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder arrayPrepend(String path, T value) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_FIRST, path, value));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayPrepend(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_FIRST, path, value, optionsBuilder));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder arrayPrependAll(String path, Collection<T> values, boolean createPath) {
        return this.arrayPrependAll(path, values, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder arrayPrependAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_FIRST, path, new MultiValue<T>(values), optionsBuilder));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayPrependAll(String path, T ... values) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_FIRST, path, new MultiValue<T>(values)));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder arrayAppend(String path, T value, boolean createPath) {
        return this.arrayAppend(path, value, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder arrayAppend(String path, T value) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_LAST, path, value));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayAppend(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_LAST, path, value, optionsBuilder));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder arrayAppendAll(String path, Collection<T> values, boolean createPath) {
        return this.arrayAppendAll(path, values, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder arrayAppendAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_LAST, path, new MultiValue<T>(values), optionsBuilder));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayAppendAll(String path, T ... values) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_PUSH_LAST, path, new MultiValue<T>(values)));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayInsert(String path, T value) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for arrayInsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_INSERT, path, value));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayInsert(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for arrayInsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_INSERT, path, value, optionsBuilder));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayInsertAll(String path, Collection<T> values) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for arrayInsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_INSERT, path, new MultiValue<T>(values)));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayInsertAll(String path, Collection<T> values, SubdocOptionsBuilder optionsBuilder) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for arrayInsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_INSERT, path, new MultiValue<T>(values), optionsBuilder));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayInsertAll(String path, T ... values) {
        if (StringUtil.isNullOrEmpty((String)path)) {
            throw new IllegalArgumentException("Path must not be empty for arrayInsert");
        }
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_INSERT, path, new MultiValue<T>(values), false));
        return this;
    }

    @Deprecated
    public <T> AsyncMutateInBuilder arrayAddUnique(String path, T value, boolean createPath) {
        return this.arrayAddUnique(path, value, new SubdocOptionsBuilder().createPath(createPath));
    }

    public <T> AsyncMutateInBuilder arrayAddUnique(String path, T value) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_ADD_UNIQUE, path, value));
        return this;
    }

    public <T> AsyncMutateInBuilder arrayAddUnique(String path, T value, SubdocOptionsBuilder optionsBuilder) {
        this.mutationSpecs.add(new MutationSpec(Mutation.ARRAY_ADD_UNIQUE, path, value, optionsBuilder));
        return this;
    }

    protected Observable<DocumentFragment<Mutation>> doMultiMutate(final long timeout, final TimeUnit timeUnit) {
        if (this.mutationSpecs.isEmpty()) {
            throw new IllegalArgumentException("At least one Mutation Spec is necessary for mutateIn");
        }
        boolean seenNonXattr = false;
        for (MutationSpec spec : this.mutationSpecs) {
            if (spec.xattr() && seenNonXattr) {
                throw new XattrOrderingException("Xattr-based commands must always come first in the builder!");
            }
            if (spec.xattr()) continue;
            seenNonXattr = true;
        }
        Observable mutations = Observable.defer((Func0)new Func0<Observable<DocumentFragment<Mutation>>>(){

            public Observable<DocumentFragment<Mutation>> call() {
                ArrayList<ByteBuf> bufList = new ArrayList<ByteBuf>(AsyncMutateInBuilder.this.mutationSpecs.size());
                ArrayList<MutationCommand> commands = new ArrayList<MutationCommand>(AsyncMutateInBuilder.this.mutationSpecs.size());
                for (int i = 0; i < AsyncMutateInBuilder.this.mutationSpecs.size(); ++i) {
                    MutationSpec spec = AsyncMutateInBuilder.this.mutationSpecs.get(i);
                    if (spec.type() == Mutation.DELETE) {
                        commands.add(new MutationCommandBuilder(Mutation.DELETE, spec.path()).xattr(spec.xattr()).build());
                        continue;
                    }
                    try {
                        ByteBuf buf = AsyncMutateInBuilder.this.subdocumentTranscoder.encodeWithMessage(spec.fragment(), "Couldn't encode MutationSpec #" + i + " (" + spec.type() + " on " + spec.path() + ") in " + AsyncMutateInBuilder.this.docId);
                        bufList.add(buf);
                        commands.add(new MutationCommandBuilder(spec.type(), spec.path(), buf).createIntermediaryPath(spec.createPath()).xattr(spec.xattr()).build());
                        continue;
                    }
                    catch (TranscodingException e) {
                        AsyncMutateInBuilder.releaseAll(bufList);
                        return Observable.error((Throwable)((Object)e));
                    }
                }
                final SubMultiMutationRequest req = new SubMultiMutationRequest(AsyncMutateInBuilder.this.docId, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas, SubMultiMutationDocOptionsBuilder.builder().upsertDocument(AsyncMutateInBuilder.this.upsertDocument).insertDocument(AsyncMutateInBuilder.this.insertDocument), commands);
                Utils.addRequestSpan(AsyncMutateInBuilder.this.environment, (CouchbaseRequest)req, "subdoc_multi_mutate");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<MultiMutationResponse>>(){

                    public Observable<MultiMutationResponse> call(Subscriber subscriber) {
                        req.subscriber(subscriber);
                        return AsyncMutateInBuilder.this.core.send((CouchbaseRequest)req);
                    }
                }).flatMap((Func1)new Func1<MultiMutationResponse, Observable<DocumentFragment<Mutation>>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Observable<DocumentFragment<Mutation>> call(MultiMutationResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (AsyncMutateInBuilder.this.environment.operationTracingEnabled()) {
                            AsyncMutateInBuilder.this.environment.tracer().scopeManager().activate(req.span(), true).close();
                        }
                        if (response.status().isSuccess()) {
                            int resultSize = response.responses().size();
                            ArrayList results = new ArrayList(resultSize);
                            for (MultiResult result : response.responses()) {
                                try {
                                    Object content = null;
                                    if (result.value().isReadable()) {
                                        content = AsyncMutateInBuilder.this.subdocumentTranscoder.decode(result.value(), Object.class);
                                    }
                                    results.add(SubdocOperationResult.createResult(result.path(), result.operation(), result.status(), content));
                                }
                                catch (TranscodingException e) {
                                    LOGGER.error("Couldn't decode multi-mutation {} for {}/{}", new Object[]{RedactableArgument.user((Object)result), RedactableArgument.user((Object)AsyncMutateInBuilder.this.docId), RedactableArgument.user((Object)result.path()), e});
                                    results.add(SubdocOperationResult.createFatal(result.path(), result.operation(), (RuntimeException)((Object)e)));
                                }
                                finally {
                                    if (result.value() == null) continue;
                                    result.value().release();
                                }
                            }
                            return Observable.just(new DocumentFragment(AsyncMutateInBuilder.this.docId, response.cas(), response.mutationToken(), results));
                        }
                        switch (response.status()) {
                            case SUBDOC_MULTI_PATH_FAILURE: {
                                int index = response.firstErrorIndex();
                                ResponseStatus errorStatus = response.firstErrorStatus();
                                String errorPath = AsyncMutateInBuilder.this.mutationSpecs.get(index).path();
                                CouchbaseException errorException = SubdocHelper.commonSubdocErrors(errorStatus, AsyncMutateInBuilder.this.docId, errorPath);
                                return Observable.error((Throwable)((Object)new MultiMutationException(index, errorStatus, AsyncMutateInBuilder.this.mutationSpecs, errorException)));
                            }
                        }
                        return Observable.error((Throwable)SubdocHelper.commonSubdocErrors(response.status(), AsyncMutateInBuilder.this.docId, "MULTI-MUTATION"));
                    }
                }), (CouchbaseRequest)req, AsyncMutateInBuilder.this.environment, timeout, timeUnit);
            }
        });
        return this.subdocObserveMutation(mutations, timeout, timeUnit);
    }

    protected Observable<DocumentFragment<Mutation>> doSingleMutate(MutationSpec spec, long timeout, TimeUnit timeUnit) {
        Observable<DocumentFragment<Mutation>> mutation;
        switch (spec.type()) {
            case DICT_UPSERT: {
                mutation = this.doSingleMutate(spec, this.DICT_UPSERT_FACTORY, DICT_UPSERT_EVALUATOR, timeout, timeUnit);
                break;
            }
            case DICT_ADD: {
                mutation = this.doSingleMutate(spec, this.DICT_ADD_FACTORY, DICT_ADD_EVALUATOR, timeout, timeUnit);
                break;
            }
            case REPLACE: {
                mutation = this.doSingleMutate(spec, this.REPLACE_FACTORY, REPLACE_EVALUATOR, timeout, timeUnit);
                break;
            }
            case ARRAY_PUSH_FIRST: 
            case ARRAY_PUSH_LAST: {
                mutation = this.doSingleMutate(spec, this.ARRAY_EXTEND_FACTORY, ARRAY_EXTEND_EVALUATOR, timeout, timeUnit);
                break;
            }
            case ARRAY_INSERT: {
                mutation = this.doSingleMutate(spec, this.ARRAY_INSERT_FACTORY, ARRAY_INSERT_EVALUATOR, timeout, timeUnit);
                break;
            }
            case ARRAY_ADD_UNIQUE: {
                mutation = this.doSingleMutate(spec, this.ARRAY_ADDUNIQUE_FACTORY, ARRAY_ADDUNIQUE_EVALUATOR, timeout, timeUnit);
                break;
            }
            case COUNTER: {
                mutation = this.counterIn(spec, timeout, timeUnit);
                break;
            }
            case DELETE: {
                mutation = this.removeIn(spec, timeout, timeUnit);
                break;
            }
            default: {
                mutation = Observable.error((Throwable)new UnsupportedOperationException());
            }
        }
        return this.subdocObserveMutation(mutation, timeout, timeUnit);
    }

    private Observable<DocumentFragment<Mutation>> doSingleMutate(final MutationSpec spec, final Func2<MutationSpec, ByteBuf, ? extends AbstractSubdocMutationRequest> requestFactory, final Func3<ResponseStatus, String, String, Object> responseStatusDocIdAndPathToValueEvaluator, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Mutation>>>(){

            public Observable<DocumentFragment<Mutation>> call() {
                ByteBuf buf;
                Span requestSpan = null;
                if (AsyncMutateInBuilder.this.environment.operationTracingEnabled()) {
                    Scope scope = AsyncMutateInBuilder.this.environment.tracer().buildSpan("subdoc_mutate").startActive(false);
                    requestSpan = scope.span();
                    scope.close();
                }
                Scope encodeScope = null;
                if (requestSpan != null) {
                    encodeScope = AsyncMutateInBuilder.this.environment.tracer().buildSpan("request_encoding").asChildOf(requestSpan).startActive(true);
                }
                try {
                    buf = AsyncMutateInBuilder.this.subdocumentTranscoder.encodeWithMessage(spec.fragment(), "Couldn't encode subdoc fragment " + AsyncMutateInBuilder.this.docId + "/" + spec.path() + " \"" + spec.fragment() + "\"");
                }
                catch (TranscodingException e) {
                    return Observable.error((Throwable)((Object)e));
                }
                if (encodeScope != null) {
                    encodeScope.close();
                    if (encodeScope.span() instanceof ThresholdLogSpan) {
                        encodeScope.span().setBaggageItem("encode_us", Long.toString(((ThresholdLogSpan)encodeScope.span()).durationMicros()));
                    }
                }
                final AbstractSubdocMutationRequest request = (AbstractSubdocMutationRequest)requestFactory.call((Object)spec, (Object)buf);
                if (requestSpan != null) {
                    request.span(requestSpan, (CoreEnvironment)AsyncMutateInBuilder.this.environment);
                }
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncMutateInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Mutation>>(){

                    public DocumentFragment<Mutation> call(SimpleSubdocResponse response) {
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        ResponseStatus responseStatus = response.status();
                        try {
                            Object value = responseStatusDocIdAndPathToValueEvaluator.call((Object)responseStatus, (Object)AsyncMutateInBuilder.this.docId, (Object)spec.path());
                            SubdocOperationResult<Mutation> singleResult = SubdocOperationResult.createResult(spec.path(), spec.type(), response.status(), value);
                            return new DocumentFragment<Mutation>(AsyncMutateInBuilder.this.docId, response.cas(), response.mutationToken(), Collections.singletonList(singleResult));
                        }
                        catch (SubDocumentException e) {
                            if (SubdocHelper.isSubdocLevelError(responseStatus)) {
                                throw new MultiMutationException(0, responseStatus, Collections.singletonList(spec), e);
                            }
                            throw e;
                        }
                    }
                }), (CouchbaseRequest)request, AsyncMutateInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    private Observable<DocumentFragment<Mutation>> removeIn(final MutationSpec spec, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Mutation>>>(){

            public Observable<DocumentFragment<Mutation>> call() {
                final SubDeleteRequest request = new SubDeleteRequest(AsyncMutateInBuilder.this.docId, spec.path(), AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
                request.xattr(spec.xattr());
                Utils.addRequestSpan(AsyncMutateInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_remove");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncMutateInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Mutation>>(){

                    public DocumentFragment<Mutation> call(SimpleSubdocResponse response) {
                        ResponseStatus responseStatus;
                        if (response.content() != null && response.content().refCnt() > 0) {
                            response.content().release();
                        }
                        if (AsyncMutateInBuilder.this.environment.operationTracingEnabled()) {
                            AsyncMutateInBuilder.this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        if (!(responseStatus = response.status()).isSuccess()) {
                            CouchbaseException subdocError = SubdocHelper.commonSubdocErrors(response.status(), AsyncMutateInBuilder.this.docId, spec.path());
                            if (SubdocHelper.isSubdocLevelError(responseStatus)) {
                                throw new MultiMutationException(0, responseStatus, Collections.singletonList(spec), subdocError);
                            }
                            throw subdocError;
                        }
                        SubdocOperationResult<Mutation> singleResult = SubdocOperationResult.createResult(spec.path(), spec.type(), response.status(), null);
                        return new DocumentFragment<Mutation>(AsyncMutateInBuilder.this.docId, response.cas(), response.mutationToken(), Collections.singletonList(singleResult));
                    }
                }), (CouchbaseRequest)request, AsyncMutateInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    private Observable<DocumentFragment<Mutation>> counterIn(final MutationSpec spec, final long timeout, final TimeUnit timeUnit) {
        if (spec.fragment() != null && !(spec.fragment() instanceof Number)) {
            return Observable.error((Throwable)new IllegalArgumentException("Counter fragment must be a long/integer"));
        }
        Number fragment = (Number)spec.fragment();
        if (fragment == null || fragment.longValue() == 0L) {
            return Observable.error((Throwable)((Object)new BadDeltaException()));
        }
        final long delta = fragment.longValue();
        return Observable.defer((Func0)new Func0<Observable<DocumentFragment<Mutation>>>(){

            public Observable<DocumentFragment<Mutation>> call() {
                final SubCounterRequest request = new SubCounterRequest(AsyncMutateInBuilder.this.docId, spec.path(), delta, AsyncMutateInBuilder.this.bucketName, AsyncMutateInBuilder.this.expiry, AsyncMutateInBuilder.this.cas);
                request.createIntermediaryPath(spec.createPath());
                request.xattr(spec.xattr());
                request.upsertDocument(AsyncMutateInBuilder.this.upsertDocument);
                request.insertDocument(AsyncMutateInBuilder.this.insertDocument);
                Utils.addRequestSpan(AsyncMutateInBuilder.this.environment, (CouchbaseRequest)request, "subdoc_counter");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<SimpleSubdocResponse>>(){

                    public Observable<SimpleSubdocResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return AsyncMutateInBuilder.this.core.send((CouchbaseRequest)request);
                    }
                }).map((Func1)new Func1<SimpleSubdocResponse, DocumentFragment<Mutation>>(){

                    public DocumentFragment<Mutation> call(SimpleSubdocResponse response) {
                        ResponseStatus status;
                        block13: {
                            status = response.status();
                            if (status.isSuccess()) {
                                try {
                                    Long value = Long.parseLong(response.content().toString(CharsetUtil.UTF_8));
                                    SubdocOperationResult<Mutation> singleResult = SubdocOperationResult.createResult(spec.path(), spec.type(), status, value);
                                    DocumentFragment<Mutation> documentFragment = new DocumentFragment<Mutation>(AsyncMutateInBuilder.this.docId, response.cas(), response.mutationToken(), Collections.singletonList(singleResult));
                                    return documentFragment;
                                }
                                catch (NumberFormatException e) {
                                    throw new TranscodingException("Couldn't parse counter response into a long", e);
                                }
                                finally {
                                    if (response.content() != null) {
                                        response.content().release();
                                    }
                                }
                            }
                            if (response.content() == null) break block13;
                            response.content().release();
                        }
                        CouchbaseException subdocError = SubdocHelper.commonSubdocErrors(response.status(), AsyncMutateInBuilder.this.docId, spec.path());
                        if (SubdocHelper.isSubdocLevelError(status)) {
                            throw new MultiMutationException(0, status, Collections.singletonList(spec), subdocError);
                        }
                        throw subdocError;
                        finally {
                            if (AsyncMutateInBuilder.this.environment.operationTracingEnabled()) {
                                AsyncMutateInBuilder.this.environment.tracer().scopeManager().activate(response.request().span(), true).close();
                            }
                        }
                    }
                }), (CouchbaseRequest)request, AsyncMutateInBuilder.this.environment, timeout, timeUnit);
            }
        });
    }

    private <T> Observable<DocumentFragment<T>> subdocObserveMutation(Observable<DocumentFragment<T>> mutation, final long timeout, final TimeUnit timeUnit) {
        if (this.persistTo == PersistTo.NONE && this.replicateTo == ReplicateTo.NONE) {
            return mutation;
        }
        return mutation.flatMap(new Func1<DocumentFragment<T>, Observable<DocumentFragment<T>>>(){

            public Observable<DocumentFragment<T>> call(final DocumentFragment<T> frag) {
                Observable result = Observe.call((ClusterFacade)AsyncMutateInBuilder.this.core, (String)AsyncMutateInBuilder.this.bucketName, (String)frag.id(), (long)frag.cas(), (boolean)false, (MutationToken)frag.mutationToken(), (Observe.PersistTo)AsyncMutateInBuilder.this.persistTo.value(), (Observe.ReplicateTo)AsyncMutateInBuilder.this.replicateTo.value(), (Delay)AsyncMutateInBuilder.this.environment.observeIntervalDelay(), (RetryStrategy)AsyncMutateInBuilder.this.environment.retryStrategy()).map(new Func1<Boolean, DocumentFragment<T>>(){

                    public DocumentFragment<T> call(Boolean aBoolean) {
                        return frag;
                    }
                }).onErrorResumeNext(new Func1<Throwable, Observable<DocumentFragment<T>>>(){

                    public Observable<DocumentFragment<T>> call(Throwable throwable) {
                        return Observable.error((Throwable)((Object)new DurabilityException("Durability requirement failed: " + throwable.getMessage(), throwable)));
                    }
                });
                if (timeout > 0L) {
                    result = result.timeout(timeout, timeUnit, AsyncMutateInBuilder.this.environment.scheduler());
                }
                return result;
            }
        });
    }

    private static void releaseAll(List<ByteBuf> byteBufs) {
        for (ByteBuf byteBuf : byteBufs) {
            if (byteBuf == null || byteBuf.refCnt() <= 0) continue;
            byteBuf.release();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("mutateIn(").append(this.docId);
        if (this.expiry != 0) {
            sb.append(", expiry=").append(this.expiry);
        }
        if (this.cas != 0L) {
            sb.append(", cas=").append(this.cas);
        }
        if (this.persistTo != PersistTo.NONE) {
            sb.append(", persistTo=").append((Object)this.persistTo);
        }
        if (this.replicateTo != ReplicateTo.NONE) {
            sb.append(", replicateTo=").append((Object)this.replicateTo);
        }
        sb.append(")[");
        int pos = sb.length();
        for (MutationSpec mutationSpec : this.mutationSpecs) {
            sb.append(", ").append(mutationSpec);
        }
        sb.delete(pos, pos + 2);
        sb.append(']');
        return sb.toString();
    }
}

