/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.http;

import com.couchbase.client.java.http.NameValuePair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class NameValuePairs {
    final String urlEncoded;

    private NameValuePairs(String urlEncoded) {
        this.urlEncoded = Objects.requireNonNull(urlEncoded);
    }

    public static NameValuePairs of(Map<String, ?> map) {
        ArrayList<NameValuePair> pairs = new ArrayList<NameValuePair>();
        map.forEach((key, value) -> pairs.add(NameValuePair.nv(key, value)));
        return NameValuePairs.of(pairs);
    }

    public static NameValuePairs of(NameValuePair ... pairs) {
        return NameValuePairs.of(Arrays.asList(pairs));
    }

    public static NameValuePairs of(List<NameValuePair> pairs) {
        return new NameValuePairs(pairs.stream().map(pair -> pair.urlEncoded).collect(Collectors.joining("&")));
    }

    public static NameValuePairs ofPreEncoded(String preEncoded) {
        return new NameValuePairs(preEncoded);
    }

    public String toString() {
        return this.urlEncoded;
    }
}

