/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.AbstractCompoundQuery;

public class DisjunctionQuery
extends AbstractCompoundQuery {
    private int min = -1;

    public DisjunctionQuery(SearchQuery ... queries) {
        super(queries);
    }

    @Override
    public DisjunctionQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    public DisjunctionQuery min(int min) {
        this.min = min;
        return this;
    }

    public DisjunctionQuery or(SearchQuery ... queries) {
        super.addAll(queries);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.childQueries.isEmpty()) {
            throw InvalidArgumentException.fromMessage((String)"Compound query has no child query");
        }
        if (this.childQueries.size() < this.min) {
            throw InvalidArgumentException.fromMessage((String)("Disjunction query as fewer children than the configured minimum " + this.min));
        }
        if (this.min > 0) {
            input.put("min", this.min);
        }
        JsonArray disjuncts = JsonArray.create();
        for (SearchQuery childQuery : this.childQueries) {
            JsonObject childJson = JsonObject.create();
            childQuery.injectParamsAndBoost(childJson);
            disjuncts.add(childJson);
        }
        input.put("disjuncts", disjuncts);
    }
}

