/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.msg.kv.DecrementRequest;
import com.couchbase.client.core.msg.kv.IncrementRequest;
import com.couchbase.client.core.msg.kv.KeyValueRequest;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CounterAccessor {
    public static CompletableFuture<CounterResult> increment(Core core, IncrementRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send((Request)request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CounterResult(response.cas(), response.value(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, false);
    }

    public static CompletableFuture<CounterResult> decrement(Core core, DecrementRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send((Request)request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new CounterResult(response.cas(), response.value(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException((KeyValueRequest)request, (Response)response);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, false);
    }
}

