/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryMetaData;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Volatile
public class ReactiveQueryResult {
    private final QueryResponse response;
    private final JsonSerializer serializer;

    @Stability.Internal
    public ReactiveQueryResult(QueryResponse response, JsonSerializer serializer) {
        this.response = response;
        this.serializer = serializer;
    }

    public Flux<JsonObject> rowsAsObject() {
        return this.rowsAs(JsonObject.class);
    }

    public <T> Flux<T> rowsAs(Class<T> target) {
        return this.response.rows().map(n -> this.serializer.deserialize(target, n.data()));
    }

    public <T> Flux<T> rowsAs(TypeRef<T> target) {
        return this.response.rows().map(n -> this.serializer.deserialize(target, n.data()));
    }

    public Mono<QueryMetaData> metaData() {
        return this.response.trailer().map(t -> QueryMetaData.from(this.response.header(), t));
    }
}

