/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.queries.MatchOperator;

public class MatchQuery
extends SearchQuery {
    private final String match;
    private String field;
    private String analyzer;
    private Integer prefixLength;
    private Integer fuzziness;
    private MatchOperator operator;

    public MatchQuery(String match) {
        this.match = match;
    }

    @Override
    public MatchQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    public MatchQuery field(String field) {
        this.field = field;
        return this;
    }

    public MatchQuery analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public MatchQuery prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public MatchQuery fuzziness(int fuzziness) {
        this.fuzziness = fuzziness;
        return this;
    }

    public MatchQuery operator(MatchOperator operator) {
        this.operator = operator;
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        input.put("match", this.match);
        if (this.field != null) {
            input.put("field", this.field);
        }
        if (this.analyzer != null) {
            input.put("analyzer", this.analyzer);
        }
        if (this.prefixLength != null) {
            input.put("prefix_length", this.prefixLength);
        }
        if (this.fuzziness != null) {
            input.put("fuzziness", this.fuzziness);
        }
        if (this.operator != null) {
            input.put("operator", this.operator.toString());
        }
    }
}

