/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.encryption.databind.jackson.repackaged;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.Version;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.BeanProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.Module;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.couchbase.client.core.encryption.CryptoManager;
import com.couchbase.client.core.util.CbAnnotations;
import com.couchbase.client.java.encryption.databind.jackson.repackaged.EncryptedFieldDeserializationModifier;
import com.couchbase.client.java.encryption.databind.jackson.repackaged.EncryptedFieldSerializationModifier;
import java.lang.annotation.Annotation;
import java.util.Objects;

@Stability.Internal
public class RepackagedEncryptionModule
extends Module {
    private final CryptoManager cryptoManager;

    public RepackagedEncryptionModule(CryptoManager cryptoManager) {
        this.cryptoManager = Objects.requireNonNull(cryptoManager);
    }

    public String getModuleName() {
        return "CouchbaseEncryption";
    }

    public Version version() {
        return new Version(1, 0, 0, null, "com.couchbase", this.getModuleName());
    }

    public void setupModule(Module.SetupContext context) {
        context.addBeanSerializerModifier((BeanSerializerModifier)new EncryptedFieldSerializationModifier(this.cryptoManager));
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new EncryptedFieldDeserializationModifier(this.cryptoManager));
    }

    static <T extends Annotation> T findAnnotation(BeanProperty prop, Class<T> annotationClass) {
        for (Annotation a : prop.getMember().getAllAnnotations().annotations()) {
            Annotation match = CbAnnotations.findAnnotation((Annotation)a, annotationClass);
            if (match == null) continue;
            return (T)match;
        }
        return null;
    }
}

