/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreSubdocGetResult;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class LookupInResult {
    private final CoreSubdocGetResult core;
    private final JsonSerializer serializer;

    @Stability.Internal
    public LookupInResult(CoreSubdocGetResult core, JsonSerializer serializer) {
        this.core = Objects.requireNonNull(core);
        this.serializer = Objects.requireNonNull(serializer);
    }

    public long cas() {
        return this.core.cas();
    }

    public <T> T contentAs(int index, Class<T> target) {
        return this.serializer.deserialize(target, this.contentAsBytes(index));
    }

    public <T> T contentAs(int index, TypeRef<T> target) {
        return this.serializer.deserialize(target, this.contentAsBytes(index));
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes(int index) {
        SubDocumentField field = this.core.field(index);
        if (field.type() == SubdocCommandType.EXISTS) {
            boolean exists = this.core.exists(index);
            if (!exists) {
                field.throwErrorIfPresent();
            }
            return String.valueOf(exists).getBytes(StandardCharsets.UTF_8);
        }
        field.throwErrorIfPresent();
        return field.value();
    }

    public JsonObject contentAsObject(int index) {
        return this.contentAs(index, JsonObject.class);
    }

    public JsonArray contentAsArray(int index) {
        return this.contentAs(index, JsonArray.class);
    }

    public boolean exists(int index) {
        try {
            return this.core.exists(index);
        }
        catch (CouchbaseException e) {
            return false;
        }
    }

    @Stability.Internal
    public boolean isDeleted() {
        return this.core.tombstone();
    }

    public String toString() {
        return "LookupInResult{core=" + this.core + ", serializer=" + this.serializer + '}';
    }
}

