/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.handler.source;

import com.couchbase.connect.kafka.handler.source.DocumentEvent;
import com.couchbase.connect.kafka.handler.source.SourceHandler;
import com.couchbase.connect.kafka.handler.source.SourceHandlerParams;
import com.couchbase.connect.kafka.handler.source.SourceRecordBuilder;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import org.apache.kafka.connect.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawJsonSourceHandler
implements SourceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawJsonSourceHandler.class);
    private static final JsonFactory jsonFactory = new JsonFactory();

    protected static boolean isValidJson(byte[] bytes) {
        try {
            JsonToken token;
            JsonToken decrementDepthToken;
            JsonToken incrementDepthToken;
            JsonParser parser = jsonFactory.createParser(bytes);
            JsonToken firstToken = parser.nextToken();
            if (firstToken == JsonToken.START_OBJECT) {
                incrementDepthToken = JsonToken.START_OBJECT;
                decrementDepthToken = JsonToken.END_OBJECT;
            } else if (firstToken == JsonToken.START_ARRAY) {
                incrementDepthToken = JsonToken.START_ARRAY;
                decrementDepthToken = JsonToken.END_ARRAY;
            } else {
                return firstToken != null && parser.nextToken() == null;
            }
            int depth = 1;
            while ((token = parser.nextToken()) != null) {
                if (token == incrementDepthToken) {
                    ++depth;
                    continue;
                }
                if (token != decrementDepthToken || --depth != 0 || parser.nextToken() == null) continue;
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    @Override
    public SourceRecordBuilder handle(SourceHandlerParams params) {
        SourceRecordBuilder builder = new SourceRecordBuilder();
        if (!this.passesFilter(params)) {
            return null;
        }
        if (!this.buildValue(params, builder)) {
            return null;
        }
        return builder.topic(this.getTopic(params)).key(Schema.STRING_SCHEMA, params.documentEvent().key());
    }

    protected boolean passesFilter(SourceHandlerParams params) {
        return true;
    }

    protected boolean buildValue(SourceHandlerParams params, SourceRecordBuilder builder) {
        DocumentEvent docEvent = params.documentEvent();
        DocumentEvent.Type type = docEvent.type();
        switch (type) {
            case EXPIRATION: 
            case DELETION: {
                builder.value(null, null);
                return true;
            }
            case MUTATION: {
                if (params.noValue()) {
                    builder.value(null, null);
                    return true;
                }
                byte[] document = docEvent.content();
                if (!RawJsonSourceHandler.isValidJson(document)) {
                    LOGGER.warn("Skipping non-JSON document: bucket={} key={}", (Object)docEvent.bucket(), (Object)docEvent.qualifiedKey());
                    return false;
                }
                builder.value(null, document);
                return true;
            }
        }
        LOGGER.warn("unexpected event type {}", (Object)type);
        return false;
    }

    protected String getTopic(SourceHandlerParams params) {
        return null;
    }
}

