/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.connect.kafka.util.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.connect.kafka.util.config.AbstractInvocationHandler;
import com.couchbase.connect.kafka.util.config.DataSize;
import com.couchbase.connect.kafka.util.config.DataSizeParser;
import com.couchbase.connect.kafka.util.config.DataSizeValidator;
import com.couchbase.connect.kafka.util.config.DurationParser;
import com.couchbase.connect.kafka.util.config.DurationValidator;
import com.couchbase.connect.kafka.util.config.EnumRecommender;
import com.couchbase.connect.kafka.util.config.EnumValidator;
import com.couchbase.connect.kafka.util.config.HtmlRenderer;
import com.couchbase.connect.kafka.util.config.annotation.Default;
import com.couchbase.connect.kafka.util.config.annotation.Dependents;
import com.couchbase.connect.kafka.util.config.annotation.DisplayName;
import com.couchbase.connect.kafka.util.config.annotation.EnvironmentVariable;
import com.couchbase.connect.kafka.util.config.annotation.Group;
import com.couchbase.connect.kafka.util.config.annotation.Importance;
import com.couchbase.connect.kafka.util.config.annotation.Width;
import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.OtherJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigProxyFactory.class);
    protected final String prefix;
    protected final Map<Class<?>, CustomTypeHandler<?>> customTypeMap = new HashMap();
    protected final Map<Class<?>, ConfigDef.Type> javaClassToKafkaType = new HashMap();
    Function<String, String> environmentVariableAccessor = System::getenv;

    public KafkaConfigProxyFactory(String prefix) {
        this.prefix = prefix.isEmpty() ? "" : (prefix.endsWith(".") ? prefix : prefix + ".");
        this.initTypeMap();
        this.register(Duration.class, new CustomTypeHandler<Duration>(){

            @Override
            public Duration valueOf(String value) {
                return DurationParser.parseDuration(value);
            }

            @Override
            public ConfigDef.Validator validator() {
                return new DurationValidator();
            }
        });
        this.register(DataSize.class, new CustomTypeHandler<DataSize>(){

            @Override
            public DataSize valueOf(String value) {
                return DataSizeParser.parseDataSize(value);
            }

            @Override
            public ConfigDef.Validator validator() {
                return new DataSizeValidator();
            }
        });
    }

    public <T> KafkaConfigProxyFactory register(Class<T> customType, CustomTypeHandler<T> handler) {
        this.customTypeMap.put(customType, handler);
        this.javaClassToKafkaType.put(customType, ConfigDef.Type.STRING);
        return this;
    }

    public <T> ConfigDef define(Class<T> configInterface) {
        return this.define(configInterface, new ConfigDef());
    }

    public <T> ConfigDef define(Class<T> configInterface, ConfigDef def) {
        for (Method method : configInterface.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            this.validateReturnType(method);
            def.define(new ConfigDef.ConfigKey(this.getConfigKeyName(method), this.getKafkaType(method), this.getDefaultValue(method), this.getValidator(method), this.getImportance(method), this.getDocumentation(method), this.getGroup(method), this.getOrderInGroup(method), this.getWidth(method), this.getDisplayName(method), this.getDependents(method), this.getRecommender(method), false));
        }
        return def;
    }

    public <T> T newProxy(Class<T> configInterface, Map<String, String> properties) {
        return this.newProxy(configInterface, properties, true);
    }

    public <T> T newProxy(Class<T> configInterface, Map<String, String> properties, boolean doLog) {
        ConfigDef configDef = this.define(configInterface, new ConfigDef());
        final ConcreteKafkaConfig kafkaConfig = new ConcreteKafkaConfig(configDef, properties, doLog);
        return configInterface.cast(Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new AbstractInvocationHandler(configInterface.getName()){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) {
                String configKeyName = KafkaConfigProxyFactory.this.getConfigKeyName(method);
                Object result = KafkaConfigProxyFactory.this.getValueFromEnvironmentVariable(configKeyName, method).orElse(kafkaConfig.get(configKeyName));
                return KafkaConfigProxyFactory.this.postProcessValue(method, result);
            }
        }));
    }

    public <T> String keyName(Class<T> configInterface, Consumer<T> methodInvoker) {
        try {
            T instance = this.newProxyForKeyNames(configInterface);
            methodInvoker.accept(instance);
            throw new IllegalArgumentException("Consumer should have invoked a method of the config interface.");
        }
        catch (KeyNameHolderException e) {
            return e.name;
        }
    }

    protected <T> T newProxyForKeyNames(Class<T> configInterface) {
        return configInterface.cast(Proxy.newProxyInstance(configInterface.getClassLoader(), new Class[]{configInterface}, (InvocationHandler)new AbstractInvocationHandler(configInterface.getName()){

            @Override
            protected Object doInvoke(Object proxy, Method method, Object[] args) {
                throw new KeyNameHolderException(KafkaConfigProxyFactory.this.getConfigKeyName(method));
            }
        }));
    }

    protected Object postProcessValue(Method method, Object value) {
        Class<?> javaType = method.getReturnType();
        CustomTypeHandler<?> customTypeHandler = this.customTypeMap.get(javaType);
        if (customTypeHandler != null) {
            return customTypeHandler.valueOf((String)value);
        }
        if (javaType.isEnum()) {
            return this.parseEnum(javaType, (String)value);
        }
        return value;
    }

    protected String getEnv(String environmentVariableName) {
        return this.environmentVariableAccessor.apply(environmentVariableName);
    }

    protected Optional<Object> getValueFromEnvironmentVariable(String configKeyName, Method method) {
        String envarName = this.getEnvironmentVariableName(method).orElse(null);
        if (envarName != null) {
            String envarValue = this.getEnv(envarName);
            if (envarValue != null) {
                log.info("Reading value for '{}' from environment variable '{}'", (Object)configKeyName, (Object)envarName);
                return Optional.of(ConfigDef.parseType((String)configKeyName, (Object)envarValue, (ConfigDef.Type)this.getKafkaType(method)));
            }
            log.debug("Environment variable '{}' not set.", (Object)envarName);
        }
        return Optional.empty();
    }

    protected void initTypeMap() {
        this.javaClassToKafkaType.put(Boolean.class, ConfigDef.Type.BOOLEAN);
        this.javaClassToKafkaType.put(Boolean.TYPE, ConfigDef.Type.BOOLEAN);
        this.javaClassToKafkaType.put(String.class, ConfigDef.Type.STRING);
        this.javaClassToKafkaType.put(Integer.class, ConfigDef.Type.INT);
        this.javaClassToKafkaType.put(Integer.TYPE, ConfigDef.Type.INT);
        this.javaClassToKafkaType.put(Short.class, ConfigDef.Type.SHORT);
        this.javaClassToKafkaType.put(Short.TYPE, ConfigDef.Type.SHORT);
        this.javaClassToKafkaType.put(Long.class, ConfigDef.Type.LONG);
        this.javaClassToKafkaType.put(Long.TYPE, ConfigDef.Type.LONG);
        this.javaClassToKafkaType.put(Double.class, ConfigDef.Type.DOUBLE);
        this.javaClassToKafkaType.put(Double.TYPE, ConfigDef.Type.DOUBLE);
        this.javaClassToKafkaType.put(List.class, ConfigDef.Type.LIST);
        this.javaClassToKafkaType.put(Class.class, ConfigDef.Type.CLASS);
        this.javaClassToKafkaType.put(Password.class, ConfigDef.Type.PASSWORD);
    }

    protected void validateReturnType(Method method) {
        if (method.getReturnType().equals(List.class) && !KafkaConfigProxyFactory.hasParameters(method.getGenericReturnType(), new Type[]{String.class})) {
            throw new RuntimeException("Method " + method + " has unsupported return type; For lists, only List<String> is supported.");
        }
    }

    protected List<String> getDependents(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, Dependents.class).map(a -> Arrays.asList(a.value())).orElse(Collections.emptyList());
    }

    protected String getDisplayName(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, DisplayName.class).map(DisplayName::value).orElseGet(() -> this.getDefaultDisplayName(method));
    }

    private String getDefaultDisplayName(Method method) {
        String name = KafkaConfigProxyFactory.insertSpacesBeforeCapitals(method.getName());
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    protected String getGroup(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, Group.class).map(Group::value).orElseGet(() -> this.getDefaultGroup(method));
    }

    protected String getDefaultGroup(Method method) {
        return KafkaConfigProxyFactory.insertSpacesBeforeCapitals(KafkaConfigProxyFactory.removeSuffix(method.getDeclaringClass().getSimpleName(), "Config"));
    }

    protected List<String> since(MethodJavadoc methodJavadoc) {
        ArrayList<String> result = new ArrayList<String>();
        for (OtherJavadoc other : methodJavadoc.getOther()) {
            if (!"since".equals(other.getName())) continue;
            result.add(other.getComment().toString());
        }
        return result;
    }

    protected Optional<String> deprecated(MethodJavadoc methodJavadoc) {
        for (OtherJavadoc other : methodJavadoc.getOther()) {
            if (!"deprecated".equals(other.getName())) continue;
            return Optional.of(other.getComment().toString());
        }
        return Optional.empty();
    }

    protected String getDocumentation(Method method) {
        StringBuilder javadoc = new StringBuilder();
        MethodJavadoc methodJavadoc = RuntimeJavadoc.getJavadoc((Method)method);
        javadoc.append(methodJavadoc.getComment().toString());
        this.getEnvironmentVariableName(method).ifPresent(envar -> javadoc.append("<p>May be overridden with the " + envar + " environment variable."));
        Stability.Uncommitted uncommitted = method.getAnnotation(Stability.Uncommitted.class);
        if (uncommitted != null) {
            javadoc.append("<p>UNCOMMITTED; this feature may change in a patch release without notice.");
        }
        this.deprecated(methodJavadoc).ifPresent(message -> javadoc.append("<p>WARNING: *DEPRECATED.* " + message));
        List<String> since = this.since(methodJavadoc);
        if (!since.isEmpty()) {
            javadoc.append("<p>* Since: " + String.join((CharSequence)", ", since));
        }
        return HtmlRenderer.htmlToPlaintext(javadoc.toString());
    }

    protected Optional<String> getEnvironmentVariableName(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, EnvironmentVariable.class).map(EnvironmentVariable::value);
    }

    protected int getOrderInGroup(Method method) {
        ClassJavadoc doc = RuntimeJavadoc.getJavadoc(method.getDeclaringClass());
        int i = 0;
        for (MethodJavadoc methodJavadoc : doc.getMethods()) {
            ++i;
            if (!methodJavadoc.matches(method)) continue;
            return i;
        }
        return -1;
    }

    private static Object invokeCompanion(Method method, String suffix) {
        try {
            Method companion = method.getDeclaringClass().getDeclaredMethod(method.getName() + suffix, new Class[0]);
            if (!Modifier.isStatic(companion.getModifiers())) {
                throw new RuntimeException("Companion method " + method.getName() + suffix + "() must be static.");
            }
            return companion.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke " + suffix + " companion method for " + method, e);
        }
    }

    protected ConfigDef.Recommender getRecommender(Method method) {
        ConfigDef.Recommender userProvided = (ConfigDef.Recommender)KafkaConfigProxyFactory.invokeCompanion(method, "Recommender");
        if (userProvided != null) {
            return userProvided;
        }
        return this.getDefaultRecommender(method);
    }

    protected ConfigDef.Recommender getDefaultRecommender(Method method) {
        ConfigDef.Recommender v;
        CustomTypeHandler<?> customTypeHandler = this.customTypeMap.get(method.getReturnType());
        if (customTypeHandler != null && (v = customTypeHandler.recommender()) != null) {
            return v;
        }
        if (method.getReturnType().isEnum()) {
            return new EnumRecommender(method.getReturnType());
        }
        return null;
    }

    protected ConfigDef.Validator getValidator(Method method) {
        ConfigDef.Validator userProvided = (ConfigDef.Validator)KafkaConfigProxyFactory.invokeCompanion(method, "Validator");
        if (userProvided != null) {
            return userProvided;
        }
        return this.getDefaultValidator(method);
    }

    protected ConfigDef.Validator getDefaultValidator(Method method) {
        ConfigDef.Validator v;
        CustomTypeHandler<?> customTypeHandler = this.customTypeMap.get(method.getReturnType());
        if (customTypeHandler != null && (v = customTypeHandler.validator()) != null) {
            return v;
        }
        if (method.getReturnType().isEnum()) {
            return new EnumValidator(method.getReturnType());
        }
        return null;
    }

    protected Object getDefaultValue(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, Default.class).map(a -> a.value()).orElse(ConfigDef.NO_DEFAULT_VALUE);
    }

    protected ConfigDef.Type getKafkaType(Method method) {
        Class<?> returnType = method.getReturnType();
        ConfigDef.Type kafkaType = this.javaClassToKafkaType.get(returnType);
        if (kafkaType != null) {
            return kafkaType;
        }
        if (returnType.isEnum()) {
            return ConfigDef.Type.STRING;
        }
        throw new RuntimeException("Method " + method + " has unsupported return type.");
    }

    protected static <T extends Annotation> Optional<T> getAnnotation(Method method, Class<T> annotationClass) {
        T annotation = method.getAnnotation(annotationClass);
        if (annotation != null) {
            return Optional.of(annotation);
        }
        return Optional.ofNullable(method.getDeclaringClass().getAnnotation(annotationClass));
    }

    protected String getConfigKeyName(Method method) {
        return this.prefix + KafkaConfigProxyFactory.lowerCamelCaseToDottedLowerCase(method.getName());
    }

    protected static String lowerCamelCaseToDottedLowerCase(String name) {
        return name.replaceAll("(\\p{javaUpperCase})", ".$1").toLowerCase(Locale.ROOT);
    }

    protected ConfigDef.Width getWidth(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, Width.class).map(Width::value).orElse(ConfigDef.Width.NONE);
    }

    protected ConfigDef.Importance getImportance(Method method) {
        return KafkaConfigProxyFactory.getAnnotation(method, Importance.class).map(Importance::value).orElse(ConfigDef.Importance.MEDIUM);
    }

    protected Enum<?> parseEnum(Class<?> enumClass, String value) {
        return Enum.valueOf(enumClass, value);
    }

    protected static String insertSpacesBeforeCapitals(String s) {
        return s.replaceAll("(\\p{javaUpperCase})", " $1").trim();
    }

    protected static String removeSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    protected static boolean hasParameters(Type t, Type ... paramTypes) {
        if (!(t instanceof ParameterizedType)) {
            return false;
        }
        return Arrays.equals(((ParameterizedType)t).getActualTypeArguments(), paramTypes);
    }

    public static interface CustomTypeHandler<T> {
        public T valueOf(String var1);

        default public ConfigDef.Validator validator() {
            return null;
        }

        default public ConfigDef.Recommender recommender() {
            return null;
        }
    }

    public static class ConcreteKafkaConfig
    extends AbstractConfig {
        public ConcreteKafkaConfig(ConfigDef definition, Map<?, ?> originals, boolean doLog) {
            super(definition, originals, doLog);
        }

        public Object get(String key) {
            return super.get(key);
        }
    }

    protected static class KeyNameHolderException
    extends RuntimeException {
        private final String name;

        public KeyNameHolderException(String name) {
            super(name);
            this.name = Objects.requireNonNull(name);
        }
    }
}

