/*
 * Decompiled with CFR 0.152.
 */
package com.crittercism.app;

import android.content.Context;
import crittercism.android.du;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CrittercismNDK {
    private static boolean isNdkInstalled = false;
    private static final String LIBRARY_NAME = "64libcrittercism-v3";
    private static final String DST_SO_FILE_NAME = "lib64libcrittercism-v3.so";
    private static final String ASSET_SO_FILE_NAME = "lib64libcrittercism-v3.crt";
    private static final String[] LEGACY_SO_FILE_NAMES = new String[]{"libcrittercism-ndk.so", "libcrittercism-v3.so"};

    public static native boolean installNdk(String var0);

    public static File getInstalledLibraryFile(Context c2) {
        String string = c2.getFilesDir().getAbsolutePath() + "/com.crittercism/lib/";
        return new File(string + DST_SO_FILE_NAME);
    }

    public static void installNdkLib(Context context, String nativeDumpPath) {
        boolean bl2;
        String string = context.getFilesDir().getAbsolutePath() + "/" + nativeDumpPath;
        if (CrittercismNDK.doNdkSharedLibrariesExist(context)) {
            bl2 = CrittercismNDK.loadLibraryFromAssets(context);
        } else {
            try {
                System.loadLibrary(LIBRARY_NAME);
                bl2 = true;
            }
            catch (Throwable throwable) {
                bl2 = false;
            }
        }
        if (!bl2) {
            return;
        }
        try {
            if (CrittercismNDK.installNdk(string)) {
                new File(string).mkdirs();
                isNdkInstalled = true;
                return;
            }
            du.b("Unable to initialize NDK crash reporting.");
            return;
        }
        catch (Throwable throwable) {
            du.a(throwable);
            return;
        }
    }

    public static boolean loadLibraryFromAssets(Context context) {
        int n2;
        File file = new File(context.getFilesDir(), "/com.crittercism/lib/");
        File file2 = new File(file, DST_SO_FILE_NAME);
        if (!file2.exists()) {
            if (!CrittercismNDK.copyLibFromAssets(context, file2)) {
                file2.delete();
                return false;
            }
            for (n2 = 0; n2 < LEGACY_SO_FILE_NAMES.length; ++n2) {
                File file3 = new File(file, LEGACY_SO_FILE_NAMES[n2]);
                String string = file3.exists() ? "deleting" : "not found";
                du.d("legacy lib: " + file3.getAbsolutePath() + ": " + string);
                file3.delete();
            }
        }
        n2 = 0;
        try {
            System.load(file2.getAbsolutePath());
            n2 = 1;
        }
        catch (Throwable throwable) {
            du.a("Unable to install NDK library: " + throwable.getMessage());
            du.a(throwable);
            file2.delete();
        }
        return n2 != 0;
    }

    public static boolean doNdkSharedLibrariesExist(Context context) {
        boolean bl2 = false;
        try {
            CrittercismNDK.getJarredLibFileStream(context);
            bl2 = true;
        }
        catch (IOException iOException) {
            du.c("doNdkSharedLibrariesExist: ", iOException);
        }
        return bl2;
    }

    public static InputStream getJarredLibFileStream(Context context) {
        String string = "armeabi";
        String string2 = System.getProperty("os.arch");
        du.d("getJarredLibFileStream: os.arch: " + string2);
        if (string2.contains("v7")) {
            string = string + "-v7a";
        } else if (string2.equals("aarch64")) {
            string = "arm64-v8a";
        }
        String string3 = string + "/lib64libcrittercism-v3.crt";
        du.d("getJarredLibFileStream: openning input stream from: " + string3);
        return context.getAssets().open(string3);
    }

    public static boolean copyLibFromAssets(Context context, File installedLibFile) {
        try {
            int n2;
            File file = installedLibFile.getParentFile();
            du.d("copyLibFromAssets: creating dir: " + file.getAbsolutePath());
            file.mkdirs();
            du.d("copyLibFromAssets: installing library into: " + installedLibFile.getAbsolutePath());
            FileOutputStream fileOutputStream = new FileOutputStream(installedLibFile);
            InputStream inputStream = CrittercismNDK.getJarredLibFileStream(context);
            byte[] byArray = new byte[8192];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                fileOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            fileOutputStream.close();
            du.d("copyLibFromAssets: successful");
        }
        catch (Exception exception) {
            du.a("Could not install breakpad library: " + exception.toString());
            return false;
        }
        return true;
    }

    public static boolean isNdkCrashReportingInstalled() {
        return isNdkInstalled;
    }
}

