/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.core;

import com.ctrip.framework.apollo.core.enums.Env;
import com.ctrip.framework.apollo.core.spi.MetaServerProvider;
import com.ctrip.framework.apollo.core.utils.ApolloThreadFactory;
import com.ctrip.framework.apollo.core.utils.DeferredLoggerFactory;
import com.ctrip.framework.apollo.core.utils.NetUtil;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.tracer.spi.Transaction;
import com.ctrip.framework.foundation.internals.ServiceBootstrap;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;

public class MetaDomainConsts {
    public static final String DEFAULT_META_URL = "http://apollo.meta";
    private static final Map<Env, String> metaServerAddressCache = Maps.newConcurrentMap();
    private static volatile List<MetaServerProvider> metaServerProviders = null;
    private static final long REFRESH_INTERVAL_IN_SECOND = 60L;
    private static final Logger logger = DeferredLoggerFactory.getLogger(MetaDomainConsts.class);
    private static final Map<String, String> selectedMetaServerAddressCache = Maps.newConcurrentMap();
    private static final AtomicBoolean periodicRefreshStarted = new AtomicBoolean(false);
    private static final Object LOCK = new Object();

    public static String getDomain(Env env) {
        String metaServerAddress = MetaDomainConsts.getMetaServerAddress(env);
        if (metaServerAddress.contains(",")) {
            return MetaDomainConsts.selectMetaServerAddress(metaServerAddress);
        }
        return metaServerAddress;
    }

    public static String getMetaServerAddress(Env env) {
        if (!metaServerAddressCache.containsKey((Object)env)) {
            MetaDomainConsts.initMetaServerAddress(env);
        }
        return metaServerAddressCache.get((Object)env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initMetaServerAddress(Env env) {
        if (metaServerProviders == null) {
            Object object = LOCK;
            synchronized (object) {
                if (metaServerProviders == null) {
                    metaServerProviders = MetaDomainConsts.initMetaServerProviders();
                }
            }
        }
        String metaAddress = null;
        for (MetaServerProvider provider : metaServerProviders) {
            metaAddress = provider.getMetaServerAddress(env);
            if (Strings.isNullOrEmpty((String)metaAddress)) continue;
            logger.info("Located meta server address {} for env {} from {}", new Object[]{metaAddress, env, provider.getClass().getName()});
            break;
        }
        if (Strings.isNullOrEmpty(metaAddress)) {
            metaAddress = DEFAULT_META_URL;
            logger.warn("Meta server address fallback to {} for env {}, because it is not available in all MetaServerProviders", (Object)metaAddress, (Object)env);
        }
        metaServerAddressCache.put(env, metaAddress.trim());
    }

    private static List<MetaServerProvider> initMetaServerProviders() {
        Iterator<MetaServerProvider> metaServerProviderIterator = ServiceBootstrap.loadAll(MetaServerProvider.class);
        ArrayList metaServerProviders = Lists.newArrayList(metaServerProviderIterator);
        Collections.sort(metaServerProviders, new Comparator<MetaServerProvider>(){

            @Override
            public int compare(MetaServerProvider o1, MetaServerProvider o2) {
                return Integer.compare(o1.getOrder(), o2.getOrder());
            }
        });
        return metaServerProviders;
    }

    private static String selectMetaServerAddress(String metaServerAddresses) {
        String metaAddressSelected = selectedMetaServerAddressCache.get(metaServerAddresses);
        if (metaAddressSelected == null) {
            if (periodicRefreshStarted.compareAndSet(false, true)) {
                MetaDomainConsts.schedulePeriodicRefresh();
            }
            MetaDomainConsts.updateMetaServerAddresses(metaServerAddresses);
            metaAddressSelected = selectedMetaServerAddressCache.get(metaServerAddresses);
        }
        return metaAddressSelected;
    }

    private static void updateMetaServerAddresses(String metaServerAddresses) {
        logger.debug("Selecting meta server address for: {}", (Object)metaServerAddresses);
        Transaction transaction = Tracer.newTransaction("Apollo.MetaService", "refreshMetaServerAddress");
        transaction.addData("Url", metaServerAddresses);
        try {
            ArrayList metaServers = Lists.newArrayList((Object[])metaServerAddresses.split(","));
            Collections.shuffle(metaServers);
            boolean serverAvailable = false;
            for (String address : metaServers) {
                if (!NetUtil.pingUrl((address = address.trim()) + "/services/config")) continue;
                selectedMetaServerAddressCache.put(metaServerAddresses, address);
                serverAvailable = true;
                logger.debug("Selected meta server address {} for {}", (Object)address, (Object)metaServerAddresses);
                break;
            }
            if (!selectedMetaServerAddressCache.containsKey(metaServerAddresses)) {
                selectedMetaServerAddressCache.put(metaServerAddresses, ((String)metaServers.get(0)).trim());
            }
            if (!serverAvailable) {
                logger.warn("Could not find available meta server for configured meta server addresses: {}, fallback to: {}", (Object)metaServerAddresses, (Object)selectedMetaServerAddressCache.get(metaServerAddresses));
            }
            transaction.setStatus("0");
        }
        catch (Throwable ex) {
            transaction.setStatus(ex);
            throw ex;
        }
        finally {
            transaction.complete();
        }
    }

    private static void schedulePeriodicRefresh() {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, ApolloThreadFactory.create("MetaServiceLocator", true));
        scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String metaServerAddresses : selectedMetaServerAddressCache.keySet()) {
                        MetaDomainConsts.updateMetaServerAddresses(metaServerAddresses);
                    }
                }
                catch (Throwable ex) {
                    logger.warn(String.format("Refreshing meta server address failed, will retry in %d seconds", 60L), ex);
                }
            }
        }, 60L, 60L, TimeUnit.SECONDS);
    }
}

