/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.dbaccess;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.dbaccess.DmMsgRecv;
import dm.jdbc.dbaccess.DmMsgSend;
import dm.jdbc.dbaccess.DmdbCSI;
import dm.jdbc.dbaccess.Request_Response;
import dm.jdbc.dbaccess.RwCounter;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.driver.DmdbStatement_bs;
import dm.jdbc.log.ILogger;
import dm.jdbc.log.LogFactory;
import dm.jdbc.processor.RwStandbyRecoverThread;
import dm.jdbc.util.StringUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;

public class DmdbRwAutoDistribute {
    static ILogger LOG = LogFactory.getLog(DmdbRwAutoDistribute.class);
    private static Boolean rwMapMutex = new Boolean(true);
    private static HashMap<String, RwCounter> rwMap = new HashMap();

    public static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        short cmdType = msg.req_get_cmd();
        DmMsgRecv recvMsg = null;
        try {
            switch (cmdType) {
                case 3: {
                    DmMsgRecv recvMsgS;
                    recvMsg = DmdbRwAutoDistribute.sendMsgToPrimary(msg, conn, stmt);
                    if (!conn.getDbAccess().isStandbyAlive() || (recvMsgS = DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt)) == null) break;
                    stmt.setHandleForStandby(Request_Response.resp_stmt_alloc(recvMsgS, stmt));
                    break;
                }
                case 4: 
                case 8: 
                case 9: 
                case 17: 
                case 27: 
                case 52: {
                    recvMsg = DmdbRwAutoDistribute.sendMsgToPrimary(msg, conn, stmt);
                    if (!conn.getDbAccess().isStandbyAlive()) break;
                    DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt);
                    break;
                }
                case 5: 
                case 91: {
                    recvMsg = DmdbRwAutoDistribute.sendMsgToServer(msg, conn, stmt, DmdbRwAutoDistribute.rwDistribute(conn, stmt.getOriginalSql()));
                    break;
                }
                case 6: 
                case 13: {
                    recvMsg = DmdbRwAutoDistribute.sendMsgToServer(msg, conn, stmt, stmt.getPrepareFromStandby() ? 0 : 1);
                    break;
                }
                case 14: 
                case 90: {
                    recvMsg = DmdbRwAutoDistribute.sendMsgToServer(msg, conn, stmt, stmt.getPrepareFromStandby() ? 0 : 1);
                    break;
                }
                case 7: 
                case 15: 
                case 44: {
                    if (stmt.getExecFromStandby()) {
                        if (conn.getDbAccess().isStandbyAlive()) {
                            recvMsg = DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt);
                            break;
                        }
                        DBError.throwSQLException(6034);
                        break;
                    }
                    recvMsg = DmdbRwAutoDistribute.sendMsgToPrimary(msg, conn, stmt);
                    break;
                }
                default: {
                    recvMsg = DmdbRwAutoDistribute.sendMsgToServer(msg, conn, stmt, DmdbRwAutoDistribute.rwDistribute(conn, null));
                }
            }
            DmdbRwAutoDistribute.afterAccessToServer(msg, conn, stmt, recvMsg, true);
        }
        catch (IOException iOException) {
            conn.setClosed(true);
            DBError.throwSQLException(6001);
        }
        return recvMsg;
    }

    public static DmMsgRecv accessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException {
        DmMsgRecv recvMsg = null;
        try {
            recvMsg = rwDestType == 1 ? DmdbRwAutoDistribute.sendMsgToPrimary(msg, conn, stmt) : DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt);
            DmdbRwAutoDistribute.afterAccessToServer(msg, conn, stmt, recvMsg, false);
        }
        catch (IOException iOException) {
            conn.setClosed(true);
            DBError.throwSQLException(6001);
        }
        return recvMsg;
    }

    private static void afterAccessToServer(DmMsgSend msg, DmdbConnection_bs conn, DmdbStatement_bs stmt, DmMsgRecv recvMsg, boolean retCheck) throws SQLException, IOException {
        if (stmt == null || recvMsg == null) {
            return;
        }
        short cmdType = msg.req_get_cmd();
        boolean bothDo = false;
        switch (cmdType) {
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 17: 
            case 27: 
            case 52: {
                bothDo = true;
                break;
            }
            case 5: {
                if (msg.req_prepare_get_exec_direct() == 1) {
                    stmt.setExecFromStandby(recvMsg.getFromStandby());
                    break;
                }
                stmt.setPrepareFromStandby(recvMsg.getFromStandby());
                break;
            }
            case 6: 
            case 13: 
            case 91: {
                stmt.setExecFromStandby(recvMsg.getFromStandby());
                break;
            }
        }
        if (retCheck && !bothDo) {
            short retType = recvMsg.res_execute_get_ret_type();
            switch (retType) {
                case 147: 
                case 148: 
                case 151: 
                case 153: 
                case 165: 
                case 166: {
                    boolean fromStandby = recvMsg.getFromStandby();
                    if (fromStandby) {
                        DmdbRwAutoDistribute.sendMsgToPrimary(msg, conn, stmt);
                        break;
                    }
                    if (!conn.getDbAccess().isStandbyAlive()) break;
                    DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt);
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int rwCount(DmdbConnection_bs conn, int destType) {
        String key = String.valueOf(conn.getHost()) + "_" + conn.getPort() + "_" + conn.getRwPercent();
        RwCounter rwCounter = null;
        Boolean bl = rwMapMutex;
        synchronized (bl) {
            rwCounter = rwMap.get(key);
            if (rwCounter == null) {
                rwCounter = new RwCounter(conn.getRwPercent());
                rwMap.put(key, rwCounter);
            }
        }
        destType = rwCounter.count(destType);
        conn.setRwLatestDestType(destType);
        return destType;
    }

    private static int rwDistribute(DmdbConnection_bs conn, String sql) {
        if (!conn.getRwSeparate()) {
            return 1;
        }
        if (!conn.getTransFinish()) {
            return conn.getRwLatestDestType();
        }
        boolean readonly = true;
        if (StringUtil.isNotEmpty(sql)) {
            String tmpsql = sql.trim();
            String sqlhead = tmpsql.split(" ", 2)[0];
            readonly = !sqlhead.equalsIgnoreCase("INSERT") && !sqlhead.equalsIgnoreCase("UPDATE") && !sqlhead.equalsIgnoreCase("DELETE") && !sqlhead.equalsIgnoreCase("CREATE") && !sqlhead.equalsIgnoreCase("TRUNCATE") && !sqlhead.equalsIgnoreCase("DROP") && !sqlhead.equalsIgnoreCase("ALTER") && !sqlhead.equalsIgnoreCase("SP_SET_SESSION_READONLY");
        }
        if (readonly && conn.getTransLevel() != 8) {
            if (conn.getDbAccess().isStandbyAlive()) {
                return DmdbRwAutoDistribute.rwCount(conn, -1);
            }
            DmdbRwAutoDistribute.addStandbyToRecover(conn);
        }
        return DmdbRwAutoDistribute.rwCount(conn, 1);
    }

    private static boolean addStandbyToRecover(DmdbConnection_bs conn) {
        if (conn.getDbAccess().isStandbyAlive() || conn.getRwStandbyRecoverTime() <= 0) {
            return false;
        }
        long currentTs = System.currentTimeMillis();
        long lastRecoverTs = conn.getDbAccess().getStandbyRecoverTs();
        if (lastRecoverTs <= 0L || currentTs - lastRecoverTs > (long)(conn.getRwStandbyRecoverTime() * 1000)) {
            conn.getDbAccess().setStandbyRecoverTs(currentTs);
            RwStandbyRecoverThread.addStandby(conn);
            return true;
        }
        return false;
    }

    private static final DmMsgRecv sendMsgToServer(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt, int rwDestType) throws SQLException, IOException {
        DmMsgRecv standbyRecvMsg;
        boolean needSwitchToPrimary;
        block14: {
            if (rwDestType == 1) {
                return DmdbRwAutoDistribute.sendMsgToPrimary(sendMsg, conn, stmt);
            }
            needSwitchToPrimary = false;
            standbyRecvMsg = null;
            if (!conn.getDbAccess().isStandbyAlive()) {
                needSwitchToPrimary = true;
            } else {
                try {
                    standbyRecvMsg = DmdbRwAutoDistribute.sendMsgToStandby(sendMsg, conn, stmt);
                    Request_Response.resp_checkErr(standbyRecvMsg, conn);
                    if (!conn.isRwHA() || standbyRecvMsg == null) break block14;
                    short retType = standbyRecvMsg.res_execute_get_ret_type();
                    short cmdType = sendMsg.req_get_cmd();
                    switch (retType) {
                        case 160: {
                            if (cmdType == 5 && sendMsg.req_prepare_get_exec_direct() != 1) break;
                            if (standbyRecvMsg.res_execute_get_fetched_rows() == 0) {
                                LOG.debug((Object)conn.getDbAccess(), "DmdbRwAutoDistribute.sendMsgToServer", "turn to primary because of result set is empty on standby;");
                                needSwitchToPrimary = true;
                            }
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    LOG.debug((Object)conn.getDbAccess(), "DmdbRwAutoDistribute.sendMsgToServer", "turn to primary because of execute error on standby : " + e.getMessage());
                    needSwitchToPrimary = true;
                }
            }
        }
        if (needSwitchToPrimary) {
            if (conn.getDbAccess().isStandbyAlive()) {
                try {
                    DmMsgSend msg = new DmMsgSend();
                    Request_Response.req_commit(msg);
                    DmdbRwAutoDistribute.sendMsgToStandby(msg, conn, stmt);
                }
                catch (Exception exception) {}
            }
            DmdbRwAutoDistribute.rwCount(conn, 1);
            short cmdType = sendMsg.req_get_cmd();
            if (cmdType == 6 || cmdType == 13) {
                DmdbCSI.rePrepareOnPrimary(stmt, stmt.getOriginalSql(), false, 0);
            }
            return DmdbRwAutoDistribute.sendMsgToPrimary(sendMsg, conn, stmt);
        }
        return standbyRecvMsg;
    }

    private static final DmMsgRecv sendMsgToPrimary(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException, IOException {
        short cmdType = sendMsg.req_get_cmd();
        DmMsgRecv retMsg = null;
        IOException ioEx = null;
        try {
            sendMsg.req_set_stmtid(stmt == null ? 0 : stmt.getHandle());
            retMsg = conn.getDbAccess().accessPrimary(sendMsg, conn.getComprMsg());
        }
        catch (IOException e) {
            ioEx = e;
        }
        switch (cmdType) {
            case 1: 
            case 200: {
                break;
            }
            default: {
                if (!conn.needSwitchForConnError() || ioEx == null && (!conn.getRwSeparate() || !DmdbRwAutoDistribute.primaryStandbyChanged(conn, retMsg))) break;
                LOG.debug((Object)conn, "DmdbCSI.sendMsgToPrimary()", "doswitch because of " + (ioEx != null ? "IOException" : "primaryStandbyChanged"));
                conn.reset();
                DBError.throwSQLException(20000);
            }
        }
        if (ioEx != null) {
            throw ioEx;
        }
        return retMsg;
    }

    private static final DmMsgRecv sendMsgToStandby(DmMsgSend sendMsg, DmdbConnection_bs conn, DmdbStatement_bs stmt) throws SQLException {
        DmMsgRecv recv = null;
        try {
            sendMsg.req_set_stmtid(stmt == null ? 0 : stmt.getHandleForStandby());
            recv = conn.getDbAccess().accessStandby(sendMsg, conn.getComprMsg());
        }
        catch (IOException iOException) {
            LOG.debug((Object)conn, "DmdbCSI.sendMsgToStandby()", "standby IOException:[" + conn.getStandbyHost() + ":" + conn.getStandbyPort() + "]");
            conn.getDbAccess().removeStandby();
        }
        return recv;
    }

    private static final boolean primaryStandbyChanged(DmdbConnection_bs conn, DmMsgRecv recvMsg) {
        short svrMode = Request_Response.resp_svr_mode(recvMsg);
        return svrMode == 2 && conn.getSvrMode() == 1 || svrMode == 1 && conn.getSvrMode() == 2;
    }
}

