/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.log;

import dm.jdbc.desc.DmSvcConf;
import java.util.concurrent.LinkedBlockingQueue;

public class LogBuffer {
    private static final int SIZE = DmSvcConf.logBufferSize;
    private static final int POOL_SIZE = DmSvcConf.logBufferPoolSize;
    private static final LinkedBlockingQueue<LogBuffer> POOL_QUEUE = new LinkedBlockingQueue(POOL_SIZE);
    private String[] logs = new String[SIZE];
    private int offset = 0;

    private LogBuffer() {
    }

    public static LogBuffer borrowBuffer() {
        LogBuffer buffer = POOL_QUEUE.poll();
        if (buffer == null) {
            buffer = new LogBuffer();
        }
        return buffer;
    }

    public static void returnBuffer(LogBuffer buffer) {
        POOL_QUEUE.offer(buffer);
    }

    public void reset() {
        int i = 0;
        while (i < this.logs.length) {
            this.logs[i] = null;
            ++i;
        }
        this.offset = 0;
    }

    public boolean isFull() {
        return this.logs.length == this.offset;
    }

    public void log(String log) {
        this.logs[this.offset++] = log;
    }

    public String[] getLogs() {
        return this.logs;
    }

    public int getOffset() {
        return this.offset;
    }
}

