/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.stat;

import dm.jdbc.driver.DmdbConnection_bs;
import dm.jdbc.stat.ConnectionStat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcStat {
    private LinkedHashMap<String, ConnectionStat> connStatMap;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private int maxConnSize = 1000;
    private AtomicLong skipConnCount = new AtomicLong();

    public JdbcStat(int maxConnSize) {
        if (maxConnSize > 0) {
            this.maxConnSize = maxConnSize;
        }
        this.connStatMap = new LinkedHashMap<String, ConnectionStat>(16, 0.75f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ConnectionStat> eldest) {
                ConnectionStat connStat;
                boolean remove;
                boolean bl = remove = this.size() > JdbcStat.this.maxConnSize;
                if (remove && (connStat = eldest.getValue()).getActiveConnCount() > 0L) {
                    JdbcStat.this.skipConnCount.incrementAndGet();
                }
                return remove;
            }
        };
    }

    public ConnectionStat createConnStat(DmdbConnection_bs conn) {
        String url = String.valueOf(conn.getHost()) + ":" + conn.getPort();
        this.lock.writeLock().lock();
        try {
            ConnectionStat connStat = this.connStatMap.get(url);
            if (connStat == null) {
                connStat = new ConnectionStat(url);
                connStat.setProperties(conn.printProperties());
                this.connStatMap.put(url, connStat);
            }
            ConnectionStat connectionStat = connStat;
            return connectionStat;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Map<String, ConnectionStat> getConnStatMap() {
        LinkedHashMap<String, ConnectionStat> map = new LinkedHashMap<String, ConnectionStat>(this.connStatMap.size());
        this.lock.readLock().lock();
        try {
            map.putAll(this.connStatMap);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return map;
    }
}

