/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.convert;

import dm.jdbc.desc.Column;
import dm.jdbc.desc.TypeData;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbBFile;
import dm.jdbc.driver.DmdbBlob;
import dm.jdbc.driver.DmdbClob;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbInputStream;
import dm.jdbc.driver.DmdbIntervalDT;
import dm.jdbc.driver.DmdbIntervalYM;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbNumeric;
import dm.jdbc.driver.DmdbReader;
import dm.jdbc.driver.DmdbSQLInput;
import dm.jdbc.driver.DmdbStruct;
import dm.jdbc.driver.DmdbTimestamp;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.ByteUtil;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLData;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DB2J {
    private static byte[] processVarchar2(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        int n3 = byArray.length;
        while (n3 < byArray2.length) {
            byArray2[n3] = 32;
            ++n3;
        }
        return byArray2;
    }

    private static BigDecimal decToBigDecimal(byte[] byArray, int n2, int n3, boolean bl) {
        if (bl) {
            n2 = -1;
            n3 = -1;
        }
        return new DmdbNumeric(byArray, n2, n3).toBigDecimal();
    }

    private static String charToString(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        if (column.type == 1) {
            byArray = DB2J.processVarchar2(byArray, column.prec);
        } else if (column.type == 19) {
            DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, true);
            return dmdbClob.getSubString(1L, (int)dmdbClob.length());
        }
        return ByteUtil.getString(byArray, 0, byArray.length, dmdbConnection.getServerEncoding());
    }

    private static long binaryToLong(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        int n2;
        int n3;
        if (column.type == 12) {
            DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, true);
            byArray = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
        }
        long l2 = 0L;
        long l3 = 0L;
        int n4 = 0;
        int n5 = n3 = byArray.length > 8 ? 8 : byArray.length;
        if (byArray.length > 8) {
            n2 = 0;
            while (n2 < byArray.length - 8) {
                if (byArray[n2] != 0) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                ++n2;
            }
            n4 = byArray.length - 8;
            n3 = 8;
        }
        n2 = n4;
        while (n2 < n4 + n3) {
            l3 = 0xFF & byArray[n2];
            l2 = l3 | l2 << 8;
            ++n2;
        }
        return l2;
    }

    private static String tsToString(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
        switch (column.type) {
            case 14: {
                if (!StringUtil.isNotEmpty(dmdbConnection.formatDate)) break;
                return DateUtil.toString(nArray, dmdbConnection.formatDate, dmdbConnection.oracleDateLanguage);
            }
            case 15: {
                if (!StringUtil.isNotEmpty(dmdbConnection.formatTime)) break;
                return DateUtil.toString(nArray, dmdbConnection.formatTime, dmdbConnection.oracleDateLanguage);
            }
            case 22: {
                if (!StringUtil.isNotEmpty(dmdbConnection.formatTimeTZ)) break;
                return DateUtil.toString(nArray, dmdbConnection.formatTimeTZ, dmdbConnection.oracleDateLanguage);
            }
            case 16: {
                if (!StringUtil.isNotEmpty(dmdbConnection.formatTimestamp)) break;
                return DateUtil.toString(nArray, dmdbConnection.formatTimestamp, dmdbConnection.oracleDateLanguage);
            }
            case 23: {
                if (!StringUtil.isNotEmpty(dmdbConnection.formatTimestampTZ)) break;
                return DateUtil.toString(nArray, dmdbConnection.formatTimestampTZ, dmdbConnection.oracleDateLanguage);
            }
        }
        return DateUtil.toString(nArray, column.type, column.scale);
    }

    public static String toString(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        String string = null;
        switch (column.type) {
            case 0: 
            case 1: 
            case 2: {
                string = DB2J.charToString(byArray, column, dmdbConnection);
                break;
            }
            case 3: 
            case 5: 
            case 13: {
                string = String.valueOf(byArray[0]);
                break;
            }
            case 6: {
                string = String.valueOf(ByteUtil.getShort(byArray, 0));
                break;
            }
            case 7: {
                string = String.valueOf(ByteUtil.getInt(byArray, 0));
                break;
            }
            case 8: {
                string = String.valueOf(ByteUtil.getLong(byArray, 0));
                break;
            }
            case 10: {
                string = String.valueOf(ByteUtil.getFloat(byArray, 0));
                break;
            }
            case 11: {
                string = String.valueOf(ByteUtil.getDouble(byArray, 0));
                break;
            }
            case 9: {
                string = new DmdbNumeric(byArray, column.prec, column.scale).toString();
                break;
            }
            case 17: 
            case 18: {
                string = StringUtil.bytesToHexString(byArray, false);
                break;
            }
            case 12: {
                if (DmdbType.isComplexType(column.type, column.scale)) {
                    string = byArray != null ? DB2J.toComplexType(byArray, column, dmdbConnection, null).toString() : null;
                    break;
                }
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, true);
                string = StringUtil.bytesToHexString(dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length()));
                break;
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, true);
                string = dmdbClob.do_getSubString(1L, (int)dmdbClob.do_length());
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                string = DB2J.tsToString(byArray, column, dmdbConnection);
                break;
            }
            case 21: {
                DmdbIntervalDT dmdbIntervalDT = new DmdbIntervalDT(byArray);
                string = dmdbIntervalDT.getDTString();
                break;
            }
            case 20: {
                DmdbIntervalYM dmdbIntervalYM = new DmdbIntervalYM(byArray);
                string = dmdbIntervalYM.toString();
                break;
            }
            case 117: {
                DmdbArray dmdbArray = TypeData.bytesToArray(byArray, null, column.typeDescriptor);
                string = dmdbArray.toString();
                break;
            }
            case 122: {
                DmdbArray dmdbArray = TypeData.bytesToSArray(byArray, null, column.typeDescriptor);
                string = dmdbArray.toString();
                break;
            }
            case 119: {
                Object object = TypeData.bytesToObj(byArray, null, column.typeDescriptor);
                string = object.toString();
                break;
            }
            case 121: {
                DmdbStruct dmdbStruct = TypeData.bytesToRecord(byArray, null, column.typeDescriptor);
                string = ((Object)dmdbStruct).toString();
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return string;
    }

    public static boolean toBoolean(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        boolean bl = false;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                bl = byArray[0] != 0;
                break;
            }
            case 6: {
                bl = ByteUtil.getShort(byArray, 0) != 0;
                break;
            }
            case 7: {
                bl = ByteUtil.getInt(byArray, 0) != 0;
                break;
            }
            case 8: {
                bl = ByteUtil.getLong(byArray, 0) != 0L;
                break;
            }
            case 10: {
                bl = ByteUtil.getFloat(byArray, 0) != 0.0f;
                break;
            }
            case 11: {
                bl = ByteUtil.getDouble(byArray, 0) != 0.0;
                break;
            }
            case 9: {
                bl = !new DmdbNumeric(byArray, column.prec, column.scale).isZero();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                bl = ConvertUtil.toBoolean(string);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return bl;
    }

    public static byte toByte(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        byte by = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                by = byArray == null || byArray.length == 0 ? (byte)0 : byArray[0];
                break;
            }
            case 6: {
                short s2 = ByteUtil.getShort(byArray, 0);
                if (s2 < -128 || s2 > 127) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)s2;
                break;
            }
            case 7: {
                int n2 = ByteUtil.getInt(byArray, 0);
                if (n2 < -128 || n2 > 127) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)n2;
                break;
            }
            case 8: {
                long l2 = ByteUtil.getLong(byArray, 0);
                if (l2 < -128L || l2 > 127L) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)l2;
                break;
            }
            case 10: {
                float f2 = ByteUtil.getFloat(byArray, 0);
                if (f2 < -128.0f || f2 > 127.0f) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)f2;
                break;
            }
            case 11: {
                double d2 = ByteUtil.getDouble(byArray, 0);
                if (d2 < -128.0 || d2 > 127.0) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)d2;
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                try {
                    by = bigDecimal.byteValueExact();
                }
                catch (Exception exception) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    by = Byte.parseByte(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long l3 = DB2J.binaryToLong(byArray, column, dmdbConnection);
                if (l3 < -128L || l3 > 127L) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                by = (byte)l3;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return by;
    }

    public static short toShort(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        short s2 = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                s2 = byArray == null || byArray.length == 0 ? (short)0 : byArray[0];
                break;
            }
            case 6: {
                s2 = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                int n2 = ByteUtil.getInt(byArray, 0);
                if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                s2 = (short)n2;
                break;
            }
            case 8: {
                long l2 = ByteUtil.getLong(byArray, 0);
                if (l2 < -32768L || l2 > 32767L) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                s2 = (short)l2;
                break;
            }
            case 10: {
                float f2 = ByteUtil.getFloat(byArray, 0);
                if (f2 < -32768.0f || f2 > 32767.0f) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                s2 = (short)f2;
                break;
            }
            case 11: {
                double d2 = ByteUtil.getDouble(byArray, 0);
                if (d2 < -32768.0 || d2 > 32767.0) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                s2 = (short)d2;
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                try {
                    s2 = bigDecimal.shortValueExact();
                }
                catch (Exception exception) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    s2 = Short.parseShort(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long l3 = DB2J.binaryToLong(byArray, column, dmdbConnection);
                if (l3 < -32768L || l3 > 32767L) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                s2 = (short)l3;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return s2;
    }

    public static int toInt(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        int n2 = 0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                n2 = byArray == null || byArray.length == 0 ? 0 : byArray[0];
                break;
            }
            case 6: {
                n2 = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                n2 = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 8: {
                long l2 = ByteUtil.getLong(byArray, 0);
                if (l2 < Integer.MIN_VALUE || l2 > Integer.MAX_VALUE) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                n2 = (int)l2;
                break;
            }
            case 10: {
                float f2 = ByteUtil.getFloat(byArray, 0);
                if (f2 < -2.1474836E9f || f2 > 2.1474836E9f) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                n2 = (int)f2;
                break;
            }
            case 11: {
                double d2 = ByteUtil.getDouble(byArray, 0);
                if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                n2 = (int)d2;
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                try {
                    n2 = bigDecimal.intValueExact();
                }
                catch (Exception exception) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    n2 = Integer.parseInt(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                long l3 = DB2J.binaryToLong(byArray, column, dmdbConnection);
                if (l3 < Integer.MIN_VALUE || l3 > Integer.MAX_VALUE) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                n2 = (int)l3;
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return n2;
    }

    public static long toLong(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        long l2 = 0L;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                l2 = byArray == null || byArray.length == 0 ? 0 : byArray[0];
                break;
            }
            case 6: {
                l2 = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                l2 = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 8: {
                l2 = ByteUtil.getLong(byArray, 0);
                break;
            }
            case 10: {
                l2 = (long)ByteUtil.getFloat(byArray, 0);
                break;
            }
            case 11: {
                l2 = (long)ByteUtil.getDouble(byArray, 0);
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                try {
                    l2 = bigDecimal.longValueExact();
                }
                catch (Exception exception) {
                    DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                }
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    l2 = Long.parseLong(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            case 12: 
            case 17: 
            case 18: {
                l2 = DB2J.binaryToLong(byArray, column, dmdbConnection);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return l2;
    }

    public static float toFloat(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        float f2 = 0.0f;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                f2 = byArray == null || byArray.length == 0 ? (byte)0 : byArray[0];
                break;
            }
            case 6: {
                f2 = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                f2 = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 8: {
                f2 = ByteUtil.getLong(byArray, 0);
                break;
            }
            case 10: {
                f2 = ByteUtil.getFloat(byArray, 0);
                break;
            }
            case 11: {
                double d2 = ByteUtil.getDouble(byArray, 0);
                f2 = (float)d2;
                if (f2 != Float.NEGATIVE_INFINITY && f2 != Float.POSITIVE_INFINITY) break;
                DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                f2 = bigDecimal.floatValue();
                if (f2 != Float.NEGATIVE_INFINITY && f2 != Float.POSITIVE_INFINITY) break;
                DBError.EC_DATA_OVERFLOW.throwException(new String[0]);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    f2 = Float.parseFloat(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return f2;
    }

    public static double toDouble(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        double d2 = 0.0;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                d2 = byArray == null || byArray.length == 0 ? (byte)0 : byArray[0];
                break;
            }
            case 6: {
                d2 = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                d2 = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 8: {
                d2 = ByteUtil.getLong(byArray, 0);
                break;
            }
            case 10: {
                d2 = ByteUtil.getFloat(byArray, 0);
                break;
            }
            case 11: {
                d2 = ByteUtil.getDouble(byArray, 0);
                break;
            }
            case 9: {
                BigDecimal bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                d2 = bigDecimal.doubleValue();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    d2 = Double.parseDouble(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return d2;
    }

    public static BigDecimal toBigDecimal(byte[] byArray, Column column, DmdbConnection dmdbConnection, int n2) {
        BigDecimal bigDecimal = DB2J.toBigDecimal(byArray, column, dmdbConnection);
        if (n2 != -1) {
            bigDecimal = bigDecimal.setScale(n2, 4);
        }
        return bigDecimal;
    }

    public static BigDecimal toBigDecimal(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        BigDecimal bigDecimal = null;
        switch (column.type) {
            case 3: 
            case 5: 
            case 13: {
                bigDecimal = new BigDecimal(byArray == null || byArray.length == 0 ? 0 : byArray[0]);
                break;
            }
            case 6: {
                bigDecimal = new BigDecimal(ByteUtil.getShort(byArray, 0));
                break;
            }
            case 7: {
                bigDecimal = new BigDecimal(ByteUtil.getInt(byArray, 0));
                break;
            }
            case 8: {
                bigDecimal = new BigDecimal(ByteUtil.getLong(byArray, 0));
                break;
            }
            case 10: {
                bigDecimal = new BigDecimal(ByteUtil.getFloat(byArray, 0));
                break;
            }
            case 11: {
                bigDecimal = new BigDecimal(ByteUtil.getDouble(byArray, 0));
                break;
            }
            case 9: {
                bigDecimal = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                try {
                    bigDecimal = new BigDecimal(StringUtil.trimToEmpty(string));
                }
                catch (Exception exception) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return bigDecimal;
    }

    public static byte[] toBytes(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        byte[] byArray2 = ByteUtil.getBytes(byArray, 0, byArray.length);
        switch (column.type) {
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray2, dmdbConnection, column, true);
                byArray2 = dmdbClob.getBytes(1L, (int)dmdbClob.do_length());
                break;
            }
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray2, dmdbConnection, column, true);
                byArray2 = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
                break;
            }
        }
        return byArray2;
    }

    public static Date toDate(byte[] byArray, Column column, DmdbConnection dmdbConnection, Calendar calendar) {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toDate(nArray, DmdbType.isLocalTimeZone(column.type, column.scale) ? null : calendar);
            }
            case 22: 
            case 23: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toDate(nArray, null);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                return DateUtil.toDate(string, calendar);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    public static Time toTime(byte[] byArray, Column column, DmdbConnection dmdbConnection, Calendar calendar) {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toTime(nArray, DmdbType.isLocalTimeZone(column.type, column.scale) ? null : calendar);
            }
            case 22: 
            case 23: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toTime(nArray, null);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                return DateUtil.toTime(string, calendar);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    public static Timestamp toTimestamp(byte[] byArray, Column column, DmdbConnection dmdbConnection, Calendar calendar) {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toTimestamp(nArray, DmdbType.isLocalTimeZone(column.type, column.scale) ? null : calendar);
            }
            case 22: 
            case 23: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                return DateUtil.toTimestamp(nArray, null);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                return DateUtil.toTimestamp(string, calendar);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    public static DmdbTimestamp toDmdbTimestamp(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: {
                return new DmdbTimestamp(byArray, column, dmdbConnection);
            }
            case 0: 
            case 1: 
            case 2: 
            case 19: {
                String string = DB2J.charToString(byArray, column, dmdbConnection);
                return DmdbTimestamp.valueOf(string);
            }
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        return null;
    }

    public static DmdbInputStream toAsciiStream(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return new DmdbInputStream(dmdbBlob, 2);
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return dmdbClob.do_getAsciiStream();
            }
            case 1: {
                byte[] byArray2 = DB2J.processVarchar2(byArray, column.prec);
                return new DmdbInputStream(byArray2, 2);
            }
        }
        return new DmdbInputStream(byArray, 2);
    }

    public static DmdbInputStream toUnicodeStream(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return new DmdbInputStream(dmdbBlob, 3);
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return new DmdbInputStream(dmdbClob, 3);
            }
            case 1: {
                byte[] byArray2 = DB2J.processVarchar2(byArray, column.prec);
                return new DmdbInputStream(byArray2, 3);
            }
        }
        return new DmdbInputStream(byArray, 3);
    }

    public static DmdbInputStream toBinaryStream(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return dmdbBlob.do_getBinaryStream();
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return dmdbClob.do_getBinaryStream();
            }
            case 1: {
                byte[] byArray2 = DB2J.processVarchar2(byArray, column.prec);
                return new DmdbInputStream(byArray2, 1);
            }
        }
        return new DmdbInputStream(byArray, 1);
    }

    public static DmdbReader toCharacterStream(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 17: 
            case 18: {
                return new DmdbReader(byArray);
            }
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return new DmdbReader(dmdbBlob);
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                return dmdbClob.do_getCharacterStream();
            }
        }
        String string = DB2J.toString(byArray, column, dmdbConnection);
        return new DmdbReader(string);
    }

    public static DmdbBlob toBlob(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 12: {
                return DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
            }
        }
        return DmdbBlob.newInstanceOfLocal(byArray, dmdbConnection);
    }

    public static DmdbNClob toClob(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        switch (column.type) {
            case 19: {
                return DmdbNClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
            }
        }
        DBError.ECJDBC_INVALID_COLUMN_TYPE.throwException(new String[0]);
        return null;
    }

    public static Object toObject(byte[] byArray, Column column, DmdbConnection dmdbConnection, Map map) {
        Object object = null;
        switch (column.type) {
            case 3: 
            case 13: {
                object = byArray[0] != 0;
                break;
            }
            case 5: {
                object = ByteUtil.getByte(byArray, 0);
                break;
            }
            case 6: {
                object = ByteUtil.getShort(byArray, 0);
                break;
            }
            case 7: {
                object = ByteUtil.getInt(byArray, 0);
                break;
            }
            case 8: {
                object = ByteUtil.getLong(byArray, 0);
                break;
            }
            case 9: {
                object = DB2J.decToBigDecimal(byArray, column.prec, column.scale, dmdbConnection.compatibleOracle());
                break;
            }
            case 10: {
                object = Float.valueOf(ByteUtil.getFloat(byArray, 0));
                break;
            }
            case 11: {
                object = ByteUtil.getDouble(byArray, 0);
                break;
            }
            case 14: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                object = DateUtil.toDate(nArray, null);
                break;
            }
            case 15: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                object = DateUtil.toTime(nArray, null);
                break;
            }
            case 16: {
                int[] nArray = DateUtil.decode(byArray, column.isBdta, column.type, column.scale, dmdbConnection.localTimezone, dmdbConnection.dbTimezone);
                object = DateUtil.toTimestamp(nArray, null);
                break;
            }
            case 17: 
            case 18: {
                object = ByteUtil.getBytes(byArray, 0, byArray.length);
                break;
            }
            case 12: {
                DmdbBlob dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARBINARY")) {
                    object = dmdbBlob.do_getBytes(1L, (int)dmdbBlob.do_length());
                    break;
                }
                object = dmdbBlob;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                object = DB2J.charToString(byArray, column, dmdbConnection);
                if (!DmdbType.isBFile(column.type, column.prec, column.scale)) break;
                object = new DmdbBFile((String)object);
                break;
            }
            case 19: {
                DmdbClob dmdbClob = DmdbClob.newInstance(byArray, dmdbConnection, column, dmdbConnection.lobFetchAll());
                if (StringUtil.equalsIgnoreCase(column.typeName, "LONGVARCHAR")) {
                    object = dmdbClob.do_getSubString(1L, (int)dmdbClob.do_length());
                    break;
                }
                object = dmdbClob;
                break;
            }
            case 20: {
                object = new DmdbIntervalYM(byArray);
                break;
            }
            case 21: {
                object = new DmdbIntervalDT(byArray);
                break;
            }
            case 117: {
                object = TypeData.bytesToArray(byArray, null, column.typeDescriptor);
                break;
            }
            case 122: {
                object = TypeData.bytesToSArray(byArray, null, column.typeDescriptor);
                break;
            }
            case 119: {
                object = TypeData.bytesToObj(byArray, null, column.typeDescriptor);
                if (!(object instanceof Struct)) break;
                object = DB2J.toSQLData((Struct)object, map);
                break;
            }
            case 121: {
                object = TypeData.bytesToRecord(byArray, null, column.typeDescriptor);
                object = DB2J.toSQLData((Struct)object, map);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return object;
    }

    public static Object toSQLData(Struct struct, Map map) {
        if (map == null || map.size() == 0) {
            return struct;
        }
        String string = struct.getSQLTypeName();
        Object v2 = map.get(string);
        if (v2 != null) {
            try {
                Object t2 = ((Class)v2).newInstance();
                DmdbSQLInput dmdbSQLInput = new DmdbSQLInput(map, struct.getAttributes(map));
                ((SQLData)t2).readSQL(dmdbSQLInput, string);
                return t2;
            }
            catch (Exception exception) {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return struct;
    }

    public static Object toComplexType(byte[] byArray, Column column, DmdbConnection dmdbConnection, Map map) {
        Object object = null;
        switch (column.type) {
            case 12: {
                DmdbBlob dmdbBlob;
                if (!DmdbType.isComplexType(column.type, column.scale)) {
                    DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
                }
                if (!((object = TypeData.objBlobToObj(dmdbBlob = DmdbBlob.newInstanceFromDB(byArray, dmdbConnection, column, true), column.typeDescriptor)) instanceof Struct)) break;
                object = DB2J.toSQLData((Struct)object, map);
                break;
            }
            case 117: {
                object = TypeData.bytesToArray(byArray, null, column.typeDescriptor);
                break;
            }
            case 122: {
                object = TypeData.bytesToSArray(byArray, null, column.typeDescriptor);
                break;
            }
            case 119: {
                object = TypeData.bytesToObj(byArray, null, column.typeDescriptor);
                if (!(object instanceof Struct)) break;
                object = DB2J.toSQLData((Struct)object, map);
                break;
            }
            case 121: {
                object = TypeData.bytesToRecord(byArray, null, column.typeDescriptor);
                object = DB2J.toSQLData((Struct)object, map);
                break;
            }
            default: {
                DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
            }
        }
        return object;
    }

    public static DmdbArray toArray(byte[] byArray, Column column, DmdbConnection dmdbConnection) {
        Object object = DB2J.toComplexType(byArray, column, dmdbConnection, null);
        if (!(object instanceof DmdbArray)) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(new String[0]);
        }
        return (DmdbArray)object;
    }
}

