/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class DmdbXAResource
implements XAResource {
    public boolean recoverd = false;
    DmdbConnection conn;
    int m_timeout;
    Xid m_xid;
    private boolean savedAutoCommit;
    private AtomicLong startCount = new AtomicLong(0L);

    public DmdbXAResource() {
        this.conn = null;
        this.m_timeout = 60;
    }

    public DmdbXAResource(DmdbConnection dmdbConnection) {
        this.conn = dmdbConnection;
        this.m_timeout = 60;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void setRecoverd(boolean bl) {
        this.recoverd = bl;
    }

    public void checkClosed() {
        try {
            this.conn.checkClosed();
        }
        catch (SQLException sQLException) {
            DBError.throwXAException(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean bl) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            int n2;
            int n3 = n2 = bl ? 0x40000000 : 0;
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(1, xid, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) {
        try {
            this.checkClosed();
            DmdbConnection dmdbConnection = this.conn;
            synchronized (dmdbConnection) {
                if (xid == null || n2 != 0x4000000 && n2 != 0x20000000 && n2 != 0x2000000) {
                    DBError.throwXAException(-5);
                }
                this.conn.dbAccess.a(2, xid, n2);
            }
        }
        finally {
            this.restoreAutoCommit();
            this.startCount.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(3, xid, 0);
        }
    }

    @Override
    public int getTransactionTimeout() {
        return this.m_timeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) {
        Connection connection = null;
        if (xAResource instanceof DmdbXAResource) {
            connection = ((DmdbXAResource)xAResource).getConnection();
        }
        if (connection == null) {
            return false;
        }
        return connection.equals(this.conn) || ((DmdbConnection)connection).url.equals(this.conn.url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            int n2 = 0;
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            if ((n2 = this.conn.dbAccess.a(4, xid, 0)) != 0 && n2 != 3) {
                DBError.throwXAException(n2);
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int n2) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            ArrayList<Xid> arrayList = new ArrayList<Xid>();
            Xid[] xidArray = null;
            Xid[] xidArray2 = null;
            if (n2 != 0x1000000 && n2 != 0x800000 && n2 != 0 && n2 != 0x1800000) {
                DBError.throwXAException(-5);
            }
            this.recoverd = false;
            xidArray2 = this.conn.dbAccess.a(this, 0x1000000);
            if (this.recoverd) {
                return xidArray2;
            }
            int n3 = 0;
            while (n3 < xidArray2.length) {
                arrayList.add(xidArray2[n3]);
                ++n3;
            }
            do {
                xidArray2 = this.conn.dbAccess.a(this, 0);
                n3 = 0;
                while (n3 < xidArray2.length) {
                    arrayList.add(xidArray2[n3]);
                    ++n3;
                }
            } while (!this.recoverd);
            xidArray = new Xid[arrayList.size()];
            xidArray = (Xid[])arrayList.toArray();
            return xidArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(6, xid, 0);
        }
    }

    @Override
    public boolean setTransactionTimeout(int n2) {
        if (n2 < 0) {
            DBError.throwXAException(-5);
        }
        this.m_timeout = n2;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int n2) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            if (n2 != 0 && n2 != 0x200000 && n2 != 0x8000000) {
                DBError.throwXAException(-5);
            }
            try {
                this.savedAutoCommit();
                this.startCount.incrementAndGet();
                this.conn.dbAccess.a(7, xid, n2);
            }
            catch (XAException xAException) {
                this.restoreAutoCommit();
                this.startCount.decrementAndGet();
                throw xAException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heurCommit(Xid xid) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(8, xid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void heurRollback(Xid xid) {
        this.checkClosed();
        DmdbConnection dmdbConnection = this.conn;
        synchronized (dmdbConnection) {
            if (xid == null) {
                DBError.throwXAException(-5);
            }
            this.conn.dbAccess.a(9, xid, 0);
        }
    }

    private void savedAutoCommit() {
        if (this.startCount.longValue() == 0L) {
            this.savedAutoCommit = this.conn.do_getAutoCommit();
            this.conn.do_setAutoCommit(false);
        }
    }

    private void restoreAutoCommit() {
        if (this.startCount.longValue() > 0L) {
            this.conn.do_setAutoCommit(this.savedAutoCommit);
        }
    }
}

