/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleFuture;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.AlreadyExistsException;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import com.datastax.driver.core.exceptions.InvalidConfigurationInQueryException;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import com.datastax.driver.core.exceptions.ReadTimeoutException;
import com.datastax.driver.core.exceptions.SyntaxError;
import com.datastax.driver.core.exceptions.TruncateException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.exceptions.TransportException;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.ErrorMessage;
import org.apache.cassandra.transport.messages.ResultMessage;

public class ResultSetFuture
extends SimpleFuture<ResultSet> {
    private final Session.Manager session;
    final ResponseCallback callback;

    ResultSetFuture(Session.Manager session, Message.Request request) {
        this.session = session;
        this.callback = new ResponseCallback(request);
    }

    public ResultSet getUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                ResultSet resultSet = (ResultSet)super.get();
                return resultSet;
            }
            catch (InterruptedException e) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e2) {
                    ResultSetFuture.extractCauseFromExecutionException(e2);
                    throw new AssertionError();
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        long start = System.nanoTime();
        long timeoutNanos = unit.toNanos(timeout);
        boolean interrupted = false;
        while (true) {
            try {
                ResultSet resultSet = (ResultSet)super.get(timeoutNanos, TimeUnit.NANOSECONDS);
                return resultSet;
            }
            catch (InterruptedException e) {
                try {
                    long now = System.nanoTime();
                    long elapsedNanos = now - start;
                    timeoutNanos -= elapsedNanos;
                    start = now;
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e2) {
                    ResultSetFuture.extractCauseFromExecutionException(e2);
                    throw new AssertionError();
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static void extractCauseFromExecutionException(ExecutionException e) {
        if (e.getCause() instanceof DriverException) {
            throw ((DriverException)e.getCause()).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", e.getCause());
    }

    static void extractCause(Throwable cause) {
        if (cause instanceof DriverException) {
            throw ((DriverException)cause).copy();
        }
        throw new DriverInternalError("Unexpected exception thrown", cause);
    }

    static Exception convertException(TransportException te) {
        switch (te.code()) {
            case SERVER_ERROR: {
                return new DriverInternalError("An unexpected error occured server side: " + te.getMessage());
            }
            case PROTOCOL_ERROR: {
                return new DriverInternalError("An unexpected protocol error occured. This is a bug in this library, please report: " + te.getMessage());
            }
            case UNAVAILABLE: {
                org.apache.cassandra.exceptions.UnavailableException ue = (org.apache.cassandra.exceptions.UnavailableException)te;
                return new UnavailableException(ConsistencyLevel.from(ue.consistency), ue.required, ue.alive);
            }
            case OVERLOADED: {
                return new DriverInternalError("Queried host was overloaded; this shouldn't happen, another node should have been tried");
            }
            case IS_BOOTSTRAPPING: {
                return new DriverInternalError("Queried host was boostrapping; this shouldn't happen, another node should have been tried");
            }
            case TRUNCATE_ERROR: {
                return new TruncateException(te.getMessage());
            }
            case WRITE_TIMEOUT: {
                org.apache.cassandra.exceptions.WriteTimeoutException wte = (org.apache.cassandra.exceptions.WriteTimeoutException)te;
                return new WriteTimeoutException(ConsistencyLevel.from(wte.consistency), WriteType.from(wte.writeType), wte.received, wte.blockFor);
            }
            case READ_TIMEOUT: {
                org.apache.cassandra.exceptions.ReadTimeoutException rte = (org.apache.cassandra.exceptions.ReadTimeoutException)te;
                return new ReadTimeoutException(ConsistencyLevel.from(rte.consistency), rte.received, rte.blockFor, rte.dataPresent);
            }
            case SYNTAX_ERROR: {
                return new SyntaxError(te.getMessage());
            }
            case UNAUTHORIZED: {
                return new UnauthorizedException(te.getMessage());
            }
            case INVALID: {
                return new InvalidQueryException(te.getMessage());
            }
            case CONFIG_ERROR: {
                return new InvalidConfigurationInQueryException(te.getMessage());
            }
            case ALREADY_EXISTS: {
                org.apache.cassandra.exceptions.AlreadyExistsException aee = (org.apache.cassandra.exceptions.AlreadyExistsException)te;
                return new AlreadyExistsException(aee.ksName, aee.cfName);
            }
        }
        return new DriverInternalError("Unknown error return code: " + te.code());
    }

    class ResponseCallback
    implements RequestHandler.Callback {
        private final Message.Request request;

        ResponseCallback(Message.Request request) {
            this.request = request;
        }

        @Override
        public Message.Request request() {
            return this.request;
        }

        @Override
        public void onSet(Connection connection, Message.Response response, ExecutionInfo info) {
            try {
                block1 : switch (response.type) {
                    case RESULT: {
                        ResultMessage rm = (ResultMessage)response;
                        switch (rm.kind) {
                            case SET_KEYSPACE: {
                                ((ResultSetFuture)ResultSetFuture.this).session.poolsState.setKeyspace(((ResultMessage.SetKeyspace)rm).keyspace);
                                ResultSetFuture.this.set(ResultSet.fromMessage(rm, ResultSetFuture.this.session, info));
                                break block1;
                            }
                            case SCHEMA_CHANGE: {
                                ResultMessage.SchemaChange scc = (ResultMessage.SchemaChange)rm;
                                ResultSet rs = ResultSet.fromMessage(rm, ResultSetFuture.this.session, info);
                                switch (scc.change) {
                                    case CREATED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, null, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                        break block1;
                                    }
                                    case DROPPED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, null, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                        break block1;
                                    }
                                    case UPDATED: {
                                        if (scc.columnFamily.isEmpty()) {
                                            ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, null);
                                            break block1;
                                        }
                                        ((ResultSetFuture)ResultSetFuture.this).session.cluster.manager.refreshSchema(connection, ResultSetFuture.this, rs, scc.keyspace, scc.columnFamily);
                                    }
                                }
                                break block1;
                            }
                        }
                        ResultSetFuture.this.set(ResultSet.fromMessage(rm, ResultSetFuture.this.session, info));
                        break;
                    }
                    case ERROR: {
                        ResultSetFuture.this.setException(ResultSetFuture.convertException(((ErrorMessage)response).error));
                        break;
                    }
                    default: {
                        connection.defunct(new ConnectionException(connection.address, String.format("Got unexpected %s response", response.type)));
                        ResultSetFuture.this.setException(new DriverInternalError(String.format("Got unexpected %s response from %s", response.type, connection.address)));
                    }
                }
            }
            catch (RuntimeException e) {
                ResultSetFuture.this.setException(new DriverInternalError("Unexpected error while processing response from " + connection.address, e));
            }
        }

        @Override
        public void onSet(Connection connection, Message.Response response) {
            this.onSet(connection, response, null);
        }

        @Override
        public void onException(Connection connection, Exception exception) {
            ResultSetFuture.this.setException(exception);
        }
    }
}

