/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.querybuilder;

import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Select
extends BuiltStatement {
    private static final List<String> COUNT_ALL = Collections.singletonList("count(*)");
    private final String keyspace;
    private final String table;
    private final List<String> columnNames;
    private final Where where;
    private List<Ordering> orderings;
    private int limit = -1;
    private boolean allowFiltering;

    Select(String keyspace, String table, List<String> columnNames) {
        this.keyspace = keyspace;
        this.table = table;
        this.columnNames = columnNames;
        this.where = new Where(this);
    }

    Select(TableMetadata table, List<String> columnNames) {
        super(table);
        this.keyspace = table.getKeyspace().getName();
        this.table = table.getName();
        this.columnNames = columnNames;
        this.where = new Where(this);
    }

    @Override
    protected String buildQueryString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT ");
        if (this.columnNames == null) {
            builder.append("*");
        } else {
            Utils.joinAndAppendNames(builder, ",", this.columnNames);
        }
        builder.append(" FROM ");
        if (this.keyspace != null) {
            Utils.appendName(this.keyspace, builder).append(".");
        }
        Utils.appendName(this.table, builder);
        if (!this.where.clauses.isEmpty()) {
            builder.append(" WHERE ");
            Utils.joinAndAppend(builder, " AND ", this.where.clauses);
        }
        if (this.orderings != null) {
            builder.append(" ORDER BY ");
            Utils.joinAndAppend(builder, ",", this.orderings);
        }
        if (this.limit > 0) {
            builder.append(" LIMIT ").append(this.limit);
        }
        if (this.allowFiltering) {
            builder.append(" ALLOW FILTERING");
        }
        return builder.toString();
    }

    public Where where(Clause clause) {
        return this.where.and(clause);
    }

    public Where where() {
        return this.where;
    }

    public Select orderBy(Ordering ... orderings) {
        if (this.orderings != null) {
            throw new IllegalStateException("An ORDER BY clause has already been provided");
        }
        this.orderings = Arrays.asList(orderings);
        this.setDirty();
        return this;
    }

    public Select limit(int limit) {
        if (limit <= 0) {
            throw new IllegalArgumentException("Invalid LIMIT value, must be strictly positive");
        }
        if (this.limit > 0) {
            throw new IllegalStateException("A LIMIT value has already been provided");
        }
        this.limit = limit;
        this.setDirty();
        return this;
    }

    public Select allowFiltering() {
        this.allowFiltering = true;
        return this;
    }

    public static class Selection
    extends Builder {
        public Builder all() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            return this;
        }

        public Builder countAll() {
            if (this.columnNames != null) {
                throw new IllegalStateException(String.format("Some columns (%s) have already been selected.", this.columnNames));
            }
            this.columnNames = COUNT_ALL;
            return this;
        }

        public Selection column(String name) {
            if (this.columnNames == null) {
                this.columnNames = new ArrayList();
            }
            this.columnNames.add(name);
            return this;
        }

        public Selection writeTime(String name) {
            StringBuilder sb = new StringBuilder();
            sb.append("writetime(");
            Utils.appendName(name, sb);
            sb.append(")");
            return this.column(sb.toString());
        }

        public Selection ttl(String name) {
            StringBuilder sb = new StringBuilder();
            sb.append("ttl(");
            Utils.appendName(name, sb);
            sb.append(")");
            return this.column(sb.toString());
        }
    }

    public static class Builder {
        protected List<String> columnNames;

        protected Builder() {
        }

        Builder(List<String> columnNames) {
            this.columnNames = columnNames;
        }

        public Select from(String table) {
            return this.from(null, table);
        }

        public Select from(String keyspace, String table) {
            return new Select(keyspace, table, this.columnNames);
        }

        public Select from(TableMetadata table) {
            return new Select(table, this.columnNames);
        }
    }

    public static class Where
    extends BuiltStatement.ForwardingStatement<Select> {
        private final List<Clause> clauses = new ArrayList<Clause>();

        Where(Select statement) {
            super(statement);
        }

        public Where and(Clause clause) {
            this.clauses.add(clause);
            ((Select)this.statement).maybeAddRoutingKey(clause.name(), clause.firstValue());
            this.setDirty();
            return this;
        }

        public Select orderBy(Ordering ... orderings) {
            return ((Select)this.statement).orderBy(orderings);
        }

        public Select limit(int limit) {
            return ((Select)this.statement).limit(limit);
        }
    }
}

